/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.util.viewer.model;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.LanguageVersion;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.ParseException;
import net.sourceforge.pmd.lang.ast.xpath.DocumentNavigator;
import net.sourceforge.pmd.util.viewer.model.ViewerModelEvent;
import net.sourceforge.pmd.util.viewer.model.ViewerModelListener;
import org.jaxen.BaseXPath;
import org.jaxen.JaxenException;

@Deprecated
public class ViewerModel {
    private static final Logger LOGGER = Logger.getLogger(ViewerModel.class.getName());
    private List<ViewerModelListener> listeners = new ArrayList<ViewerModelListener>(5);
    private Node rootNode;
    private List<Node> evaluationResults;

    public Node getRootNode() {
        return this.rootNode;
    }

    public void commitSource(String source, LanguageVersion languageVersion) {
        Node node;
        LanguageVersionHandler languageVersionHandler = languageVersion.getLanguageVersionHandler();
        this.rootNode = node = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).parse(null, new StringReader(source));
        this.fireViewerModelEvent(new ViewerModelEvent(this, 1));
    }

    public boolean hasCompiledTree() {
        return this.rootNode != null;
    }

    public void evaluateXPathExpression(String xPath, Object evaluator) throws ParseException, JaxenException {
        try {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("xPath=" + xPath);
                LOGGER.finest("evaluator=" + evaluator);
            }
            BaseXPath xpath = new BaseXPath(xPath, new DocumentNavigator());
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("xpath=" + xpath);
                LOGGER.finest("rootNode=" + this.rootNode);
            }
            try {
                this.evaluationResults = xpath.selectNodes(this.rootNode);
            }
            catch (Exception e) {
                LOGGER.finest("selectNodes problem:");
                e.printStackTrace(System.err);
            }
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("evaluationResults=" + this.evaluationResults);
            }
            this.fireViewerModelEvent(new ViewerModelEvent(evaluator, 4));
        }
        catch (JaxenException je) {
            je.printStackTrace(System.err);
            throw je;
        }
    }

    public List<Node> getLastEvaluationResults() {
        return this.evaluationResults;
    }

    public void selectNode(Node node, Object selector) {
        this.fireViewerModelEvent(new ViewerModelEvent(selector, 2, node));
    }

    public void appendToXPathExpression(String pathFragment, Object appender) {
        this.fireViewerModelEvent(new ViewerModelEvent(appender, 3, pathFragment));
    }

    public void addViewerModelListener(ViewerModelListener l) {
        this.listeners.add(l);
    }

    public void removeViewerModelListener(ViewerModelListener l) {
        this.listeners.remove(l);
    }

    protected void fireViewerModelEvent(ViewerModelEvent e) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).viewerModelChanged(e);
        }
    }
}

