/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.layouters;

import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.openjdk.jol.datamodel.DataModel;
import org.openjdk.jol.info.ClassData;
import org.openjdk.jol.info.ClassLayout;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.info.FieldLayout;
import org.openjdk.jol.layouters.Layouter;
import org.openjdk.jol.util.MathUtil;

public class HotSpotLayouter
implements Layouter {
    private final DataModel model;
    private final boolean takeHierarchyGaps;
    private final boolean takeSuperGaps;
    private final boolean autoAlign;

    public HotSpotLayouter(DataModel model) {
        this(model, false, false, false);
    }

    public HotSpotLayouter(DataModel model, boolean takeHierarchyGaps, boolean takeSuperGaps, boolean autoAlign) {
        this.model = model;
        this.takeHierarchyGaps = takeHierarchyGaps;
        this.takeSuperGaps = takeSuperGaps;
        this.autoAlign = autoAlign;
    }

    @Override
    public ClassLayout layout(ClassData cd) {
        int instanceSize;
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (cd.isArray()) {
            int base = this.model.arrayHeaderSize();
            int scale = this.model.sizeOf(cd.arrayComponentType());
            int instanceSize2 = base + cd.arrayLength() * scale;
            instanceSize2 = MathUtil.align(instanceSize2, this.autoAlign ? Math.max(this.model.objectAlignment(), scale) : this.model.objectAlignment());
            base = MathUtil.align(base, Math.max(4, scale));
            result.add(new FieldLayout(FieldData.create(cd.arrayClass(), "<elements>", cd.arrayComponentType()), base, scale * cd.arrayLength()));
            return new ClassLayout(cd, result, this.model.arrayHeaderSize(), instanceSize2, false);
        }
        List<String> hierarchy = cd.classHierarchy();
        BitSet claimed = new BitSet();
        claimed.set(0, this.model.headerSize());
        for (String k : hierarchy) {
            Collection<FieldData> fields = cd.fieldsFor(k);
            TreeSet<FieldLayout> current = new TreeSet<FieldLayout>();
            for (int size : new int[]{8, 4, 2, 1}) {
                block2: for (FieldData f : fields) {
                    int fSize = this.model.sizeOf(f.typeClass());
                    if (fSize != size) continue;
                    for (int t = 0; t < Integer.MAX_VALUE; ++t) {
                        if (!claimed.get(t * size, (t + 1) * size).isEmpty()) continue;
                        claimed.set(t * size, (t + 1) * size);
                        current.add(new FieldLayout(f, t * size, size));
                        continue block2;
                    }
                }
            }
            result.addAll(current);
            if (this.takeSuperGaps) continue;
            if (this.takeHierarchyGaps) {
                int lastSet = claimed.length();
                claimed.set(0, lastSet);
                continue;
            }
            int lastSet = claimed.length();
            claimed.set(0, MathUtil.align(lastSet, this.model.sizeOf("java.lang.Object")));
        }
        if (this.autoAlign) {
            int a = 4;
            for (FieldLayout f : result) {
                a = Math.max(a, this.model.sizeOf(f.typeClass()));
            }
            instanceSize = MathUtil.align(claimed.length(), a);
        } else {
            instanceSize = MathUtil.align(claimed.length(), this.model.objectAlignment());
        }
        return new ClassLayout(cd, result, this.model.headerSize(), instanceSize, true);
    }

    public String toString() {
        return "VM Layout Simulation (" + this.model + (this.takeHierarchyGaps ? ", hierarchy gaps" : "") + (this.takeSuperGaps ? ", super gaps" : "") + (this.autoAlign ? ", autoalign" : "") + ")";
    }
}

