/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.bestpractices;

import java.util.ArrayList;
import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTReferenceExpression;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableDeclaration;
import net.sourceforge.pmd.lang.apex.ast.ASTVariableExpression;
import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import org.apache.commons.lang3.StringUtils;

public class UnusedLocalVariableRule
extends AbstractApexRule {
    public UnusedLocalVariableRule() {
        this.addRuleChainVisit(ASTVariableDeclaration.class);
    }

    @Override
    public Object visit(ASTVariableDeclaration node, Object data) {
        String variableName = node.getImage();
        ASTBlockStatement variableContext = (ASTBlockStatement)node.getFirstParentOfType(ASTBlockStatement.class);
        if (variableContext == null) {
            return data;
        }
        ArrayList potentialUsages = new ArrayList();
        potentialUsages.addAll(variableContext.findDescendantsOfType(ASTVariableExpression.class));
        potentialUsages.addAll(variableContext.findDescendantsOfType(ASTReferenceExpression.class));
        for (ApexNode usage : potentialUsages) {
            if (usage.getParent() == node || !StringUtils.equalsIgnoreCase((CharSequence)variableName, (CharSequence)usage.getImage())) continue;
            return data;
        }
        this.addViolation(data, node, variableName);
        return data;
    }
}

