/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.errorprone;

import net.sourceforge.pmd.lang.apex.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.apex.ast.ASTMethod;
import net.sourceforge.pmd.lang.apex.ast.ASTUserClass;
import net.sourceforge.pmd.lang.apex.rule.AbstractApexRule;
import net.sourceforge.pmd.lang.apex.rule.internal.Helper;
import net.sourceforge.pmd.properties.MultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;

public class ApexCSRFRule
extends AbstractApexRule {
    public static final String INIT = "init";
    private static final String STATIC_INITIALIZER = "<clinit>";

    public ApexCSRFRule() {
        this.setProperty((MultiValuePropertyDescriptor)CODECLIMATE_CATEGORIES, new String[]{"Security"});
        this.setProperty((PropertyDescriptor)CODECLIMATE_REMEDIATION_MULTIPLIER, 100);
        this.setProperty((PropertyDescriptor)CODECLIMATE_BLOCK_HIGHLIGHTING, false);
    }

    @Override
    public Object visit(ASTUserClass node, Object data) {
        if (Helper.isTestMethodOrClass(node) || Helper.isSystemLevelClass(node)) {
            return data;
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTMethod node, Object data) {
        if (!Helper.isTestMethodOrClass(node)) {
            this.checkForCSRF(node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTBlockStatement node, Object data) {
        if (node.getParent() instanceof ASTUserClass && Helper.foundAnyDML(node)) {
            this.addViolation(data, node);
        }
        return data;
    }

    private void checkForCSRF(ASTMethod node, Object data) {
        String name;
        if (node.isConstructor() && Helper.foundAnyDML(node)) {
            this.addViolation(data, node);
        }
        if (this.isInitializerMethod(name = node.getImage()) && Helper.foundAnyDML(node)) {
            this.addViolation(data, node);
        }
    }

    private boolean isInitializerMethod(String name) {
        return INIT.equalsIgnoreCase(name) || STATIC_INITIALIZER.equals(name);
    }
}

