/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBlockStatement;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTEnumDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTExplicitConstructorInvocation;
import net.sourceforge.pmd.lang.java.ast.ASTNameList;
import net.sourceforge.pmd.lang.java.rule.AbstractIgnoredAnnotationRule;

public class UnnecessaryConstructorRule
extends AbstractIgnoredAnnotationRule {
    @Override
    protected Collection<String> defaultSuppressionAnnotations() {
        return Collections.singletonList("javax.inject.Inject");
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        ASTConstructorDeclaration cons = (ASTConstructorDeclaration)node.getFirstDescendantOfType(ASTConstructorDeclaration.class);
        if (this.isExplicitDefaultConstructor(node) && this.haveSameAccessModifier(node, cons)) {
            this.addViolation(data, cons);
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTEnumDeclaration node, Object data) {
        ASTConstructorDeclaration cons = (ASTConstructorDeclaration)node.getFirstDescendantOfType(ASTConstructorDeclaration.class);
        if (this.isExplicitDefaultConstructor(node) && cons.isPrivate()) {
            this.addViolation(data, cons);
        }
        return super.visit(node, data);
    }

    private boolean isExplicitDefaultConstructor(Node node) {
        List nodes = node.findDescendantsOfType(ASTConstructorDeclaration.class);
        if (nodes.size() != 1) {
            return false;
        }
        ASTConstructorDeclaration cdnode = (ASTConstructorDeclaration)nodes.get(0);
        return cdnode.getArity() == 0 && !this.hasIgnoredAnnotation(cdnode) && !cdnode.hasDescendantOfType(ASTBlockStatement.class) && !cdnode.hasDescendantOfType(ASTNameList.class) && this.hasDefaultConstructorInvocation(cdnode);
    }

    private boolean hasDefaultConstructorInvocation(ASTConstructorDeclaration cons) {
        ASTExplicitConstructorInvocation inv = (ASTExplicitConstructorInvocation)cons.getFirstChildOfType(ASTExplicitConstructorInvocation.class);
        return inv == null || inv.isSuper() && inv.getArgumentCount() == 0;
    }

    private boolean haveSameAccessModifier(ASTClassOrInterfaceDeclaration node, ASTConstructorDeclaration cons) {
        return node.isPrivate() && cons.isPrivate() || node.isProtected() && cons.isProtected() || node.isPublic() && cons.isPublic() || node.isPackagePrivate() && cons.isPackagePrivate();
    }
}

