/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAssignmentOperator;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTPostfixExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreDecrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPreIncrementExpression;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class AssignmentInOperandRule
extends AbstractJavaRule {
    private static final PropertyDescriptor<Boolean> ALLOW_IF_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIf").desc("Allow assignment within the conditional expression of an if statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_FOR_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowFor").desc("Allow assignment within the conditional expression of a for statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_WHILE_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowWhile").desc("Allow assignment within the conditional expression of a while statement")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<Boolean> ALLOW_INCREMENT_DECREMENT_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"allowIncrementDecrement").desc("Allow increment or decrement operators within the conditional expression of an if, for, or while statement")).defaultValue((Object)false)).build();

    public AssignmentInOperandRule() {
        this.definePropertyDescriptor(ALLOW_IF_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_FOR_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_WHILE_DESCRIPTOR);
        this.definePropertyDescriptor(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTExpression node, Object data) {
        Node parent = node.getParent();
        if ((parent instanceof ASTIfStatement && (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) == false || parent instanceof ASTWhileStatement && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) == false || parent instanceof ASTForStatement && parent.getChild(1) == node && !((Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR)).booleanValue()) && (node.hasDescendantOfType(ASTAssignmentOperator.class) || !((Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR)).booleanValue() && node.hasDescendantOfAnyType(new Class[]{ASTPreIncrementExpression.class, ASTPreDecrementExpression.class, ASTPostfixExpression.class}))) {
            this.addViolation(data, (Node)node);
            return data;
        }
        return super.visit(node, data);
    }

    public boolean allowsAllAssignments() {
        return (Boolean)this.getProperty(ALLOW_IF_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_FOR_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_WHILE_DESCRIPTOR) != false && (Boolean)this.getProperty(ALLOW_INCREMENT_DECREMENT_DESCRIPTOR) != false;
    }

    public String dysfunctionReason() {
        return this.allowsAllAssignments() ? "All assignment types allowed, no checks performed" : null;
    }
}

