/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import apex.common.base.MoreStrings;
import apex.common.collect.HashedMap;

public class CaseInsensitiveMap<V>
extends HashedMap<String, V> {
    private static final long serialVersionUID = 1735666087652457788L;

    public CaseInsensitiveMap() {
    }

    public CaseInsensitiveMap(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected int hash(Object key) {
        if (!(key instanceof String)) {
            return -1;
        }
        String methodName = (String)key;
        return MoreStrings.lowerCaseHashCode(methodName);
    }

    @Override
    protected boolean isEqualKey(Object left, Object right) {
        if (!(left instanceof String)) {
            return false;
        }
        if (!(right instanceof String)) {
            return false;
        }
        if (left == right) {
            return true;
        }
        String leftMethodName = (String)left;
        String rightMethodName = (String)right;
        return MoreStrings.equalsIgnoreCase(leftMethodName, rightMethodName);
    }
}

