/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member;

import apex.common.base.Result;
import apex.common.base.VoidResult;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoTables;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.services.I18nSupport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreSets;
import java.util.Set;

public class IdentifierValidator {
    @VisibleForTesting
    static final int MAX_LENGTH = 255;
    @VisibleForTesting
    static final Set<String> RESERVED = MoreSets.toImmutableCaseInsensitiveSet((Set<String>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("array")).add("activate")).add("any")).add("autonomous")).add("begin")).add("bigDecimal")).add("bulk")).add("byte")).add("case")).add("cast")).add("char")).add("collect")).add("commit")).add("const")).add("default")).add("desc")).add("end")).add("export")).add("exception")).add("exit")).add("float")).add("goto")).add("group")).add("having")).add("hint")).add("int")).add("into")).add("inner")).add("import")).add("join")).add("loop")).add("number")).add("object")).add("outer")).add("of")).add("package")).add("parallel")).add("pragma")).add("retrieve")).add("rollback")).add("sort")).add("short")).add("super")).add("switch")).add("system")).add("synchronized")).add("transaction")).add("this")).add("then")).add("when")).build()));
    @VisibleForTesting
    static final Set<String> RESERVED_TYPE = MoreSets.toImmutableCaseInsensitiveSet((Set<String>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("apexPages")).add("page")).build()));
    @VisibleForTesting
    static final Set<TypeInfo> VALID_SCALAR_AS_IDENTIFIERS = ((ImmutableSet.Builder)ImmutableSet.builder().add(TypeInfos.ID)).build();
    @VisibleForTesting
    static final int MAX_CLASS_LENGTH = 40;
    private static final IdentifierValidator INSTANCE = new IdentifierValidator();
    private static final Set<String> KEY_WORD = MoreSets.toImmutableCaseInsensitiveSet((Set<String>)((Object)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("trigger")).add("insert")).add("update")).add("upsert")).add("delete")).add("undelete")).add("merge")).add("new")).add("for")).add("select")).build()));

    private IdentifierValidator() {
    }

    public static IdentifierValidator get() {
        return INSTANCE;
    }

    private static String trim(String string) {
        char c;
        int start;
        if (string == null) {
            return "";
        }
        int end = string.length();
        for (start = 0; start < end && Character.isWhitespace(c = string.charAt(start)); ++start) {
        }
        while (start < end && Character.isWhitespace(c = string.charAt(end - 1))) {
            --end;
        }
        return string.substring(start, end);
    }

    private static boolean isLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    Check check(TypeInfo definingType, String name, Type type, boolean isTopLevel, boolean ignoreCheck) {
        boolean hasValidCharacters = this.hasValidCharacters(name);
        if (!definingType.getCodeUnitDetails().isFileBased() && !hasValidCharacters) {
            return Check.INVALID_CHARACTER;
        }
        if (KEY_WORD.contains(name)) {
            return Check.KEYWORD;
        }
        if (type != Type.METHOD && !ignoreCheck && (RESERVED.contains(name) || this.isReservedBasic(definingType, name))) {
            return Check.RESERVED_NAME;
        }
        if ((type == Type.CLASS || type == Type.INTERFACE || type == Type.EXCEPTION) && RESERVED_TYPE.contains(name)) {
            return Check.RESERVED_TYPE;
        }
        if (name.length() > this.getMaxLength(definingType, type, isTopLevel)) {
            return Check.TOO_LONG;
        }
        return Check.VALID;
    }

    public Result<Void> validate(TypeInfo definingType, String name, Type type, boolean isTopLevel, boolean ignoreCheck) {
        Check check = this.check(definingType, name, type, isTopLevel, ignoreCheck);
        if (check != Check.VALID) {
            return VoidResult.error(I18nSupport.getLabel(check.getLabel(), name));
        }
        return VoidResult.of();
    }

    private boolean isReservedBasic(TypeInfo definingType, String name) {
        TypeInfo type = TypeInfoTables.TYPES_BY_APEX_NAME.get(name);
        return type != null && !VALID_SCALAR_AS_IDENTIFIERS.contains(type) && definingType.getCodeUnitDetails().getVersion().isGreaterThanOrEqual(type.getBasicType().getMinVersion());
    }

    boolean hasValidCharacters(String untrimmedName) {
        String name = IdentifierValidator.trim(untrimmedName);
        if (name.isEmpty()) {
            return false;
        }
        int lastChar = 120;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (i == 0 && !IdentifierValidator.isLetter(c)) {
                return false;
            }
            if (!IdentifierValidator.isLetter(c) && !IdentifierValidator.isDigit(c) && c != '_') {
                return false;
            }
            if (lastChar == 95 && c == '_') {
                return false;
            }
            lastChar = c;
        }
        return lastChar != 95;
    }

    private Integer getMaxLength(TypeInfo definingType, Type type, boolean isTopLevel) {
        switch (type) {
            case EXCEPTION: 
            case ENUM: 
            case CLASS: 
            case INTERFACE: {
                if (!isTopLevel || definingType.getCodeUnitDetails().isFileBased()) {
                    return 255;
                }
                return 40;
            }
            case METHOD: 
            case VARIABLE: 
            case CONSTRUCTOR: 
            case TRIGGER: 
            case URL_MAPPING: {
                return 255;
            }
        }
        throw new UnexpectedCodePathException();
    }

    public static enum Type {
        METHOD,
        EXCEPTION,
        VARIABLE,
        CLASS,
        INTERFACE,
        CONSTRUCTOR,
        ENUM,
        TRIGGER,
        URL_MAPPING;

    }

    public static final class Check
    extends Enum<Check> {
        public static final /* enum */ Check INVALID_CHARACTER = new Check("invalid.character.identifier");
        public static final /* enum */ Check RESERVED_NAME = new Check("invalid.reserved.name.identifier");
        public static final /* enum */ Check RESERVED_TYPE = new Check("invalid.reserved.type.identifier");
        public static final /* enum */ Check TOO_LONG = new Check("identifier.too.long");
        public static final /* enum */ Check KEYWORD = new Check("invalid.keyword.identifier");
        public static final /* enum */ Check VALID = new Check("");
        private final String label;
        private static final /* synthetic */ Check[] $VALUES;

        public static Check[] values() {
            return (Check[])$VALUES.clone();
        }

        public static Check valueOf(String name) {
            return Enum.valueOf(Check.class, name);
        }

        private Check(String label) {
            this.label = label;
        }

        public String getLabel() {
            assert (!Strings.isNullOrEmpty(this.label));
            return this.label;
        }

        static {
            $VALUES = new Check[]{INVALID_CHARACTER, RESERVED_NAME, RESERVED_TYPE, TOO_LONG, KEYWORD, VALID};
        }
    }
}

