/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.naming;

import apex.jorje.semantic.common.SfdcCalled;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.compiler.Namespaces;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;

public class TypeNameFactory {
    public static final String TRIGGER_NAMESPACE = "__sfdc_trigger";
    @SfdcCalled
    public static final String TRIGGER_PREFIX = "__sfdc_trigger/";
    public static final String ANONYMOUS_BLOCK_NAME = "anon";

    private TypeNameFactory() {
    }

    public static String createApexName(Namespace namespace, TypeInfo enclosingType, UnitType unitType, String name) {
        if (unitType == UnitType.ANONYMOUS) {
            assert (enclosingType == null) : "anonymous cannot be an inner type";
            return ANONYMOUS_BLOCK_NAME;
        }
        StringBuilder builder = new StringBuilder();
        if (enclosingType != null && enclosingType.getUnitType() != UnitType.ANONYMOUS) {
            assert (Namespace.equals(namespace, enclosingType.getNamespace())) : "inner type must match top level type's namespace";
            builder.append(enclosingType.getApexName()).append('.');
        } else if (!Namespace.isEmptyOrNull(namespace)) {
            builder.append(namespace.getGlobal()).append('.');
            if (namespace.hasModule()) {
                builder.append(namespace.getModule()).append('.');
            }
        }
        return builder.append(name).toString();
    }

    public static String createBytecodeName(Namespace namespace, TypeInfo enclosingType, UnitType unitType, String name) {
        if (unitType == UnitType.ANONYMOUS) {
            assert (enclosingType == null) : "anonymous cannot be an inner type";
            return ANONYMOUS_BLOCK_NAME;
        }
        StringBuilder builder = new StringBuilder();
        if (unitType == UnitType.TRIGGER) {
            assert (enclosingType == null) : "trigger cannot be an inner type";
            builder.append(TRIGGER_PREFIX);
        }
        if (enclosingType != null) {
            assert (Namespace.equals(namespace, enclosingType.getNamespace())) : "inner type must match top level type's namespace";
            builder.append(enclosingType.getBytecodeName()).append("$");
        } else if (!Namespace.isEmptyOrNull(namespace)) {
            if (Namespaces.FLOW.equalsGlobal(namespace) && namespace.hasModule()) {
                builder.append(namespace.getGlobal()).append('/').append(namespace.getModule().replace('.', '/')).append('/');
            } else {
                builder.append(namespace.getGlobal()).append('/');
                if (namespace.hasModule()) {
                    builder.append(namespace.getModule()).append('/');
                }
            }
        }
        return builder.append(name).toString();
    }

    public static String toBytecodeName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static boolean isFullyQualified(int numOfProvidedNames, TypeInfo referencingType, TypeInfo referredType) {
        int size = 1;
        if (TypeInfoUtil.isInnerType(referredType)) {
            ++size;
        }
        if (!(Namespace.isEmptyOrNull(referredType.getNamespace()) || Namespace.equals(referencingType, referredType) || Namespace.equals(Namespaces.SYSTEM, referredType.getNamespace()))) {
            ++size;
        }
        return size <= numOfProvidedNames;
    }
}

