/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTUnaryExpressionNotPlusMinus;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;

public class AvoidMultipleUnaryOperatorsRule
extends AbstractJavaRule {
    public AvoidMultipleUnaryOperatorsRule() {
        this.addRuleChainVisit(ASTUnaryExpression.class);
        this.addRuleChainVisit(ASTUnaryExpressionNotPlusMinus.class);
    }

    @Override
    public Object visit(ASTUnaryExpression node, Object data) {
        this.checkUnaryDescendent((Node)node, data);
        return data;
    }

    @Override
    public Object visit(ASTUnaryExpressionNotPlusMinus node, Object data) {
        this.checkUnaryDescendent((Node)node, data);
        return data;
    }

    private void checkUnaryDescendent(Node node, Object data) {
        boolean match = false;
        if (node.getNumChildren() == 1) {
            Node child = node.getChild(0);
            if (child instanceof ASTUnaryExpression || child instanceof ASTUnaryExpressionNotPlusMinus) {
                match = true;
            } else if (child instanceof ASTPrimaryExpression) {
                Node primaryExpression = child;
                while (primaryExpression.getNumChildren() == 1 && primaryExpression.getChild(0) instanceof ASTPrimaryPrefix && primaryExpression.getChild(0).getNumChildren() == 1 && primaryExpression.getChild(0).getChild(0) instanceof ASTExpression && primaryExpression.getChild(0).getChild(0).getNumChildren() == 1) {
                    Node candidate = primaryExpression.getChild(0).getChild(0).getChild(0);
                    if (candidate instanceof ASTUnaryExpression || candidate instanceof ASTUnaryExpressionNotPlusMinus) {
                        match = true;
                        break;
                    }
                    if (!(candidate instanceof ASTPrimaryExpression)) break;
                    primaryExpression = candidate;
                }
            }
        }
        if (match) {
            this.addViolation(data, node);
        }
    }
}

