/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.pmd.properties.GenericMultiValuePropertyDescriptor;
import net.sourceforge.pmd.properties.GenericPropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.ValueParser;
import net.sourceforge.pmd.properties.ValueParserConstants;
import net.sourceforge.pmd.properties.constraints.PropertyConstraint;
import org.apache.commons.lang3.StringUtils;

public abstract class PropertyBuilder<B extends PropertyBuilder<B, T>, T> {
    private static final Pattern NAME_PATTERN = Pattern.compile("[a-zA-Z][\\w-]*");
    private final Set<PropertyConstraint<? super T>> validators = new LinkedHashSet<PropertyConstraint<? super T>>();
    protected boolean isDefinedExternally;
    private String name;
    private String description;
    private T defaultValue;

    PropertyBuilder(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name must be provided");
        }
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid name '" + name + "'");
        }
        this.name = name;
    }

    void setDefinedExternally(boolean bool) {
        this.isDefinedExternally = bool;
    }

    Set<PropertyConstraint<? super T>> getConstraints() {
        return this.validators;
    }

    String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            throw new IllegalArgumentException("Description must be provided");
        }
        return this.description;
    }

    T getDefaultValue() {
        if (!this.isDefaultValueSet()) {
            throw new IllegalArgumentException("A default value must be provided");
        }
        return this.defaultValue;
    }

    boolean isDefaultValueSet() {
        return this.defaultValue != null;
    }

    public B desc(String desc) {
        if (StringUtils.isBlank((CharSequence)desc)) {
            throw new IllegalArgumentException("Description must be provided");
        }
        this.description = desc;
        return (B)this;
    }

    public B require(PropertyConstraint<? super T> constraint) {
        this.validators.add(constraint);
        return (B)this;
    }

    public B defaultValue(T val) {
        if (val == null) {
            throw new IllegalArgumentException("Property values may not be null.");
        }
        this.defaultValue = val;
        return (B)this;
    }

    public abstract PropertyDescriptor<T> build();

    public String getName() {
        return this.name;
    }

    public static final class GenericCollectionPropertyBuilder<V, C extends Collection<V>>
    extends PropertyBuilder<GenericCollectionPropertyBuilder<V, C>, C> {
        private final ValueParser<V> parser;
        private final Supplier<C> emptyCollSupplier;
        private final Class<V> type;
        private char multiValueDelimiter = (char)124;

        GenericCollectionPropertyBuilder(String name, ValueParser<V> parser, Supplier<C> emptyCollSupplier, Class<V> type) {
            super(name);
            this.parser = parser;
            this.emptyCollSupplier = emptyCollSupplier;
            this.type = type;
        }

        private C getDefaultValue(Collection<? extends V> list) {
            Collection coll = (Collection)this.emptyCollSupplier.get();
            coll.addAll(list);
            return (C)coll;
        }

        @Override
        public GenericCollectionPropertyBuilder<V, C> defaultValue(Collection<? extends V> val) {
            super.defaultValue(this.getDefaultValue(val));
            return this;
        }

        public GenericCollectionPropertyBuilder<V, C> defaultValues(V head, V ... tail) {
            ArrayList<V> tmp = new ArrayList<V>(tail.length + 1);
            tmp.add(head);
            tmp.addAll(Arrays.asList(tail));
            return (GenericCollectionPropertyBuilder)super.defaultValue(this.getDefaultValue(tmp));
        }

        public GenericCollectionPropertyBuilder<V, C> emptyDefaultValue() {
            return (GenericCollectionPropertyBuilder)super.defaultValue(this.getDefaultValue(Collections.emptyList()));
        }

        public GenericCollectionPropertyBuilder<V, C> requireEach(PropertyConstraint<? super V> constraint) {
            return (GenericCollectionPropertyBuilder)super.require(constraint.toCollectionConstraint());
        }

        @Deprecated
        public GenericCollectionPropertyBuilder<V, C> delim(char delim) {
            this.multiValueDelimiter = delim;
            return this;
        }

        @Override
        public PropertyDescriptor<C> build() {
            return new GenericMultiValuePropertyDescriptor(this.getName(), this.getDescription(), 0.0f, (Collection)this.getDefaultValue(), this.getConstraints(), this.parser, this.multiValueDelimiter, this.type);
        }

        @Deprecated
        static interface Supplier<T> {
            public T get();
        }
    }

    public static final class RegexPropertyBuilder
    extends BaseSinglePropertyBuilder<RegexPropertyBuilder, Pattern> {
        RegexPropertyBuilder(String name) {
            super(name, ValueParserConstants.REGEX_PARSER, Pattern.class);
        }

        @Override
        public RegexPropertyBuilder defaultValue(String pattern) {
            super.defaultValue(Pattern.compile(pattern));
            return this;
        }

        public RegexPropertyBuilder defaultValue(String pattern, int flags) {
            super.defaultValue(Pattern.compile(pattern, flags));
            return this;
        }
    }

    public static final class GenericPropertyBuilder<T>
    extends BaseSinglePropertyBuilder<GenericPropertyBuilder<T>, T> {
        GenericPropertyBuilder(String name, ValueParser<T> parser, Class<T> type) {
            super(name, parser, type);
        }
    }

    static abstract class BaseSinglePropertyBuilder<B extends PropertyBuilder<B, T>, T>
    extends PropertyBuilder<B, T> {
        private final ValueParser<T> parser;
        private final Class<T> type;

        BaseSinglePropertyBuilder(String name, ValueParser<T> parser, Class<T> type) {
            super(name);
            this.parser = parser;
            this.type = type;
        }

        protected ValueParser<T> getParser() {
            return this.parser;
        }

        protected Class<T> getType() {
            return this.type;
        }

        GenericCollectionPropertyBuilder<T, List<T>> toList() {
            GenericCollectionPropertyBuilder.Supplier listSupplier = new GenericCollectionPropertyBuilder.Supplier<List<T>>(){

                @Override
                public List<T> get() {
                    return new ArrayList();
                }
            };
            return this.toCollection(listSupplier);
        }

        private <C extends Collection<T>> GenericCollectionPropertyBuilder<T, C> toCollection(GenericCollectionPropertyBuilder.Supplier<C> emptyCollSupplier) {
            if (this.isDefaultValueSet()) {
                throw new IllegalStateException("The default value is already set!");
            }
            GenericCollectionPropertyBuilder result = new GenericCollectionPropertyBuilder(this.getName(), this.getParser(), emptyCollSupplier, this.getType());
            for (PropertyConstraint validator : this.getConstraints()) {
                result.require(validator.toCollectionConstraint());
            }
            return result;
        }

        @Override
        public PropertyDescriptor<T> build() {
            return new GenericPropertyDescriptor(this.getName(), this.getDescription(), 0.0f, this.getDefaultValue(), this.getConstraints(), this.parser, this.isDefinedExternally, this.type);
        }
    }
}

