/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.member;

import apex.common.collect.Comparables;
import apex.jorje.data.Identifier;
import apex.jorje.data.Locatable;
import apex.jorje.data.Location;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.semantic.ast.member.AccessorFactory;
import apex.jorje.semantic.ast.member.Property;
import apex.jorje.semantic.ast.modifier.ModifierGroup;
import apex.jorje.semantic.ast.modifier.OldModifiers;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import com.google.common.annotations.VisibleForTesting;
import java.util.Comparator;

public class PropertyInfo
implements Locatable {
    private static final Modifier.MatchBlockWithDefault<Boolean> IS_STATIC = new Modifier.MatchBlockWithDefault<Boolean>(){

        @Override
        public Boolean _case(Modifier.StaticModifier x) {
            return true;
        }

        @Override
        protected Boolean _default(Modifier x) {
            return false;
        }
    };
    public static final Comparator<PropertyInfo> NAME_COMPARATOR = (left, right) -> {
        String leftName;
        String string = left == null ? null : (leftName = left.getName() == null ? null : left.getName().getValue());
        String rightName = right == null ? null : (right.getName() == null ? null : right.getName().getValue());
        int retValue = Comparables.compare(leftName, rightName);
        if (retValue != 0) {
            return retValue;
        }
        return Comparables.compare(left.getOldModifiers().getModifiers(), right.getOldModifiers().getModifiers());
    };
    private final Property property;
    private final Identifier name;
    private final PropertyDecl body;
    private final ModifierGroup getterModifiers;
    private final ModifierGroup setterModifiers;
    private OldModifiers oldModifiers;

    PropertyInfo(Property property, PropertyDecl body, ModifierGroup getterModifiers, ModifierGroup setterModifiers) {
        this.property = property;
        this.name = body.name;
        this.body = body;
        this.getterModifiers = getterModifiers;
        this.setterModifiers = setterModifiers;
    }

    public String encode() {
        Default isDefaultSetter = this.isDefaultGetter();
        Default isDefaultGetter = this.isDefaultSetter();
        String accessorName = AccessorFactory.name(this.name.getValue());
        OldModifiers oldModifiers = this.getOldModifiers();
        return oldModifiers.getModifiers() + ":" + this.getLine() + ":" + this.getColumn() + ":" + this.name.getValue() + ":" + accessorName + ":" + accessorName + ":" + isDefaultGetter.value + ":" + isDefaultSetter.value;
    }

    private OldModifiers getOldModifiers(Default isDefaultSetter, Default isDefaultGetter) {
        OldModifiers oldModifiers = OldModifiers.fromModifiers(this.property.getModifiers());
        switch (isDefaultGetter) {
            case YES: 
            case NO: {
                if (this.getterModifiers.has(ModifierTypeInfos.LEGACY_DEFAULT_GETTER)) {
                    oldModifiers.set(OldModifiers.ModifierType.LegacyDefaultVisibilityGetter);
                    break;
                }
                if (this.getterModifiers.has(ModifierTypeInfos.GLOBAL)) {
                    oldModifiers.set(OldModifiers.ModifierType.GlobalGetter);
                    break;
                }
                if (this.getterModifiers.has(ModifierTypeInfos.PUBLIC)) {
                    oldModifiers.set(OldModifiers.ModifierType.PublicGetter);
                    break;
                }
                if (this.getterModifiers.has(ModifierTypeInfos.PROTECTED)) {
                    oldModifiers.set(OldModifiers.ModifierType.ProtectedGetter);
                    break;
                }
                if (!this.getterModifiers.has(ModifierTypeInfos.PRIVATE)) break;
                oldModifiers.set(OldModifiers.ModifierType.PrivateGetter);
                break;
            }
        }
        switch (isDefaultSetter) {
            case YES: 
            case NO: {
                if (this.setterModifiers.has(ModifierTypeInfos.LEGACY_DEFAULT_SETTER)) {
                    oldModifiers.set(OldModifiers.ModifierType.LegacyDefaultVisibilitySetter);
                    break;
                }
                if (this.setterModifiers.has(ModifierTypeInfos.GLOBAL)) {
                    oldModifiers.set(OldModifiers.ModifierType.GlobalSetter);
                    break;
                }
                if (this.setterModifiers.has(ModifierTypeInfos.PUBLIC)) {
                    oldModifiers.set(OldModifiers.ModifierType.PublicSetter);
                    break;
                }
                if (this.setterModifiers.has(ModifierTypeInfos.PROTECTED)) {
                    oldModifiers.set(OldModifiers.ModifierType.ProtectedSetter);
                    break;
                }
                if (!this.setterModifiers.has(ModifierTypeInfos.PRIVATE)) break;
                oldModifiers.set(OldModifiers.ModifierType.PrivateSetter);
                break;
            }
        }
        block6 : switch (this.getDefiningType().getUnitType()) {
            case CLASS: 
            case INTERFACE: 
            case ENUM: 
            case ANNOTATION: 
            case ANONYMOUS: {
                break;
            }
            case TRIGGER: {
                if (!isDefaultGetter.value || !isDefaultSetter.value) {
                    oldModifiers.set(OldModifiers.ModifierType.StaticIdentifier);
                    break;
                }
                for (Modifier modifier : this.body.modifiers) {
                    if (!modifier.match(IS_STATIC).booleanValue()) continue;
                    oldModifiers.set(OldModifiers.ModifierType.StaticIdentifier);
                    break block6;
                }
                break;
            }
        }
        return oldModifiers;
    }

    private Default isDefaultSetter() {
        return this.body.getter.map(value -> value.stmnt.map(ignored -> Default.NO).orElse(Default.YES)).orElse(Default.UNDEFINED);
    }

    private Default isDefaultGetter() {
        return this.body.setter.map(value -> value.stmnt.map(ignored -> Default.NO).orElse(Default.YES)).orElse(Default.UNDEFINED);
    }

    private int getColumn() {
        return this.body.name.getLoc().getColumn();
    }

    private int getLine() {
        return this.body.name.getLoc().getLine();
    }

    private TypeInfo getDefiningType() {
        return this.property.getDefiningType();
    }

    public Identifier getName() {
        return this.name;
    }

    public Property getProperty() {
        return this.property;
    }

    public TypeInfo getType() {
        return this.property.getFieldInfo().getType();
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    @VisibleForTesting
    OldModifiers getOldModifiers() {
        if (this.oldModifiers == null) {
            this.oldModifiers = this.getOldModifiers(this.isDefaultGetter(), this.isDefaultSetter());
        }
        return this.oldModifiers;
    }

    static enum Default {
        NO(false),
        YES(true),
        UNDEFINED(true);

        private final boolean value;

        private Default(boolean value) {
            this.value = value;
        }
    }
}

