/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor.reference;

import apex.jorje.data.Identifier;
import apex.jorje.semantic.ast.expression.ReferenceContext;
import apex.jorje.semantic.ast.expression.ReferenceType;
import apex.jorje.semantic.ast.visitor.reference.ReferenceInfo;
import apex.jorje.semantic.ast.visitor.reference.ReferenceVisitor;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.symbol.member.Member;
import apex.jorje.semantic.symbol.member.variable.Variable;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeNameFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MoreLists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;

class VariableReferenceUtil {
    private static final VariableReferenceUtil INSTANCE = new VariableReferenceUtil();
    private static final Set<Member.Type> TRACKABLE_VARIABLE_TYPES = Sets.immutableEnumSet((Enum)Member.Type.FIELD, (Enum[])new Member.Type[]{Member.Type.PROPERTY, Member.Type.DYNAMIC});

    private VariableReferenceUtil() {
    }

    static VariableReferenceUtil get() {
        return INSTANCE;
    }

    void variableVisit(ReferenceVisitor referenceVisitor, Variable variable, ReferenceContext referenceContext, ReferenceType referenceType, boolean isReferencedViaForeignKey, boolean isLast) {
        TypeInfo variableDefiningType = variable.getDefiningType();
        if (variableDefiningType.getBasicType() == BasicType.SOBJECT) {
            this.handleSObjectFieldReferences(referenceVisitor, variable, referenceType, isReferencedViaForeignKey, isLast);
        } else {
            this.handleNonSObjectFieldReferences(variable, referenceContext, referenceVisitor);
        }
    }

    private void handleNonSObjectFieldReferences(Variable variable, ReferenceContext referenceContext, ReferenceVisitor referenceVisitor) {
        if (!variable.getModifiers().has(ModifierTypeInfos.STATIC)) {
            return;
        }
        TypeInfo variableDefiningType = variable.getDefiningType();
        boolean isFullyQualified = TypeNameFactory.isFullyQualified(referenceContext.getStaticNumberOfNamesBound(), referenceVisitor.getReferencingType(), variableDefiningType);
        if (!isFullyQualified) {
            return;
        }
        if (variable.getMemberType() == Member.Type.FIELD || variable.getMemberType() == Member.Type.PROPERTY || variable.getMemberType() == Member.Type.DYNAMIC) {
            if (variable.getModifiers().has(ModifierTypeInfos.STATIC) && TypeInfoUtil.isInnerType(variableDefiningType)) {
                List<Identifier> allNamesMinusLast = MoreLists.removeLast(referenceContext.getNames());
                TypeInfo enclosingType = referenceVisitor.getSymbols().lookupTypeInfoIdentifiers(referenceVisitor.getReferencingType(), allNamesMinusLast, ReferenceType.NONE);
                TypeInfo typeToReference = enclosingType.isResolved() && TypeInfoUtil.isTopLevel(enclosingType) && enclosingType != variableDefiningType.getEnclosingType() ? enclosingType : variableDefiningType;
                referenceVisitor.checkAndAddVariableRelationship(typeToReference, variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(false).build());
            } else {
                referenceVisitor.checkAndAddVariableRelationship(variableDefiningType, variable.getLoc(), ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(false).build());
            }
        }
    }

    @VisibleForTesting
    void handleSObjectFieldReferences(ReferenceVisitor referenceVisitor, Variable variable, ReferenceType referenceType, boolean isReferencedViaForeignKey, boolean isLast) {
        TypeInfo variableDefiningType = variable.getDefiningType();
        if (TypeInfoEquivalence.isEquivalent(variable.getType(), InternalTypeInfos.SCHEMA_SOBJECT_ROW_CAUSE)) {
            return;
        }
        if (TRACKABLE_VARIABLE_TYPES.contains((Object)variable.getMemberType())) {
            DmlOperation dmlOperation = referenceVisitor.isEditable(variable, referenceType == ReferenceType.STORE);
            ReferenceInfo referenceInfo = this.isSObjectTypeVariable(variable) ? ReferenceInfo.empty() : ReferenceInfo.builder().setVariable(variable).setReferencedViaForeignKey(isReferencedViaForeignKey).setDmlOperation(dmlOperation).setLast(isLast).build();
            referenceVisitor.checkAndAddVariableRelationship(variableDefiningType, variable.getLoc(), referenceInfo);
        }
    }

    private boolean isSObjectTypeVariable(Variable variable) {
        return TypeInfoEquivalence.isEquivalent(variable.getType(), InternalTypeInfos.SCHEMA_SOBJECT_TYPE) && variable.getMemberType() == Member.Type.DYNAMIC;
    }
}

