/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.matchers;

import apex.common.tuple.BooleanHolder;
import apex.jorje.semantic.ast.visitor.reference.ExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.TypedExternalDependency;
import apex.jorje.semantic.ast.visitor.reference.UntypedExternalDependency;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;

public class IsUntypedExternalDependency
extends TypeSafeDiagnosingMatcher<ExternalDependency> {
    private final Optional<Matcher<UntypedExternalDependency.DependencyType>> dependencyTypeMatcher;
    private final Optional<Matcher<String>> dependencyValueMatcher;

    private IsUntypedExternalDependency(Builder builder) {
        this.dependencyTypeMatcher = builder.dependencyTypeMatcher;
        this.dependencyValueMatcher = builder.dependencyValueMatcher;
    }

    public static Builder matching() {
        return new Builder();
    }

    public void describeTo(Description description) {
        this.dependencyTypeMatcher.ifPresent(matcher -> {
            description.appendText("dependency type: ");
            matcher.describeTo(description);
        });
        this.dependencyValueMatcher.ifPresent(matcher -> {
            description.appendText("\ndependency value: ");
            matcher.describeTo(description);
        });
    }

    protected boolean matchesSafely(ExternalDependency externalDependency, final Description description) {
        return externalDependency.accept(new ExternalDependency.ExternalDependencyVisitor<Boolean>(){

            @Override
            public Boolean visit(UntypedExternalDependency dependency) {
                BooleanHolder matches = new BooleanHolder(true);
                IsUntypedExternalDependency.this.dependencyTypeMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getDependencyType())) {
                        description.appendText("dependency type: ");
                        matcher.describeMismatch((Object)dependency.getDependencyType(), description);
                        matches.value = false;
                    }
                });
                IsUntypedExternalDependency.this.dependencyValueMatcher.ifPresent(matcher -> {
                    if (!matcher.matches((Object)dependency.getDependencyValue())) {
                        description.appendText("\ndependency value: ");
                        matcher.describeMismatch((Object)dependency.getDependencyValue(), description);
                        matches.value = false;
                    }
                });
                return matches.value;
            }

            @Override
            public Boolean visit(TypedExternalDependency dependency) {
                description.appendText("TypedExternalDependency");
                return false;
            }
        });
    }

    public static class Builder {
        private Optional<Matcher<UntypedExternalDependency.DependencyType>> dependencyTypeMatcher = Optional.empty();
        private Optional<Matcher<String>> dependencyValueMatcher = Optional.empty();

        private Builder() {
        }

        public Builder withDependencyType(UntypedExternalDependency.DependencyType dependencyType) {
            this.dependencyTypeMatcher = Optional.of(Is.is((Object)((Object)dependencyType)));
            return this;
        }

        public Builder withDependencyValue(String dependencyValue) {
            this.dependencyValueMatcher = Optional.of(IsEqual.equalTo((Object)dependencyValue));
            return this;
        }

        public IsUntypedExternalDependency build() {
            return new IsUntypedExternalDependency(this);
        }
    }
}

