/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.member.variable;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.IdentifierContext;
import apex.jorje.semantic.ast.expression.MethodCallExpression;
import apex.jorje.semantic.ast.expression.NestedExpression;
import apex.jorje.semantic.ast.expression.VariableExpression;
import apex.jorje.semantic.ast.statement.ForEachStatement;
import apex.jorje.semantic.ast.statement.ListCreator;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.DefaultAstVisitor;
import apex.jorje.semantic.ast.visitor.ValueScope;
import apex.jorje.semantic.bcl.AsmMethod;
import apex.jorje.semantic.bcl.DatabaseEmitMethods;
import apex.jorje.semantic.bcl.ListEmitMethods;
import apex.jorje.semantic.bcl.ObjectEmitMethods;
import apex.jorje.semantic.bcl.TriggerEmitMethods;
import apex.jorje.semantic.symbol.member.method.MethodInfo;
import apex.jorje.semantic.symbol.member.variable.DynamicFieldInfo;
import apex.jorje.semantic.symbol.member.variable.FieldInfo;
import apex.jorje.semantic.symbol.member.variable.LocalInfo;
import apex.jorje.semantic.symbol.member.variable.SObjectFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardFieldInfo;
import apex.jorje.semantic.symbol.member.variable.StandardPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerFieldInfo;
import apex.jorje.semantic.symbol.member.variable.TriggerPropertyInfo;
import apex.jorje.semantic.symbol.member.variable.VariableVisitor;
import apex.jorje.semantic.symbol.type.ModifierTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.common.SObjectTypeInfoUtil;
import apex.jorje.semantic.symbol.type.naming.TypeEraser;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.objectweb.asm.Label;

public class VariableEmitLoadVisitor
implements VariableVisitor<Void, VariableVisitor.Context> {
    private static final AstVisitor<ValueScope<ListCreator>> IN_FOR_EACH_STATEMENT_INIT = new DefaultAstVisitor<ValueScope<ListCreator>>(){

        @Override
        public void visitEnd(ForEachStatement node, ValueScope<ListCreator> scope) {
            scope.setValue(node.getListCreator());
        }

        @Override
        public void visitEnd(NestedExpression node, ValueScope<ListCreator> scope) {
            node.getDefiningNode().traverse(this, scope);
        }
    };
    private static final AstVisitor<ValueScope<ListCreator>> IN_VARIABLE_EXPRESSION = new AstVisitor<ValueScope<ListCreator>>(){

        @Override
        public void visitEnd(VariableExpression node, ValueScope<ListCreator> scope) {
            node.getDefiningNode().traverse(IN_FOR_EACH_STATEMENT_INIT, scope);
        }
    };
    private static final AstVisitor<ValueScope<Location>> GET_LOC = new AstVisitor<ValueScope<Location>>(){

        @Override
        public void visitEnd(MethodCallExpression node, ValueScope<Location> scope) {
            scope.setValue(Iterables.getLast(node.getReferenceContext().getNames()).getLoc());
        }
    };
    private static final AstVisitor<ValueScope<Boolean>> IS_SAFE_NAVIGATION = new AstVisitor<ValueScope<Boolean>>(){

        @Override
        public void visitEnd(VariableExpression node, ValueScope<Boolean> scope) {
            scope.setValue(node.getReferenceContext().isSafeNav());
        }
    };
    private final Expression expression;
    private final Emitter emitter;
    private final List<Label> branches;

    public VariableEmitLoadVisitor(Expression expression, Emitter emitter) {
        this.expression = expression;
        this.emitter = emitter;
        this.branches = new ArrayList<Label>();
    }

    private static Optional<ListCreator> isInForEachStatementInit(Expression expression) {
        return ValueScope.evaluate(expression, IN_VARIABLE_EXPRESSION);
    }

    private static Location getLoc(Expression expression) {
        return ValueScope.evaluate(expression, GET_LOC, expression.getLoc());
    }

    @Override
    public Void visit(LocalInfo info, VariableVisitor.Context context) {
        this.emitter.emitVar(context.loc, 25, info.getPosition(this.emitter));
        return null;
    }

    @Override
    public Void visit(StandardFieldInfo info, VariableVisitor.Context context) {
        if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            this.emitter.emitField(context.loc, 178, info);
        } else {
            if (context.previous == IdentifierContext.NONE) {
                this.emitter.emitVar(context.loc, 25, 0);
            }
            this.emitter.emitField(context.loc, 180, info);
        }
        return null;
    }

    @Override
    public Void visit(StandardPropertyInfo info, VariableVisitor.Context context) {
        if (context.previous == IdentifierContext.NONE && !info.getModifiers().has(ModifierTypeInfos.STATIC)) {
            this.emitter.emitVar(context.loc, 25, 0);
        }
        if (info == this.emitter.emitRawProperty()) {
            FieldInfo fieldInfo = info.getUnderlyingField();
            if (fieldInfo.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 178, fieldInfo);
            } else {
                this.emitter.emitField(context.loc, 180, fieldInfo);
            }
        } else {
            MethodInfo getter = info.getProperty().getGetter();
            MethodInfo proxy = this.emitter.getProxyMethodTable().get(context.loc, this.expression.getDefiningType(), info.getDefiningType(), getter);
            AsmMethod asmMethod = proxy != null ? proxy.getAsmMethod() : getter.getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(TriggerFieldInfo info, VariableVisitor.Context context) {
        this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
        this.emitter.emitField(context.loc, 180, info);
        return null;
    }

    @Override
    public Void visit(TriggerPropertyInfo info, VariableVisitor.Context context) {
        if (info == this.emitter.emitRawProperty()) {
            if (info.getModifiers().has(ModifierTypeInfos.STATIC)) {
                this.emitter.emitField(context.loc, 178, info);
            } else {
                if (context.previous == IdentifierContext.NONE) {
                    this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
                }
                this.emitter.emitField(context.loc, 180, info);
            }
        } else {
            this.emitter.emit(Locations.NONE, TriggerEmitMethods.GET_TRIGGER_INSTANCE);
            AsmMethod asmMethod = info.getProperty().getGetter().getAsmMethod();
            this.emitter.emit(context.loc, asmMethod);
        }
        return null;
    }

    @Override
    public Void visit(SObjectFieldInfo info, VariableVisitor.Context context) {
        Label end;
        if (context.shouldPeelSObject) {
            AsmMethod getFirstSObjectMethod = context.shouldPeelWithSafeNavigation ? ListEmitMethods.GET_FIRST_SOBJECT_OR_NULL_BYTECODE : ListEmitMethods.GET_FIRST_SOBJECT_BYTECODE;
            this.emitter.push(context.loc, info.getDefiningType().getBytecodeName());
            this.emitter.emit(context.loc, getFirstSObjectMethod);
            if (context.shouldPeelWithSafeNavigation) {
                this.emitter.emitSafeNavigationTestAndJump(context.definingExpression);
            }
        }
        SObjectTypeInfo.MethodsForEmit methodsForEmit = SObjectTypeInfoUtil.getMethodsForEmit(MoreObjects.firstNonNull(context.firstSObjectTypeInfo, info.getDefiningType()));
        if (!context.isLast) {
            Location expressionLoc = VariableEmitLoadVisitor.getLoc(this.expression);
            this.emitter.push(expressionLoc, info.getBytecodeName());
            this.emitter.emit(expressionLoc, methodsForEmit.getValueMethod());
            if (context.emitLast) {
                this.emitter.emit(expressionLoc, 89);
                Label branch = new Label();
                this.emitter.emitJump(expressionLoc, 198, branch);
                this.branches.add(branch);
            }
            return null;
        }
        if (context.isLast && !context.emitLast) {
            this.emitter.push(context.loc, info.getBytecodeName());
            return null;
        }
        Optional<ListCreator> listCreator = VariableEmitLoadVisitor.isInForEachStatementInit(this.expression);
        switch (info.getCategory()) {
            case REGULAR: {
                this.emitter.push(context.loc, info.getBytecodeName());
                this.emitter.emit(context.loc, methodsForEmit.getRegularValueMethod());
                break;
            }
            case FOREIGN_KEY: {
                this.emitter.push(context.loc, info.getBytecodeName());
                this.emitter.emit(context.loc, methodsForEmit.getValueMethod());
                break;
            }
            case AGGREGATE: {
                assert (SObjectTypeInfoUtil.isConcreteSObjectList(info.getType())) : "this should be a concrete sobject list";
                TypeInfo type = CollectionTypeInfoUtil.getElementType(info.getType());
                this.emitter.push(context.loc, info.getName());
                this.emitter.push(context.loc, type.getApexName());
                this.emitter.emit(context.loc, listCreator.map(x -> methodsForEmit.getAggregateForSelectMethod()).orElseGet(methodsForEmit::getAggregateMethod));
                break;
            }
            case ID_LIST: {
                this.emitter.push(context.loc, info.getName());
                this.emitter.emit(context.loc, methodsForEmit.getValueMethod());
            }
        }
        this.branches.forEach(this.emitter::emit);
        if (CollectionTypeInfoUtil.isList(info.getType())) {
            end = new Label();
            this.emitter.emit(context.loc, 89);
            this.emitter.emitJump(context.loc, 199, end);
            this.emitter.emit(context.loc, 87);
            if (listCreator.isPresent() && listCreator.get() == ListCreator.AGGREGATE_FIELD) {
                String entityName = CollectionTypeInfoUtil.getElementType(info.getType()).getApexName();
                this.emitter.push(context.loc, entityName);
                this.emitter.emit(context.loc, DatabaseEmitMethods.GET_EMPTY_QUERY_LOCATOR);
            } else {
                String bytecodeName = TypeEraser.eraseBytecodeName(info.getType());
                this.emitter.emitType(context.loc, 187, bytecodeName);
                this.emitter.emit(context.loc, 89);
                AsmMethod constructor = ObjectEmitMethods.constructor(info.getType());
                this.emitter.emit(context.loc, constructor);
            }
            this.emitter.emit(end);
        } else if (TypeInfoEquivalence.isEquivalent(info.getType(), TypeInfos.BOOLEAN)) {
            this.emitter.emit(context.loc, 89);
            end = new Label();
            this.emitter.emitJump(context.loc, 199, end);
            this.emitter.emit(context.loc, 87);
            this.emitter.push(context.loc, false);
            this.emitter.emitBox(TypeInfos.BOOLEAN);
            this.emitter.emit(end);
        }
        return null;
    }

    @Override
    public Void visit(DynamicFieldInfo info, VariableVisitor.Context context) {
        if (info.getLoadEmitter() != null) {
            info.getLoadEmitter().emit(this.emitter, info, context);
        }
        return null;
    }
}

