/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.symbol.type.common;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.bcl.DmlOperation;
import apex.jorje.semantic.compiler.Namespace;
import apex.jorje.semantic.exception.UnexpectedCodePathException;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.SObjectTypeInfo;
import apex.jorje.semantic.symbol.type.ScalarTypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.CollectionTypeInfoUtil;
import apex.jorje.semantic.symbol.type.visitor.TypeInfoVisitor;
import apex.jorje.services.Version;

public class SObjectTypeInfoUtil {
    private static final TypeInfoVisitor<SObjectTypeInfo.MethodsForEmit> METHODS_FOR_EMIT = new TypeInfoVisitor.Default<SObjectTypeInfo.MethodsForEmit>(){

        @Override
        protected SObjectTypeInfo.MethodsForEmit _default(TypeInfo type) {
            throw new UnexpectedCodePathException();
        }

        @Override
        public SObjectTypeInfo.MethodsForEmit visit(ScalarTypeInfo type) {
            if (type.getBasicType() == BasicType.SOBJECT) {
                return SObjectTypeInfo.getGenericMethodsForEmit();
            }
            throw new UnexpectedCodePathException();
        }

        @Override
        public SObjectTypeInfo.MethodsForEmit visit(SObjectTypeInfo type) {
            return type.getMethodsForEmit();
        }
    };
    private static final TypeInfoVisitor<SObjectTypeInfo> GET_SOBJECT_TYPE = new TypeInfoVisitor.Default<SObjectTypeInfo>(){

        @Override
        protected SObjectTypeInfo _default(TypeInfo type) {
            throw new UnexpectedCodePathException("Not an SObject type: " + type);
        }

        @Override
        public SObjectTypeInfo visit(SObjectTypeInfo type) {
            return type;
        }
    };

    private SObjectTypeInfoUtil() {
    }

    public static boolean isSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && CollectionTypeInfoUtil.getElementType(type).getBasicType() == BasicType.SOBJECT;
    }

    public static boolean isGenericSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && TypeInfoEquivalence.isEquivalent(CollectionTypeInfoUtil.getElementType(type), TypeInfos.SOBJECT);
    }

    public static boolean isConcreteSObjectList(TypeInfo type) {
        return CollectionTypeInfoUtil.isList(type) && SObjectTypeInfoUtil.isConcreteSObject(CollectionTypeInfoUtil.getElementType(type));
    }

    public static boolean isConcreteSObject(TypeInfo type) {
        return type.getBasicType() == BasicType.SOBJECT && !TypeInfoEquivalence.isEquivalent(type, TypeInfos.SOBJECT);
    }

    public static boolean isUnionSubEntityType(TypeInfo type) {
        return SObjectTypeInfoUtil.isConcreteSObject(type) && SObjectTypeInfoUtil.getUnionEntityEmitType(type) != type;
    }

    public static TypeInfo getUnionEntityEmitType(TypeInfo type) {
        if (SObjectTypeInfoUtil.isConcreteSObject(type)) {
            SObjectTypeInfo sObjectType = SObjectTypeInfoUtil.getSObjectTypeInfoFromType(type);
            return sObjectType.getMetadata() != null ? sObjectType.getMetadata().getUnionParentType(type) : type;
        }
        return type;
    }

    public static boolean isDmlOperationAllowedStatically(TypeInfo definingType, final DmlOperation dmlOp, TypeInfo type) {
        final boolean isNotTrustedOrInternalTrigger = definingType.getUnitType() != UnitType.TRIGGER || !definingType.getCodeUnitDetails().isTrusted();
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return type.getBasicType() == BasicType.SOBJECT;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                boolean isDmlOperationSupported = type.getMetadata().getSupportedDml().contains((Object)dmlOp);
                boolean isDmlAllowedOnSetupEntity = SObjectTypeInfoUtil.isDmlAllowedOnSetupEntity(type, dmlOp);
                return (isDmlOperationSupported || !isNotTrustedOrInternalTrigger) && isDmlAllowedOnSetupEntity;
            }

            @Override
            public Boolean visit(GenericTypeInfo type) {
                return CollectionTypeInfoUtil.isCollection(type) && CollectionTypeInfoUtil.getElementType(type).accept(this) != false;
            }
        });
    }

    private static boolean isDmlAllowedOnSetupEntity(SObjectTypeInfo type, DmlOperation dmlOp) {
        switch (dmlOp) {
            case INSERT: 
            case UPDATE: {
                return true;
            }
            case MERGE: 
            case UNDELETE: 
            case DELETE: 
            case LEAD_CONVERT: 
            case UPSERT: {
                return !type.getMetadata().isCustomizableSetupEntity();
            }
        }
        return true;
    }

    public static boolean isLookupField(TypeInfo type, final String fieldName, final TypeInfo referencingType) {
        return type.accept(new TypeInfoVisitor.Default<Boolean>(){

            @Override
            protected Boolean _default(TypeInfo type) {
                return type.getBasicType() == BasicType.SOBJECT;
            }

            @Override
            public Boolean visit(SObjectTypeInfo type) {
                return type.getMetadata().getIsLookupField().test(fieldName, referencingType);
            }
        });
    }

    public static SObjectTypeInfo.MethodsForEmit getMethodsForEmit(TypeInfo type) {
        return type.accept(METHODS_FOR_EMIT);
    }

    public static boolean isQualifiedField(Namespace namespace, String field) {
        return MoreStrings.startsWithIgnoreCase(field, namespace.getNameLower().concat("__"));
    }

    public static SObjectTypeInfo getSObjectTypeInfoFromType(TypeInfo type) {
        return type.accept(GET_SOBJECT_TYPE);
    }

    public static boolean isGenericSObjectOrSObjectCollection(TypeInfo type) {
        switch (type.getBasicType()) {
            case INTEGER: 
            case LONG: 
            case DOUBLE: 
            case DECIMAL: 
            case BOOLEAN: 
            case STRING: 
            case VOID: 
            case APEX_OBJECT: 
            case TIME: 
            case DATE: 
            case DATE_TIME: 
            case OBJECT: 
            case ID: 
            case BLOB: 
            case NULL: 
            case ANNOTATION: 
            case JAVA: 
            case CURRENCY: 
            case VF_COMPONENT: 
            case FLOW_INTERVIEW: 
            case MODIFIER: 
            case LIST_ITERATOR: {
                return false;
            }
            case SOBJECT: {
                return true;
            }
            case LIST: {
                return SObjectTypeInfoUtil.isGenericSObjectOrSObjectCollection(CollectionTypeInfoUtil.getElementType(type));
            }
            case SET: {
                return SObjectTypeInfoUtil.isGenericSObjectOrSObjectCollection(CollectionTypeInfoUtil.getElementType(type));
            }
            case MAP: {
                return SObjectTypeInfoUtil.isGenericSObjectOrSObjectCollection(CollectionTypeInfoUtil.getKeyType(type)) || SObjectTypeInfoUtil.isGenericSObjectOrSObjectCollection(CollectionTypeInfoUtil.getValueType(type));
            }
        }
        return false;
    }

    public static boolean isUnionAllCastComparison(TypeInfo referencingType, TypeInfo left, TypeInfo right) {
        Version version = referencingType.getCodeUnitDetails().getVersion();
        return version.isGreaterThan(Version.V208) && !TypeInfoEquivalence.isEquivalent(left, InternalTypeInfos.NULL) && !TypeInfoEquivalence.isEquivalent(right, InternalTypeInfos.NULL) && (SObjectTypeInfoUtil.isUnionSubEntityType(left) || SObjectTypeInfoUtil.isUnionSubEntityType(right));
    }
}

