/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.apex.rule.design;

import net.sourceforge.pmd.lang.apex.ast.ApexNode;
import net.sourceforge.pmd.lang.apex.rule.AbstractStatisticalApexRule;
import net.sourceforge.pmd.stat.DataPoint;

public class ExcessiveNodeCountRule
extends AbstractStatisticalApexRule {
    private Class<?> nodeClass;

    public ExcessiveNodeCountRule(Class<?> nodeClass) {
        this.nodeClass = nodeClass;
    }

    @Override
    public Object visit(ApexNode<?> node, Object data) {
        int numNodes = 0;
        for (ApexNode<?> child : node.children()) {
            numNodes += ((Integer)child.jjtAccept(this, data)).intValue();
        }
        if (this.nodeClass.isInstance(node)) {
            DataPoint point = new DataPoint();
            point.setNode(node);
            point.setScore(1.0 * (double)numNodes);
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
        }
        return numNodes;
    }
}

