/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.dfa;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.dfa.NodeType;
import net.sourceforge.pmd.lang.dfa.StackObject;

@Deprecated
public class SequenceChecker {
    private static final Logger LOGGER = Logger.getLogger(SequenceChecker.class.getName());
    private static Status root = new Status(NodeType.ROOT);
    private Status aktStatus = root;
    private List<StackObject> bracesList;
    private int firstIndex = -1;
    private int lastIndex = -1;

    public SequenceChecker(List<StackObject> bracesList) {
        this.bracesList = bracesList;
    }

    public boolean run() {
        LOGGER.entering(this.getClass().getCanonicalName(), "run");
        this.aktStatus = root;
        this.firstIndex = 0;
        this.lastIndex = 0;
        boolean lookAhead = false;
        int maximumIterations = this.bracesList.size() * this.bracesList.size();
        int l = -1;
        for (int i = 0; i < this.bracesList.size(); ++i) {
            ++l;
            StackObject so = this.bracesList.get(i);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Processing bracesList(l,i)=(" + l + "," + i + ") of Type " + (Object)((Object)so.getType()) + " with State (aktStatus) = " + this.aktStatus);
                LOGGER.finest("DataFlowNode @ line " + so.getDataFlowNode().getLine() + " and index=" + so.getDataFlowNode().getIndex());
            }
            this.aktStatus = this.aktStatus.step(so.getType());
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("Transition aktStatus=" + this.aktStatus);
            }
            if (this.aktStatus == null) {
                if (lookAhead) {
                    this.lastIndex = i - 1;
                    LOGGER.finer("aktStatus is NULL (lookAhead): Invalid transition");
                    LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                    return false;
                }
                if (l > maximumIterations) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.severe("aktStatus is NULL: maximum Iterations exceeded, abort " + i);
                    }
                    LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                    return false;
                }
                this.aktStatus = root;
                this.firstIndex = i--;
                if (!LOGGER.isLoggable(Level.FINEST)) continue;
                LOGGER.finest("aktStatus is NULL: Restarting search continue i==" + i + ", firstIndex=" + this.firstIndex);
                continue;
            }
            if (this.aktStatus.isLastStep() && !this.aktStatus.hasMoreSteps()) {
                this.lastIndex = i;
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("aktStatus is NOT NULL: lastStep reached and no moreSteps - firstIndex=" + this.firstIndex + ", lastIndex=" + this.lastIndex);
                }
                LOGGER.exiting(this.getClass().getCanonicalName(), "run", false);
                return false;
            }
            if (!this.aktStatus.isLastStep() || !this.aktStatus.hasMoreSteps()) continue;
            lookAhead = true;
            this.lastIndex = i;
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finer("Completed search: firstIndex=" + this.firstIndex + ", lastIndex=" + this.lastIndex);
        }
        LOGGER.exiting(this.getClass().getCanonicalName(), "run", this.firstIndex == this.lastIndex);
        return this.firstIndex == this.lastIndex;
    }

    public int getFirstIndex() {
        return this.firstIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    static {
        Status ifNode = new Status(NodeType.IF_EXPR);
        Status ifSt = new Status(NodeType.IF_LAST_STATEMENT);
        Status ifStWithoutElse = new Status(NodeType.IF_LAST_STATEMENT_WITHOUT_ELSE, true);
        Status elseSt = new Status(NodeType.ELSE_LAST_STATEMENT, true);
        Status whileNode = new Status(NodeType.WHILE_EXPR);
        Status whileSt = new Status(NodeType.WHILE_LAST_STATEMENT, true);
        Status switchNode = new Status(NodeType.SWITCH_START);
        Status caseSt = new Status(NodeType.CASE_LAST_STATEMENT);
        Status switchDefault = new Status(NodeType.SWITCH_LAST_DEFAULT_STATEMENT);
        Status switchEnd = new Status(NodeType.SWITCH_END, true);
        Status forInit = new Status(NodeType.FOR_INIT);
        Status forExpr = new Status(NodeType.FOR_EXPR);
        Status forUpdate = new Status(NodeType.FOR_UPDATE);
        Status forSt = new Status(NodeType.FOR_BEFORE_FIRST_STATEMENT);
        Status forEnd = new Status(NodeType.FOR_END, true);
        Status doSt = new Status(NodeType.DO_BEFORE_FIRST_STATEMENT);
        Status doExpr = new Status(NodeType.DO_EXPR, true);
        Status labelNode = new Status(NodeType.LABEL_STATEMENT);
        Status labelEnd = new Status(NodeType.LABEL_LAST_STATEMENT, true);
        root.addStep(ifNode);
        root.addStep(whileNode);
        root.addStep(switchNode);
        root.addStep(forInit);
        root.addStep(forExpr);
        root.addStep(forUpdate);
        root.addStep(forSt);
        root.addStep(doSt);
        root.addStep(labelNode);
        ifNode.addStep(ifSt);
        ifNode.addStep(ifStWithoutElse);
        ifSt.addStep(elseSt);
        ifStWithoutElse.addStep(root);
        elseSt.addStep(root);
        labelNode.addStep(labelEnd);
        labelEnd.addStep(root);
        whileNode.addStep(whileSt);
        whileSt.addStep(root);
        switchNode.addStep(caseSt);
        switchNode.addStep(switchDefault);
        switchNode.addStep(switchEnd);
        caseSt.addStep(caseSt);
        caseSt.addStep(switchDefault);
        caseSt.addStep(switchEnd);
        switchDefault.addStep(switchEnd);
        switchDefault.addStep(caseSt);
        switchEnd.addStep(root);
        forInit.addStep(forExpr);
        forInit.addStep(forUpdate);
        forInit.addStep(forSt);
        forExpr.addStep(forUpdate);
        forExpr.addStep(forSt);
        forUpdate.addStep(forSt);
        forSt.addStep(forEnd);
        forEnd.addStep(root);
        doSt.addStep(doExpr);
        doExpr.addStep(root);
    }

    private static class Status {
        private List<Status> nextSteps = new ArrayList<Status>();
        private NodeType type;
        private boolean lastStep;

        Status(NodeType type) {
            this(type, false);
        }

        Status(NodeType type, boolean lastStep) {
            this.type = type;
            this.lastStep = lastStep;
        }

        public void addStep(Status type) {
            this.nextSteps.add(type);
        }

        public Status step(NodeType type) {
            for (Status s : this.nextSteps) {
                if (type != s.type) continue;
                return s;
            }
            return null;
        }

        public boolean isLastStep() {
            return this.lastStep;
        }

        public boolean hasMoreSteps() {
            return this.nextSteps.size() > 1;
        }

        public String toString() {
            return "NodeType=" + (Object)((Object)this.type) + "(" + (Object)((Object)this.type) + "), lastStep=" + this.lastStep;
        }
    }
}

