/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.rule.xpath;

import java.util.HashMap;
import java.util.Map;

public enum XPathVersion {
    XPATH_1_0("1.0"),
    XPATH_1_0_COMPATIBILITY("1.0 compatibility"),
    XPATH_2_0("2.0");

    private static final Map<String, XPathVersion> BY_NAME;
    private final String version;

    private XPathVersion(String version) {
        this.version = version;
    }

    public String getXmlName() {
        return this.version;
    }

    public static XPathVersion ofId(String version) {
        return BY_NAME.get(version);
    }

    static {
        BY_NAME = new HashMap<String, XPathVersion>();
        for (XPathVersion value : XPathVersion.values()) {
            BY_NAME.put(value.getXmlName(), value);
        }
    }
}

