/*
 * Decompiled with CFR 0.152.
 */
package apex.common.collect;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

final class ConcatenatedCollections<T>
extends AbstractCollection<T> {
    private final Collection<? extends T> head;
    private final Collection<? extends T> tail;

    ConcatenatedCollections(Collection<? extends T> head, Collection<? extends T> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<? extends T> headIterator = this.head.iterator();
        final Iterator<? extends T> tailIterator = this.tail.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return headIterator.hasNext() || tailIterator.hasNext();
            }

            @Override
            public T next() {
                if (headIterator.hasNext()) {
                    return headIterator.next();
                }
                if (tailIterator.hasNext()) {
                    return tailIterator.next();
                }
                throw new NoSuchElementException();
            }
        };
    }

    @Override
    public int size() {
        return this.head.size() + this.tail.size();
    }
}

