/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.lsp.impl.typings;

import apex.jorje.lsp.api.document.Document;
import apex.jorje.lsp.api.services.ApexCompilerService;
import apex.jorje.lsp.impl.typings.ApexModuleGenerator;
import apex.jorje.lsp.impl.typings.ModuleGenerator;
import apex.jorje.lsp.impl.typings.SObjectModuleGenerator;
import apex.jorje.lsp.impl.typings.TypeDefinitionModule;
import apex.jorje.lsp.impl.typings.TypingOptions;
import apex.jorje.lsp.impl.utils.SfdxProjects;
import apex.jorje.semantic.compiler.CodeUnit;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import java.util.Optional;

class TypeDefinitionGenerator {
    private final ApexCompilerService compilerService;
    private final SfdxProjects utils;
    private final Document document;

    TypeDefinitionGenerator(ApexCompilerService compilerService, SfdxProjects utils, Document document) {
        this.compilerService = compilerService;
        this.utils = utils;
        this.document = document;
    }

    static String generateTypeDefinitionFileName(CodeUnit codeUnit) {
        String knownName = codeUnit.getSourceFile().getKnownName();
        String codeUnitName = codeUnit.getName();
        return TypeDefinitionGenerator.generateTypeDefinitionFileName(!Strings.isNullOrEmpty(knownName) ? Files.getNameWithoutExtension(knownName) : codeUnitName);
    }

    static String generateTypeDefinitionFileName(String name) {
        return String.format("%s.d.ts", name);
    }

    private boolean isSObject(CodeUnit codeUnit) {
        String unitPathString = codeUnit.getSourceFile().getKnownName();
        return this.utils.isSObject(unitPathString);
    }

    private boolean isSObject(Document document) {
        String unitPathString = document.getUri().toString();
        return this.utils.isSObject(unitPathString);
    }

    Optional<TypeDefinitionModule> buildModulesIfApplicable() {
        if (this.isSObject(this.document) && TypingOptions.disableLwcTypeGeneration()) {
            return Optional.empty();
        }
        CodeUnit codeUnit = this.compilerService.getCachedCodeUnitForIndexerStartup(this.document.getUri().toString());
        if (codeUnit == null) {
            codeUnit = this.compilerService.compile(this.document);
        }
        ModuleGenerator moduleGenerator = this.isSObject(codeUnit) ? new SObjectModuleGenerator(codeUnit) : new ApexModuleGenerator(codeUnit);
        return moduleGenerator.generateModulesIfApplicable();
    }
}

