/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.parser.impl;

import apex.common.base.ObjectHash;
import apex.jorje.data.Location;
import apex.jorje.parser.impl.HiddenToken;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public final class HiddenTokens {
    private HiddenTokens() {
    }

    public static HiddenToken newBlockComment(String value, Location location) {
        return new BlockComment(value, location);
    }

    public static HiddenToken newInlineComment(String value, Location location) {
        return new InlineComment(value, location);
    }

    public static class InlineComment
    implements HiddenToken {
        private final String value;
        private final Location location;

        private InlineComment(String value, Location location) {
            this.value = Objects.requireNonNull(value, "Hidden node value was null");
            this.location = Objects.requireNonNull(location, "Hidden node Location was null");
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public <T> T accept(HiddenToken.Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public int hashCode() {
            return ObjectHash.hash(this.value, this.location);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InlineComment)) {
                return false;
            }
            InlineComment that = (InlineComment)obj;
            return Objects.equals(this.location, that.location) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).add("location", this.location).toString();
        }
    }

    public static class BlockComment
    implements HiddenToken {
        private final String value;
        private final Location location;

        private BlockComment(String value, Location location) {
            this.value = Objects.requireNonNull(value, "Hidden node value was null");
            this.location = Objects.requireNonNull(location, "Hidden node Location was null");
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return ObjectHash.hash(this.value, this.location);
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public <T> T accept(HiddenToken.Visitor<T> visitor) {
            return visitor.visit(this);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof BlockComment)) {
                return false;
            }
            BlockComment that = (BlockComment)obj;
            return Objects.equals(this.location, that.location) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("value", this.value).add("location", this.location).toString();
        }
    }

    public static class HiddenTokenFactory {
        public static Optional<HiddenToken> createHiddenToken(int type, String value, Location location) {
            HiddenToken newHiddenToken = null;
            switch (type) {
                case 59: {
                    newHiddenToken = HiddenTokens.newInlineComment(value, location);
                    break;
                }
                case 17: {
                    newHiddenToken = HiddenTokens.newBlockComment(value, location);
                }
            }
            return Optional.ofNullable(newHiddenToken);
        }
    }
}

