/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.InternalTypeInfos;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.TypeInfoEquivalence;
import apex.jorje.semantic.symbol.type.TypeInfos;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;

public class ParentVisibility {
    private static boolean shouldCheckSuperType(TypeInfo type, TypeInfo superType) {
        if (superType == null) {
            return false;
        }
        if (TypeInfoEquivalence.isEquivalent(superType, TypeInfos.EXCEPTION) && !TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_EXCEPTION)) {
            return false;
        }
        return !TypeInfoEquivalence.isEquivalent(superType, TypeInfos.OBJECT) || TypeInfoEquivalence.isEquivalent(type, InternalTypeInfos.APEX_OBJECT);
    }

    public static void validate(SymbolScope scope, Compilation compilation) {
        TypeInfo superType;
        SymbolResolver symbols = scope.getSymbols();
        TypeInfo type = compilation.getDefiningType();
        if (ParentVisibility.shouldCheckSuperType(type, superType = type.parents().superType()) && !Visibility.isTypeVisible(symbols.getAccessEvaluator(), type, superType, Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES)) {
            scope.getErrors().markInvalid((AstNode)compilation, I18nSupport.getLabel("type.not.visible", superType));
        }
        for (TypeInfo parentInterface : type.parents().immediateInterfaces()) {
            if (Visibility.isTypeVisible(symbols.getAccessEvaluator(), type, parentInterface, Visibility.ReferencedFromTestMethod.NO, Visibility.CheckGenericTypeArguments.YES)) continue;
            scope.getErrors().markInvalid((AstNode)compilation, I18nSupport.getLabel("type.not.visible", parentInterface));
        }
    }
}

