/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.compilation;

import apex.jorje.data.Identifier;
import apex.jorje.data.Location;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.compilation.AdditionalInfo;
import apex.jorje.semantic.ast.compilation.ArgumentTypeCalculator;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.CompilationUtil;
import apex.jorje.semantic.ast.compilation.UserInterfaceMembers;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.context.TypeStack;
import apex.jorje.semantic.ast.member.Method;
import apex.jorje.semantic.ast.member.bridge.BridgeMethodCreator;
import apex.jorje.semantic.ast.modifier.ModifierNode;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.compiler.CompilationOutput;
import apex.jorje.semantic.compiler.SourceFile;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.member.IdentifierValidator;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.AbstractTypeInfo;
import apex.jorje.semantic.symbol.type.GenericTypeInfo;
import apex.jorje.semantic.symbol.type.StandardTypeInfoImpl;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import com.google.common.base.MoreObjects;
import java.util.List;
import org.objectweb.asm.ClassVisitor;

public class UserInterface
extends Compilation {
    private final Identifier name;
    private final TypeInfo interfaceType;
    private final UserInterfaceMembers members;
    private final AstNode bridgeMethods;
    private final AdditionalInfo additionalInfo;
    private final ModifierNode modifiers;

    public UserInterface(Errors errors, SourceFile source, AstNode definingNode, CompilationUnit.InterfaceDeclUnit compilationUnit) {
        InterfaceDecl body = compilationUnit.body;
        this.name = body.name;
        List<TypeInfo> argumentTypeInfos = ArgumentTypeCalculator.get().toArgumentTypes(errors, this, compilationUnit.body.typeArguments);
        StandardTypeInfoImpl.Builder builder = argumentTypeInfos.isEmpty() ? StandardTypeInfoImpl.builder() : GenericTypeInfo.builder().setTypeArguments(argumentTypeInfos);
        this.interfaceType = ((AbstractTypeInfo.Builder)builder.setViaSource(source, AstNodes.getDefiningType(definingNode), compilationUnit)).build();
        this.members = UserInterfaceMembers.create(this, this.interfaceType, compilationUnit.body);
        this.bridgeMethods = new BridgeMethodCreator(this);
        this.additionalInfo = AdditionalInfo.builder().setDefiningNode(this).build();
        this.modifiers = new ModifierNode(this, this.interfaceType.getModifiers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        scope.push(this);
        try {
            if (visitor.visit(this, scope)) {
                this.modifiers.traverse(visitor, scope);
                for (Method method : this.members.getMethods()) {
                    method.traverse(visitor, scope);
                }
                this.bridgeMethods.traverse(visitor, scope);
                this.additionalInfo.traverse(visitor, scope);
            }
            visitor.visitEnd(this, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        scope.push(this);
        try {
            Errors errors = scope.getErrors();
            errors.addIfError(this, CompilationUtil.validateHasTopLevelModifiers(this));
            errors.addIfError((AstNode)this, this.name.getLoc(), IdentifierValidator.get().validate(this.interfaceType, this.name.getValue(), IdentifierValidator.Type.INTERFACE, TypeInfoUtil.isTopLevel(this.interfaceType), false));
            if (errors.isInvalid(this)) {
                return;
            }
            for (Method method : this.members.getMethods()) {
                method.validate(symbols, scope);
            }
            this.bridgeMethods.validate(symbols, scope);
            this.additionalInfo.validate(symbols, scope);
            this.modifiers.validate(symbols, scope);
        }
        finally {
            scope.pop(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void emit(Emitter emitter) {
        CompilationOutput.Builder output = CompilationOutput.builder(this.interfaceType);
        TypeStack.TypeContext clazz = TypeStack.TypeContext.builder().setType(this.interfaceType).build();
        emitter.getTypeStack().push(clazz);
        try {
            emitter.getAnnotationVisitor().set((ClassVisitor)clazz.getClassWriter());
            this.modifiers.emit(emitter);
            emitter.getAnnotationVisitor().unset();
            this.additionalInfo.emitAnnotation(emitter);
            for (Method method : this.members.getMethods()) {
                method.emit(emitter);
            }
            this.bridgeMethods.emit(emitter);
            this.additionalInfo.emit(emitter);
        }
        finally {
            byte[] bytes = CompilationUtil.getBytesOrAddTooLargeError(clazz.getClassWriter(), this, emitter.getCodeUnit().getErrors());
            emitter.getTypeStack().pop();
            this.setOutput(output.setBytes(bytes).setLines(clazz.getKnownCodeLocations()).build());
        }
    }

    @Override
    public TypeInfo getDefiningType() {
        return this.interfaceType;
    }

    @Override
    public Location getLoc() {
        return this.name.getLoc();
    }

    public ModifierNode getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("interfaceType", this.interfaceType).add("members", this.members).toString();
    }
}

