/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.expression;

import apex.jorje.data.Location;
import apex.jorje.data.Locations;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.AstNodes;
import apex.jorje.semantic.ast.TypeConversion;
import apex.jorje.semantic.ast.context.Emitter;
import apex.jorje.semantic.ast.expression.Expression;
import apex.jorje.semantic.ast.expression.PolymorphicTypes;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.Scope;
import apex.jorje.semantic.ast.visitor.ValidationScope;
import apex.jorje.semantic.common.util.VersionUtil;
import apex.jorje.semantic.exception.Errors;
import apex.jorje.semantic.symbol.resolver.Distance;
import apex.jorje.semantic.symbol.resolver.SymbolResolver;
import apex.jorje.semantic.symbol.type.BasicType;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.UnresolvedErrorCalculator;
import apex.jorje.semantic.symbol.visibility.Visibility;
import apex.jorje.services.I18nSupport;
import apex.jorje.services.Version;

public class CastExpression
extends Expression {
    private final Location loc;
    private final TypeRef typeRef;
    private final Expression expression;
    private TypeInfo type;

    public CastExpression(AstNode definingNode, Expr.CastExpr expr) {
        super(definingNode);
        this.loc = Locations.from(expr);
        this.typeRef = expr.type;
        this.expression = AstNodes.get().create((AstNode)this, expr.expr);
    }

    @Override
    public <T extends Scope> void traverse(AstVisitor<T> visitor, T scope) {
        if (visitor.visit(this, scope)) {
            this.expression.traverse(visitor, scope);
        }
        visitor.visitEnd(this, scope);
    }

    @Override
    public void validate(SymbolResolver symbols, ValidationScope scope) {
        this.expression.validate(symbols, scope);
        Errors errors = scope.getErrors();
        if (errors.isInvalid(this.expression) || this.typeRef == null) {
            errors.markInvalid(this);
            return;
        }
        this.type = symbols.lookupTypeInfo(this.getDefiningType(), this.typeRef);
        TypeInfo expressionType = this.expression.getType();
        if (!this.type.isResolved()) {
            errors.markInvalid((AstNode)this, UnresolvedErrorCalculator.getErrors(this.type));
            return;
        }
        if (!Visibility.isTypeVisible(symbols.getAccessEvaluator(), this.getDefiningType(), this.type, Visibility.ReferencedFromTestMethod.fromBoolean(scope.isTestMethod()), Visibility.CheckGenericTypeArguments.YES)) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("type.not.visible", this.type));
            return;
        }
        if (!this.isLegalBasicType(this, expressionType.getBasicType())) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("invalid.cast.type", expressionType));
            return;
        }
        if (Distance.get().getCommonType(this.getDefiningType(), expressionType, this.type) == null && !PolymorphicTypes.isAssignable(this.getDefiningType(), this.expression, this.type) && expressionType.getUnitType() != UnitType.INTERFACE && this.type.getUnitType() != UnitType.INTERFACE) {
            errors.markInvalid((AstNode)this, I18nSupport.getLabel("incompatible.cast.types", this.expression.getType(), this.type));
        }
        this.setType(this.type);
    }

    @Override
    public void emit(Emitter emitter) {
        this.expression.emit(emitter);
        if (this.expression.getType().getBasicType() == BasicType.VOID) {
            emitter.emit(this.loc, 1);
        }
        TypeConversion.emitOrCheckCast(this.loc, emitter, this.expression.getType(), this.getType());
    }

    private boolean isLegalBasicType(AstNode node, BasicType basicType) {
        return basicType.canBeCastOrInstanceOf() || basicType == BasicType.VOID && VersionUtil.get(node).isLessThan(Version.V174);
    }

    @Override
    public Location getLoc() {
        return this.loc;
    }

    public TypeInfo getCastType() {
        return this.type;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public Expression getExpression() {
        return this.expression;
    }
}

