/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.semantic.ast.visitor;

import apex.common.base.MoreStrings;
import apex.jorje.semantic.ast.AstNode;
import apex.jorje.semantic.ast.compilation.AnonymousClass;
import apex.jorje.semantic.ast.compilation.Compilation;
import apex.jorje.semantic.ast.compilation.UserClass;
import apex.jorje.semantic.ast.compilation.UserEnum;
import apex.jorje.semantic.ast.compilation.UserInterface;
import apex.jorje.semantic.ast.compilation.UserTrigger;
import apex.jorje.semantic.ast.visitor.AstVisitor;
import apex.jorje.semantic.ast.visitor.SymbolScope;
import apex.jorje.semantic.symbol.type.TypeInfo;
import apex.jorje.semantic.symbol.type.UnitType;
import apex.jorje.semantic.symbol.type.common.TypeInfoUtil;
import apex.jorje.services.I18nSupport;

public class SymbolVisitor
extends AstVisitor<SymbolScope> {
    @Override
    public boolean visit(AnonymousClass node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    @Override
    public boolean visit(UserClass node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    @Override
    public boolean visit(UserEnum node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return false;
    }

    @Override
    public boolean visit(UserInterface node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return false;
    }

    @Override
    public boolean visit(UserTrigger node, SymbolScope scope) {
        this.visitCompilation(node, scope);
        return true;
    }

    private void visitCompilation(Compilation node, SymbolScope scope) {
        TypeInfo definingType = node.getDefiningType();
        boolean duplicateName = scope.getSymbols().add(definingType);
        if (duplicateName) {
            scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.type.name", definingType));
        } else if (TypeInfoUtil.isInnerType(definingType)) {
            boolean topLevelNameConflict;
            TypeInfo topLevelType = TypeInfoUtil.getTopLevel(definingType);
            boolean bl = topLevelNameConflict = topLevelType.getUnitType() != UnitType.TRIGGER && MoreStrings.equalsIgnoreCase(topLevelType.getCodeUnitDetails().getName(), definingType.getCodeUnitDetails().getName());
            if (topLevelNameConflict) {
                scope.getErrors().markInvalid((AstNode)node, I18nSupport.getLabel("duplicate.type.name", topLevelType));
            }
        }
    }
}

