/*
 * psi-otr.h - off-the-record messaging plugin for psi
 *
 * Copyright (C) Timo Engel (timo-e@freenet.de), Berlin 2007.
 * This program was written as part of a diplom thesis advised by 
 * Prof. Dr. Ruediger Weis (PST Labor)
 * at the Technical University of Applied Sciences Berlin.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef PSIOTRPLUGIN_HPP_
#define PSIOTRPLUGIN_HPP_

#include <QObject>
#include <QtGui>
#include <QDomElement>

#include "include/psiplugin.h"
#include "include/eventfilter.h"
#include "include/optionaccessinghost.h"
#include "include/optionaccessor.h"
#include "include/stanzasender.h"
#include "include/stanzasendinghost.h"

namespace psiotr
{

class ConfigDlg;
class PsiOtrClosure;
class OtrMessaging;

//-----------------------------------------------------------------------------

class PsiOtrPlugin : public QObject,
                     public PsiPlugin,
                     public EventFilter,
                     public OptionAccessor,
                     public StanzaSender
{
Q_OBJECT
Q_INTERFACES(PsiPlugin
             EventFilter
             OptionAccessor
             StanzaSender)

public:
	PsiOtrPlugin();
	~PsiOtrPlugin();


    // PsiPlugin
	virtual QString name() const;
	virtual QString shortName() const;
	virtual QString version() const;
	virtual QWidget* options() const; 
    virtual bool enable();
    virtual bool disable();
	virtual void logout(int account);
	virtual void contactOnline(int account, const QString& jid);
	virtual void contactOffline(int account, const QString& jid);
    virtual QAction* getChatDlgMenuEntries(QWidget* parent,
                                           int account,
                                           const QString& otherJid);
    virtual void setHomeDir(const QString& dir);


    // EventFilter
    virtual bool processEvent(int account, const QDomElement& e);
    virtual bool processMessage(int account, const QString& fromJid,
                                QString& body, QString& subject);
    virtual bool processMessage(int account, const QString& fromJid,
                                QDomElement& body, QString& subject);
    virtual bool processOutgoingMessage(int account, const QString& toJid,
                                        QString& body, QString& subject);


    // OptionAccessor
    virtual void setOptionAccessingHost(OptionAccessingHost* host);
    virtual void optionChanged(const QString& option);


    // StanzaSender
    virtual void setStanzaSendingHost(StanzaSendingHost *host);


    // other methods
    /**
     * Sends a message from the Account account to the user toJid.
     * The method is called from the OtrConnection to send messages
     * during key-exchange.
     */
	void sendMessage(int account, const QString& toJid,
                     const QString& message);

    QVariant getPsiOption(const QString& option);

	QString psiDataDir();

	bool isLoggedIn(int account, QString jid);


private:
	OtrMessaging*                              m_otrConnection;
	QHash<int, QHash<QString, psiotr::PsiOtrClosure*> > m_onlineUsers;
    QString                                     m_psiDataDir;
    OptionAccessingHost*                        m_optionHost;
    StanzaSendingHost*                          m_senderHost;


};

//-----------------------------------------------------------------------------

} // namespace psiotr

#endif /*PSITESTPLUGIN_H_*/
