static const char  dxf14acadheader_prelayer1 [] =
"  0\n"
"SECTION\n"
"  2\n"
"HEADER\n"
"  9\n"
"$ACADVER\n"
"  1\n"
"AC1014\n"

#if 1
"  9\n"
"$HANDSEED\n"
"  5\n"
"22\n" 
#endif
// Tricky. Should be "on the safe side", i.e. larger than any "  5" entry used in file
// but that would need to defer the dumping of this until we know all entities.
// On the other hand - there is indication that autocad ignore this value
// https://ezdxf.readthedocs.io/en/latest/dxfinternals/handles.html
// so setting it to a value of a not used handle. 
// TrueView complains about this value being to small and suggests a correction
// but still accepts the file
;

// in between here comes the MEASUREMENT entry - but that depends on the command line options (-mm)

static const char  dxf14acadheader_prelayer2 [] =
"  0\n"
"ENDSEC\n"

"  0\n"
"SECTION\n"
"  2\n"
"TABLES\n"
"  0\n"
"TABLE\n"
"  2\n"
"VPORT\n"
"  5\n"
"8\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     4\n"
"  0\n"
"VPORT\n"
"  5\n"
"2E\n"
"330\n"
"8\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbViewportTableRecord\n"
"  2\n"
"*ACTIVE\n"
" 70\n"
"     0\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 11\n"
"1.0\n"
" 21\n"
"1.0\n"
" 12\n"
"210\n"
" 22\n"
"148.5\n"
" 13\n"
"0.0\n"
" 23\n"
"0.0\n"
" 14\n"
"10.0\n"
" 24\n"
"10.0\n"
" 15\n"
"10.0\n"
" 25\n"
"10.0\n"
" 16\n"
"0.0\n"
" 26\n"
"0.0\n"
" 36\n"
"1.0\n"
" 17\n"
"0.0\n"
" 27\n"
"0.0\n"
" 37\n"
"0.0\n"
" 40\n"
"340.9950045922664\n"
" 41\n"
"1.239944521497919\n"
" 42\n"
"50.0\n"
" 43\n"
"0.0\n"
" 44\n"
"0.0\n"
" 50\n"
"0.0\n"
" 51\n"
"0.0\n"
" 71\n"
"     0\n"
" 72\n"
"   100\n"
" 73\n"
"     1\n"
" 74\n"
"     3\n"
" 75\n"
"     0\n"
" 76\n"
"     0\n"
" 77\n"
"     0\n"
" 78\n"
"     0\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"LTYPE\n"
"  5\n"
"5\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     1\n"
"  0\n"
"LTYPE\n"
"  5\n"
"14\n"
"330\n"
"5\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"BYBLOCK\n"
" 70\n"
"     0\n"
"  3\n"
"\n"
" 72\n"
"    65\n"
" 73\n"
"     0\n"
" 40\n"
"0.0\n"
"  0\n"
"LTYPE\n"
"  5\n"
"15\n"
"330\n"
"5\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"BYLAYER\n"
" 70\n"
"     0\n"
"  3\n"
"\n"
" 72\n"
"    65\n"
" 73\n"
"     0\n"
" 40\n"
"0.0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"16\n"
"330\n"
"5\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"CONTINUOUS\n"
" 70\n"
"     0\n"
"  3\n"
"Solid line\n"
" 72\n"
"    65\n"
" 73\n"
"     0\n"
" 40\n"
"0.0\n";

//  solid=0, dashed, dotted, dashdot, dashdotdot
/*
solid		CONTINUOUS: Solid
dashed		DASHED: Dashed __ __ __ __ __ __ __ __ __ __ __ __ __ _
dashdot		DASHDOT: Dash dot __ . __ . __ . __ . __ . __ . __ . __
dotted		DOT: Dot .  .  .  .  .  .  .  .  .  .  .  .  .  .  .  .
dashdotdot	DIVIDE: Divide __ . . __ . . __ . . __ . . __ . . __

not supported styles:
DIVIDEX2: Divide (2x) ____  . .  ____  . .  ____  . .  ____
DIVIDE2: Divide (.5) _ . _ . _ . _ . _ . _ . _ . _
CENTER: Center ____ _ ____ _ ____ _ ____ _ ____ _ ____
CENTERX2: Center (2x) ________  __  ________  __  ________
CENTER2: Center (.5x) ____ _ ____ _ ____ _ ____ _ ____
DASHEDX2: Dashed (2x) ____  ____  ____  ____  ____  ____
DASHED2:Dashed (.5x) _ _ _ _ _ _ _ _ _ _ _ _ _ _
PHANTOM: Phantom ______  __  __  ______  __  __  ______
PHANTOMX2: Phantom (2x)____________    ____    ____    ____________
PHANTOM2: Phantom (.5x) ___ _ _ ___ _ _ ___ _ _ ___ _ _ ___
DASHDOTX2: Dash dot (2x) ____  .  ____  .  ____  .  ____
DASHDOT2: Dash dot (.5x) _ . _ . _ . _ . _ . _ . _ . _
DOTX2: Dot (2x) .    .    .    .    .    .    .    .
DOT2: Dot (.5) . . . . . . . . . . . . . . . . . . .
*/


class DXF_LineType {
public:
	explicit DXF_LineType(const char * const name,
		const char * const description,
		const std::initializer_list<double>& pattern) :
		m_name(name),
		m_description(description),
		m_pattern(pattern)
	{}
	friend ostream & operator << (ostream & out, const DXF_LineType & lt) {

		double length = 0.0;
		for (auto l : lt.m_pattern) length += abs(l);
		
		out <<
			"  0\n"
			"LTYPE\n";
		write_DXF_handle(out, DXF_LineType::handle);
			//"  5\n"
			//<< DXF_LineType::handle << endl <<
			//		"131\n"
		out <<
			"100\n"
			"AcDbSymbolTableRecord\n"
			"100\n"
			"AcDbLinetypeTableRecord\n"
			"  2\n"
			<< lt.m_name << endl <<
			//	"DOT\n"
			" 70\n" // flags
			"0\n"
			"  3\n" 
			<< lt.m_description << endl <<
			//	"Dot . . . . . . . . . . . . . . . . . . . . . .\n"
			" 72\n" // always 65
			"65\n"
			" 73\n" // number of "49" entries below
			<< lt.m_pattern.size() << endl <<
			" 40\n" // overall length
			<< length * DXF_LineType::scalefactor << endl;
	
		
		for (auto l : lt.m_pattern) {
			out << " 49\n" << l * DXF_LineType::scalefactor << endl <<
				" 74\n" // no complex line segment
				"0\n";
		}
		
		DXF_LineType::handle++;
		return out;
	}
	static double scalefactor;
	static int handle;
private:
	
	const char * const m_name;
	const char * const m_description;
	const std::vector<double> m_pattern;
};
double DXF_LineType::scalefactor = 1.0;
int DXF_LineType::handle = 0xF0; // starting handle

constexpr double inch = 72.0; // 1 inch = 72 postscript points
constexpr double linedash = 0.2 * inch;
constexpr double linespace = -0.1 * inch; // neg means space
constexpr double dot = 0.0;

static const DXF_LineType dxf_dotted(
    "DOT",
    "Dot . . . . . . . . . . . . . . . . . . . . . .",
    {dot, linespace} 
);

static const DXF_LineType dxf_dashed(
	"DASHED",
	"Dashed __ __ __ __ __ __ __ __ __ __ __ __ __ _",
	{linedash, linespace }
);

static const DXF_LineType dxf_dashdot(
	"DASHDOT",
	"Dash dot __ . __ . __ . __ . __ . __ . __ . __",
	{linedash, linespace, dot, linespace }
);

static const DXF_LineType dxf_dashdotdot(
	"DIVIDE",
	"Divide ____ ..____ ..____ ..____ ..____",
	{linedash,linespace, dot, linespace, dot, linespace }
);

/*
"  0\n"
"LTYPE\n"
"  5\n"
"132\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DOT2\n"
" 70\n"
"0\n"
"  3\n"
"Dot (.5x) .....................................\n"
" 72\n"
"65\n"
" 73\n"
"2\n"
" 40\n"
"3.1749999999999998\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"133\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DOTX2\n"
" 70\n"
"0\n"
"  3\n"
"Dot (2x) .  .  .  .  .  .  .  .  .  .  .  .  .\n"
" 72\n"
"65\n"
" 73\n"
"2\n"
" 40\n"
"12.6999999999999993\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
*/

/*
"  0\n"
"LTYPE\n"
"  5\n"
"135\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DASHED2\n"
" 70\n"
"0\n"
"  3\n"
"Dashed (.5x) _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _\n"
" 72\n"
"65\n"
" 73\n"
"2\n"
" 40\n"
"9.5250000000000004\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"136\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DASHEDX2\n"
" 70\n"
"0\n"
"  3\n"
"Dashed (2x) ____  ____  ____  ____  ____  ___\n"
" 72\n"
"65\n"
" 73\n"
"2\n"
" 40\n"
"38.1000000000000014\n"
" 49\n"
"25.3999999999999986\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
*/

/*
"  0\n"
"LTYPE\n"
"  5\n"
"138\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DASHDOT2\n"
" 70\n"
"0\n"
"  3\n"
"Dash dot (.5x) _._._._._._._._._._._._._._._.\n"
" 72\n"
"65\n"
" 73\n"
"4\n"
" 40\n"
"12.6999999999999993\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"139\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DASHDOTX2\n"
" 70\n"
"0\n"
"  3\n"
"Dash dot (2x) ____  .  ____  .  ____  .  ___\n"
" 72\n"
"65\n"
" 73\n"
"4\n"
" 40\n"
"50.7999999999999972\n"
" 49\n"
"25.3999999999999986\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
*/

/*
"  0\n"
"LTYPE\n"
"  5\n"
"13B\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DIVIDE2\n"
" 70\n"
"0\n"
"  3\n"
"Divide (.5x) __..__..__..__..__..__..__..__.._\n"
" 72\n"
"65\n"
" 73\n"
"6\n"
" 40\n"
"15.875\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"13C\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"DIVIDEX2\n"
" 70\n"
"0\n"
"  3\n"
"Divide (2x) ________  .  .  ________  .  .  _\n"
" 72\n"
"65\n"
" 73\n"
"6\n"
" 40\n"
"63.5\n"
" 49\n"
"25.3999999999999986\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"13D\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"CENTER\n"
" 70\n"
"0\n"
"  3\n"
"Center ____ _ ____ _ ____ _ ____ _ ____ _ ____\n"
" 72\n"
"65\n"
" 73\n"
"4\n"
" 40\n"
"50.7999999999999972\n"
" 49\n"
"31.75\n"
" 74\n"
"0\n"
" 49\n"
"-6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-6.3499999999999996\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"13E\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"CENTER2\n"
" 70\n"
"0\n"
"  3\n"
"Center (.5x) ___ _ ___ _ ___ _ ___ _ ___ _ ___\n"
" 72\n"
"65\n"
" 73\n"
"4\n"
" 40\n"
"28.5749999999999993\n"
" 49\n"
"19.0500000000000007\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"13F\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"CENTERX2\n"
" 70\n"
"0\n"
"  3\n"
"Center (2x) ________  __  ________  __  _____\n"
" 72\n"
"65\n"
" 73\n"
"4\n"
" 40\n"
"101.5999999999999943\n"
" 49\n"
"63.5\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"140\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"BORDER\n"
" 70\n"
"0\n"
"  3\n"
"Border __ __ . __ __ . __ __ . __ __ . __ __ .\n"
" 72\n"
"65\n"
" 73\n"
"6\n"
" 40\n"
"44.4500000000000028\n"
" 49\n"
"12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"-6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"-6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-6.3499999999999996\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"141\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"BORDER2\n"
" 70\n"
"0\n"
"  3\n"
"Border (.5x) __.__.__.__.__.__.__.__.__.__.__.\n"
" 72\n"
"65\n"
" 73\n"
"6\n"
" 40\n"
"22.2250000000000014\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"6.3499999999999996\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-3.1749999999999998\n"
" 74\n"
"0\n"

"  0\n"
"LTYPE\n"
"  5\n"
"142\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLinetypeTableRecord\n"
"  2\n"
"BORDERX2\n"
" 70\n"
"0\n"
"  3\n"
"Border (2x) ____  ____  .  ____  ____  .  ___\n"
" 72\n"
"65\n"
" 73\n"
"6\n"
" 40\n"
"88.9000000000000057\n"
" 49\n"
"25.3999999999999986\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"25.3999999999999986\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
" 49\n"
"0.0\n"
" 74\n"
"0\n"
" 49\n"
"-12.6999999999999993\n"
" 74\n"
"0\n"
*/

static const char dxf14_line_type_tab_trailer_and_begin_of_layer_tab[]  =
"  0\n"
"ENDTAB\n"
// begin layer tab
"  0\n"
"TABLE\n"
"  2\n"
"LAYER\n"
"  5\n"
"2\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n" ;
// "   5000\n"  // number of layers 

static const char dxf14layer0def[] =
// begin layer "0"
"  0\n"
"LAYER\n"
"  5\n"
"10\n"
"330\n"
"2\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbLayerTableRecord\n"
"  2\n"
"0\n"
" 70\n"
"     0\n"
" 62\n"
"     7\n"
"  6\n"
"CONTINUOUS\n";

static const char dummy[] =
"1001\n"
"URBANX\n"
"1000\n"
"VER\n"
"1000\n"
"3.1\n"
"1000\n"
"DRAWN\n"
"1000\n"
"m\n"
"1000\n"
"GRSEE\n";
// end layer 0

#if 0
-----------
  0
LAYER
  5
2E
100
AcDbSymbolTableRecord
100
AcDbLayerTableRecord
  2
NEWLAYER1  // layername
 70
           0  // unfrozen
 62
           1	// color
  6
CONTINUOUS		// linestyle
------------
#endif

static const char  dxf14acadheader_postlayer [] =
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"STYLE\n"
"  5\n"
"3\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     1\n"
"  0\n"
"STYLE\n"
"  5\n"
"11\n"
"330\n"
"3\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbTextStyleTableRecord\n"
"  2\n"
"STANDARD\n"
" 70\n"
"     0\n"
" 40\n"
"0.0\n"
" 41\n"
"1.0\n"
" 50\n"
"0.0\n"
" 71\n"
"     0\n"
" 42\n"
"2.5\n"
"  3\n"
"txt\n"
"  4\n"
"\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"VIEW\n"
"  5\n"
"6\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     0\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"UCS\n"
"  5\n"
"7\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     0\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"APPID\n"
"  5\n"
"9\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     2\n"
"  0\n"
"APPID\n"
"  5\n"
"12\n"
"330\n"
"9\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbRegAppTableRecord\n"
"  2\n"
"ACAD\n"
" 70\n"
"     0\n"
"  0\n"
"APPID\n"
"  5\n"
"2B\n"
"330\n"
"9\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbRegAppTableRecord\n"
"  2\n"
"URBANX\n"
" 70\n"
"     0\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"DIMSTYLE\n"
"  5\n"
"A\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     1\n"
"  0\n"
"DIMSTYLE\n"
"105\n"
"27\n"
"330\n"
"A\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbDimStyleTableRecord\n"
"  2\n"
"ISO-25\n"
" 70\n"
"     0\n"
"  3\n"
"\n"
"  4\n"
"\n"
"  5\n"
"\n"
"  6\n"
"\n"
"  7\n"
"\n"
" 40\n"
"1.0\n"
" 41\n"
"2.5\n"
" 42\n"
"0.625\n"
" 43\n"
"3.75\n"
" 44\n"
"1.25\n"
" 45\n"
"0.0\n"
" 46\n"
"0.0\n"
" 47\n"
"0.0\n"
" 48\n"
"0.0\n"
"140\n"
"2.5\n"
"141\n"
"2.5\n"
"142\n"
"0.0\n"
"143\n"
"0.03937007874016\n"
"144\n"
"1.0\n"
"145\n"
"0.0\n"
"146\n"
"1.0\n"
"147\n"
"0.625\n"
" 71\n"
"     0\n"
" 72\n"
"     0\n"
" 73\n"
"     0\n"
" 74\n"
"     0\n"
" 75\n"
"     0\n"
" 76\n"
"     0\n"
" 77\n"
"     1\n"
" 78\n"
"     8\n"
"170\n"
"     0\n"
"171\n"
"     3\n"
"172\n"
"     1\n"
"173\n"
"     0\n"
"174\n"
"     0\n"
"175\n"
"     0\n"
"176\n"
"     0\n"
"177\n"
"     0\n"
"178\n"
"     0\n"
"270\n"
"     2\n"
"271\n"
"     2\n"
"272\n"
"     2\n"
"273\n"
"     2\n"
"274\n"
"     3\n"
"340\n"
"11\n"
"275\n"
"     0\n"
"280\n"
"     0\n"
"281\n"
"     0\n"
"282\n"
"     0\n"
"283\n"
"     0\n"
"284\n"
"     8\n"
"285\n"
"     0\n"
"286\n"
"     0\n"
"287\n"
"     3\n"
"288\n"
"     0\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"TABLE\n"
"  2\n"
"BLOCK_RECORD\n"
"  5\n"
"1\n"
"330\n"
"0\n"
"100\n"
"AcDbSymbolTable\n"
" 70\n"
"     1\n"
"  0\n"
"BLOCK_RECORD\n"
"  5\n"
"1F\n"
"102\n"
"{ACAD_XDICTIONARY\n"
"360\n"
"52\n"
"102\n"
"}\n"
"330\n"
"1\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbBlockTableRecord\n"
"  2\n"
"*MODEL_SPACE\n"
"  0\n"
"BLOCK_RECORD\n"
"  5\n"
"1B\n"
"102\n"
"{ACAD_XDICTIONARY\n"
"360\n"
"50\n"
"102\n"
"}\n"
"330\n"
"1\n"
"100\n"
"AcDbSymbolTableRecord\n"
"100\n"
"AcDbBlockTableRecord\n"
"  2\n"
"*PAPER_SPACE\n"
"  0\n"
"ENDTAB\n"
"  0\n"
"ENDSEC\n"
"  0\n"
"SECTION\n"
"  2\n"
"BLOCKS\n"
"  0\n"
"BLOCK\n"
"  5\n"
"20\n"
"330\n"
"1F\n"
"100\n"
"AcDbEntity\n"
"  8\n"
"0\n"
"100\n"
"AcDbBlockBegin\n"
"  2\n"
"*MODEL_SPACE\n"
" 70\n"
"     0\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  3\n"
"*MODEL_SPACE\n"
"  1\n"
"\n"
"  0\n"
"ENDBLK\n"
"  5\n"
"21\n"
"330\n"
"1F\n"
"100\n"
"AcDbEntity\n"
"  8\n"
"0\n"
"100\n"
"AcDbBlockEnd\n"
"  0\n"
"BLOCK\n"
"  5\n"
"1C\n"
"330\n"
"1B\n"
"100\n"
"AcDbEntity\n"
" 67\n"
"     1\n"
"  8\n"
"0\n"
"100\n"
"AcDbBlockBegin\n"
"  2\n"
"*PAPER_SPACE\n"
"  1\n"
"\n"
"  0\n"
"ENDBLK\n"
"  5\n"
"1D\n"
"330\n"
"1B\n"
"100\n"
"AcDbEntity\n"
" 67\n"
"     1\n"
"  8\n"
"0\n"
"100\n"
"AcDbBlockEnd\n"
"  0\n"
"ENDSEC\n"
"  0\n"
"SECTION\n"
"  2\n"
"ENTITIES\n";

static const char  dxf14acadspline [] =
"  0\n"
"SPLINE\n"
"  5\n"
"2D\n"
"330\n"
"1F\n"
"100\n"
"AcDbEntity\n"
"  8\n"
"0\n"
"100\n"
"AcDbSpline\n"
"210\n"
"0.0\n"
"220\n"
"0.0\n"
"230\n"
"1.0\n"
" 70\n"
"     8\n"
" 71\n"
"     3\n"
" 72\n"
"    10\n"
" 73\n"
"     6\n"
" 74\n"
"     4\n"
" 42\n"
"0.0000000001\n"
" 43\n"
"0.0000000001\n"
" 44\n"
"0.0000000001\n"
" 12\n"
"0.9600201760045486\n"
" 22\n"
"0.2799308158531239\n"
" 32\n"
"0.0\n"
" 13\n"
"0.635206988684598\n"
" 23\n"
"0.7723419459839307\n"
" 33\n"
"0.0\n"
" 40\n"
"0.0\n"
" 40\n"
"0.0\n"
" 40\n"
"0.0\n"
" 40\n"
"0.0\n"
" 40\n"
"85.71498544287253\n"
" 40\n"
"177.5696755707102\n"
" 40\n"
"259.0922699980426\n"
" 40\n"
"259.0922699980426\n"
" 40\n"
"259.0922699980426\n"
" 40\n"
"259.0922699980426\n"
" 10\n"
"70.16401489310567\n"
" 20\n"
"112.369642808922\n"
" 30\n"
"0.0\n"
" 10\n"
"97.5933866968036\n"
" 20\n"
"120.367731410876\n"
" 30\n"
"0.0\n"
" 10\n"
"112.3732360579726\n"
" 20\n"
"213.1518597804941\n"
" 30\n"
"0.0\n"
" 10\n"
"224.8599410796318\n"
" 20\n"
"142.7027151961756\n"
" 30\n"
"0.0\n"
" 10\n"
"259.8222391922194\n"
" 20\n"
"206.1488870685476\n"
" 30\n"
"0.0\n"
" 10\n"
"277.0834797641999\n"
" 20\n"
"227.1366601424358\n"
" 30\n"
"0.0\n"
" 11\n"
"70.16401489310567\n"
" 21\n"
"112.369642808922\n"
" 31\n"
"0.0\n"
" 11\n"
"126.3818602886212\n"
" 21\n"
"177.0736812343384\n"
" 31\n"
"0.0\n"
" 11\n"
"218.0311208411052\n"
" 21\n"
"170.9338816721384\n"
" 31\n"
"0.0\n"
" 11\n"
"277.0834797641999\n"
" 21\n"
"227.1366601424358\n"
" 31\n"
"0.0\n";

static const char  dxf14acadtrailer [] =
"  0\n"
"ENDSEC\n"
"  0\n"
"SECTION\n"
"  2\n"
"OBJECTS\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"C\n"
"330\n"
"0\n"
"100\n"
"AcDbDictionary\n"
"  3\n"
"ACAD_GROUP\n"
"350\n"
"D\n"
"  3\n"
"ACAD_LAYOUT\n"
"350\n"
"1A\n"
"  3\n"
"ACAD_MLINESTYLE\n"
"350\n"
"17\n"
"  3\n"
"ACAD_PLOTSETTINGS\n"
"350\n"
"19\n"
"  3\n"
"ACAD_PLOTSTYLENAME\n"
"350\n"
"E\n"
"  3\n"
"ACDBHEADERROUNDTRIPXREC\n"
"350\n"
"2F\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"52\n"
"330\n"
"1F\n"
"100\n"
"AcDbDictionary\n"
"280\n"
"     1\n"
"  3\n"
"ACAD_LAYOUTSELFREF\n"
"360\n"
"53\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"50\n"
"330\n"
"1B\n"
"100\n"
"AcDbDictionary\n"
"280\n"
"     1\n"
"  3\n"
"ACAD_LAYOUTSELFREF\n"
"360\n"
"51\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"D\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"1A\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"17\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"  3\n"
"STANDARD\n"
"350\n"
"18\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"19\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"  0\n"
"ACDBDICTIONARYWDFLT\n"
"  5\n"
"E\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"281\n"
"     1\n"
"  3\n"
"Normal\n"
"350\n"
"F\n"
"100\n"
"AcDbDictionaryWithDefault\n"
"340\n"
"F\n"
"  0\n"
"DICTIONARY\n"
"  5\n"
"2F\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"C\n"
"102\n"
"}\n"
"330\n"
"C\n"
"100\n"
"AcDbDictionary\n"
"  3\n"
"CEPSNTYPE\n"
"350\n"
"39\n"
"  3\n"
"DIMSTYLEDATA\n"
"350\n"
"3D\n"
"  3\n"
"FINGERPRINTGUID\n"
"350\n"
"3A\n"
"  3\n"
"HYPERLINKBASE\n"
"350\n"
"32\n"
"  3\n"
"INSUNITS\n"
"350\n"
"38\n"
"  3\n"
"LAYOUTDICT\n"
"350\n"
"34\n"
"  3\n"
"LWETCUNION\n"
"350\n"
"37\n"
"  3\n"
"PLOTSETDICT\n"
"350\n"
"35\n"
"  3\n"
"PLOTSTYLNAMDICT\n"
"350\n"
"36\n"
"  3\n"
"PSVPSCALE\n"
"350\n"
"3C\n"
"  3\n"
"PUCSBASE\n"
"350\n"
"40\n"
"  3\n"
"PUCSORGBACK\n"
"350\n"
"46\n"
"  3\n"
"PUCSORGBOTTOM\n"
"350\n"
"42\n"
"  3\n"
"PUCSORGFRONT\n"
"350\n"
"45\n"
"  3\n"
"PUCSORGLEFT\n"
"350\n"
"43\n"
"  3\n"
"PUCSORGRIGHT\n"
"350\n"
"44\n"
"  3\n"
"PUCSORGTOP\n"
"350\n"
"41\n"
"  3\n"
"PUCSORTHOREF\n"
"350\n"
"3E\n"
"  3\n"
"PUCSORTHOVIEW\n"
"350\n"
"3F\n"
"  3\n"
"STYLESHEET\n"
"350\n"
"33\n"
"  3\n"
"TSTACKALIGN\n"
"350\n"
"30\n"
"  3\n"
"TSTACKSIZE\n"
"350\n"
"31\n"
"  3\n"
"UCSBASE\n"
"350\n"
"49\n"
"  3\n"
"UCSORGBACK\n"
"350\n"
"4F\n"
"  3\n"
"UCSORGBOTTOM\n"
"350\n"
"4B\n"
"  3\n"
"UCSORGFRONT\n"
"350\n"
"4E\n"
"  3\n"
"UCSORGLEFT\n"
"350\n"
"4C\n"
"  3\n"
"UCSORGRIGHT\n"
"350\n"
"4D\n"
"  3\n"
"UCSORGTOP\n"
"350\n"
"4A\n"
"  3\n"
"UCSORTHOREF\n"
"350\n"
"47\n"
"  3\n"
"UCSORTHOVIEW\n"
"350\n"
"48\n"
"  3\n"
"VERSIONGUID\n"
"350\n"
"3B\n"
"  0\n"
"XRECORD\n"
"  5\n"
"53\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"52\n"
"102\n"
"}\n"
"330\n"
"52\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"1F\n"
"  0\n"
"XRECORD\n"
"  5\n"
"51\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"50\n"
"102\n"
"}\n"
"330\n"
"50\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"1B\n"
"  0\n"
"MLINESTYLE\n"
"  5\n"
"18\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"17\n"
"102\n"
"}\n"
"330\n"
"17\n"
"100\n"
"AcDbMlineStyle\n"
"  2\n"
"STANDARD\n"
" 70\n"
"     0\n"
"  3\n"
"\n"
" 62\n"
"   256\n"
" 51\n"
"90.0\n"
" 52\n"
"90.0\n"
" 71\n"
"     2\n"
" 49\n"
"0.5\n"
" 62\n"
"   256\n"
"  6\n"
"BYLAYER\n"
" 49\n"
"-0.5\n"
" 62\n"
"   256\n"
"  6\n"
"BYLAYER\n"
"  0\n"
"ACDBPLACEHOLDER\n"
"  5\n"
"F\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"E\n"
"102\n"
"}\n"
"330\n"
"E\n"
"100\n"
"AcDbPlaceHolder\n"
"280\n"
"     0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"39\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 90\n"
"        0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3D\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"1000\n"
"DSTYLE\n"
"1002\n"
"{\n"
"1070\n"
"   278\n"
" 70\n"
"    44\n"
"1002\n"
"}\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3A\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"  1\n"
"{705446A6-11D0-4548-8F8C-A97DCA50327D}\n"
"  0\n"
"XRECORD\n"
"  5\n"
"32\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"  1\n"
"\n"
"  0\n"
"XRECORD\n"
"  5\n"
"38\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 90\n"
"        4\n"
"  0\n"
"XRECORD\n"
"  5\n"
"34\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"1A\n"
"  0\n"
"XRECORD\n"
"  5\n"
"37\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 90\n"
"    10781\n"
"  0\n"
"XRECORD\n"
"  5\n"
"35\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"19\n"
"  0\n"
"XRECORD\n"
"  5\n"
"36\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"E\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3C\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 40\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"40\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"46\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"42\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"45\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"43\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"44\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"41\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3E\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3F\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 70\n"
"     0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"33\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"  1\n"
"\n"
"  0\n"
"XRECORD\n"
"  5\n"
"30\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 90\n"
"        1\n"
"  0\n"
"XRECORD\n"
"  5\n"
"31\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 90\n"
"       70\n"
"  0\n"
"XRECORD\n"
"  5\n"
"49\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4F\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4B\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4E\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4C\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4D\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"4A\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 10\n"
"0.0\n"
" 20\n"
"0.0\n"
" 30\n"
"0.0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"47\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"340\n"
"0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"48\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
" 70\n"
"     0\n"
"  0\n"
"XRECORD\n"
"  5\n"
"3B\n"
"102\n"
"{ACAD_REACTORS\n"
"330\n"
"2F\n"
"102\n"
"}\n"
"330\n"
"2F\n"
"100\n"
"AcDbXrecord\n"
"  1\n"
"{33328E3A-B6B8-4979-86B7-D70DEC2867C2}\n"
"  0\n"
"ENDSEC\n"
"  0\n"
"EOF\n";
