import pytest

from about_time import HumanDuration


@pytest.mark.parametrize('duration, expected', [
    (.00000000123, '1.2ns'),
    (.00000000185, '1.9ns'),
    (.000001, '1µs'),
    (.000000999996, '1µs'),
    (.00001, '10µs'),
    (.0000156, '15.6µs'),
    (.01, '10ms'),
    (.0141233333333, '14.1ms'),
    (.000999999, '1ms'),
    (.0199999, '20ms'),
    (.1099999, '110ms'),
    (.160594034, '160.6ms'),
    (.80153, '801.5ms'),
    (3.434999, '3.43s'),
    (3.435999, '3.44s'),
    (59.9, '59.9s'),
    (59.99, '59.99s'),
    (59.999, '1:00'),
    (60.0, '1:00'),
    (60.99, '1:01'),
    (68., '1:08'),
    (68.09, '1:08.1'),
    (125.825, '2:05.8'),
    (3888.395, '1:04:48'),
])
def test_duration_human(duration, expected):
    assert HumanDuration(duration) == expected


@pytest.mark.parametrize('duration, prec, expected', [
    (.00000000123, 1, '1.2ns'),
    (.00000000123, 2, '1.23ns'),
    (.00000000185, 1, '1.9ns'),
    (.00000000185, 2, '1.85ns'),
    (.000001, 1, '1.0µs'),
    (.000001, 2, '1.00µs'),
    (.000000999996, 1, '1.0µs'),
    (.000000999996, 2, '1.00µs'),
    (.00001, 1, '10.0µs'),
    (.00001, 2, '10.00µs'),
    (.0000156, 1, '15.6µs'),
    (.0000156, 2, '15.60µs'),
    (.01, 1, '10.0ms'),
    (.01, 2, '10.00ms'),
    (.0141233333333, 1, '14.1ms'),
    (.0141233333333, 2, '14.12ms'),
    (.000999999, 1, '1.0ms'),
    (.000999999, 2, '1.00ms'),
    (.0199999, 1, '20.0ms'),
    (.0199999, 2, '20.00ms'),
    (.1099999, 1, '110.0ms'),
    (.1099999, 2, '110.00ms'),
    (.160594034, 1, '160.6ms'),
    (.160594034, 2, '160.59ms'),
    (.80153, 1, '801.5ms'),
    (.80153, 2, '801.53ms'),
    (3.434999, 1, '3.4s'),
    (3.434999, 2, '3.43s'),
    (3.435999, 1, '3.4s'),
    (3.435999, 2, '3.44s'),
    (59.9, 1, '59.9s'),
    (59.9, 2, '59.90s'),
    (59.99, 1, '60.0s'),
    (59.99, 2, '59.99s'),
    (59.999, 1, '1:00.0'),
    (59.999, 2, '1:00.0'),
    (60.0, 1, '1:00.0'),
    (60.0, 2, '1:00.0'),
    (60.99, 1, '1:01.0'),
    (60.99, 2, '1:01.0'),
    (68., 1, '1:08.0'),
    (68., 2, '1:08.0'),
    (68.09, 1, '1:08.1'),
    (68.09, 2, '1:08.1'),
    (125.825, 1, '2:05.8'),
    (125.825, 2, '2:05.8'),
    (3888.395, 1, '1:04:48'),
    (3888.395, 2, '1:04:48'),
])
def test_duration_human_prec_2(duration, prec, expected):
    assert HumanDuration(duration).as_human(prec) == expected
