# Licensed under a 3-clause BSD style license - see LICENSE.rst

# "core.pyx" is auto-generated by erfa_generator.py from the template
# "core.pyx.templ". Do *not* edit "core.pyx" directly, instead edit
# "core.pyx.templ" and run erfa_generator.py from the source directory to
# update it.

"""
This module contains the Cython parts of the ERFA python wrappers.
This is separated from the python code in ``core.py`` because putting it all in
Cython results in very long compile times.  By having only the vectorized core
in Cython, the compilation time is kept short without sacrificing much (if any)
performance.

For more about the module and how to use it, see the ``core.py`` docstrings.
"""
from __future__ import absolute_import, division, print_function

import warnings

from ..utils.exceptions import AstropyUserWarning

import numpy
cimport numpy
from cpython.ref cimport PyObject

numpy.import_array()

__all__ = ['_cal2jd', '_epb', '_epb2jd', '_epj', '_epj2jd', '_jd2cal', '_jdcalf', '_ab', '_apcg', '_apcg13', '_apci', '_apci13', '_apco', '_apco13', '_apcs', '_apcs13', '_aper', '_aper13', '_apio', '_apio13', '_atci13', '_atciq', '_atciqn', '_atciqz', '_atco13', '_atic13', '_aticq', '_aticqn', '_atio13', '_atioq', '_atoc13', '_atoi13', '_atoiq', '_ld', '_ldn', '_ldsun', '_pmpx', '_pmsafe', '_refco', '_epv00', '_plan94', '_fad03', '_fae03', '_faf03', '_faju03', '_fal03', '_falp03', '_fama03', '_fame03', '_fane03', '_faom03', '_fapa03', '_fasa03', '_faur03', '_fave03', '_bi00', '_bp00', '_bp06', '_bpn2xy', '_c2i00a', '_c2i00b', '_c2i06a', '_c2ibpn', '_c2ixy', '_c2ixys', '_c2t00a', '_c2t00b', '_c2t06a', '_c2tcio', '_c2teqx', '_c2tpe', '_c2txy', '_eo06a', '_eors', '_fw2m', '_fw2xy', '_num00a', '_num00b', '_num06a', '_numat', '_nut00a', '_nut00b', '_nut06a', '_nut80', '_nutm80', '_obl06', '_obl80', '_p06e', '_pb06', '_pfw06', '_pmat00', '_pmat06', '_pmat76', '_pn00', '_pn00a', '_pn00b', '_pn06', '_pn06a', '_pnm00a', '_pnm00b', '_pnm06a', '_pnm80', '_pom00', '_pr00', '_prec76', '_s00', '_s00a', '_s00b', '_s06', '_s06a', '_sp00', '_xy06', '_xys00a', '_xys00b', '_xys06a', '_ee00', '_ee00a', '_ee00b', '_ee06a', '_eect00', '_eqeq94', '_era00', '_gmst00', '_gmst06', '_gmst82', '_gst00a', '_gst00b', '_gst06', '_gst06a', '_gst94', '_pmsafe', '_pvstar', '_starpv', '_fk52h', '_fk5hip', '_fk5hz', '_h2fk5', '_hfk5z', '_starpm', '_eform', '_gc2gd', '_gc2gde', '_gd2gc', '_gd2gce', '_pvtob', '_d2dtf', '_dat', '_dtdb', '_dtf2d', '_taitt', '_taiut1', '_taiutc', '_tcbtdb', '_tcgtt', '_tdbtcb', '_tdbtt', '_tttai', '_tttcg', '_tttdb', '_ttut1', '_ut1tai', '_ut1tt', '_ut1utc', '_utctai', '_utcut1']

#<-----------------------------NpyIter handling------------------------------->

ctypedef void NpyIter
ctypedef int (*IterNextFunc)(NpyIter * iter) nogil

cdef extern from "numpy/arrayobject.h":
    IterNextFunc GetIterNext "NpyIter_GetIterNext" (NpyIter *iter, char **)
    char** GetDataPtrArray "NpyIter_GetDataPtrArray" (NpyIter* iter)

ctypedef struct NewNpyArrayIterObject:
    PyObject base
    NpyIter *iter

cdef inline NpyIter* GetNpyIter(object iter):
    return (<NewNpyArrayIterObject*>iter).iter


#<--------------------------Actual ERFA-wrapping code------------------------->

cdef extern from "erfam.h":
    struct eraASTROM:
        pass
    struct eraLDBODY:
        pass

cdef extern from "erfa.h":
    int eraCal2jd(int, int, int, double *, double *)
    double eraEpb(double, double)
    void eraEpb2jd(double, double *, double *)
    double eraEpj(double, double)
    void eraEpj2jd(double, double *, double *)
    int eraJd2cal(double, double, int *, int *, int *, double *)
    int eraJdcalf(int, double, double, int *)
    void eraAb(double *, double *, double, double, double *)
    void eraApcg(double, double, double *, double *, eraASTROM *)
    void eraApcg13(double, double, eraASTROM *)
    void eraApci(double, double, double *, double *, double, double, double, eraASTROM *)
    void eraApci13(double, double, eraASTROM *, double *)
    void eraApco(double, double, double *, double *, double, double, double, double, double, double, double, double, double, double, double, double, eraASTROM *)
    int eraApco13(double, double, double, double, double, double, double, double, double, double, double, double, eraASTROM *, double *)
    void eraApcs(double, double, double *, double *, double *, eraASTROM *)
    void eraApcs13(double, double, double *, eraASTROM *)
    void eraAper(double, eraASTROM *)
    void eraAper13(double, double, eraASTROM *)
    void eraApio(double, double, double, double, double, double, double, double, double, eraASTROM *)
    int eraApio13(double, double, double, double, double, double, double, double, double, double, double, double, eraASTROM *)
    void eraAtci13(double, double, double, double, double, double, double, double, double *, double *, double *)
    void eraAtciq(double, double, double, double, double, double, eraASTROM *, double *, double *)
    void eraAtciqn(double, double, double, double, double, double, eraASTROM *, int, eraLDBODY *, double *, double *)
    void eraAtciqz(double, double, eraASTROM *, double *, double *)
    int eraAtco13(double, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraAtic13(double, double, double, double, double *, double *, double *)
    void eraAticq(double, double, eraASTROM *, double *, double *)
    void eraAticqn(double, double, eraASTROM *, int, eraLDBODY *, double *, double *)
    int eraAtio13(double, double, double, double, double, double, double, double, double, double, double, double, double, double, double *, double *, double *, double *, double *)
    void eraAtioq(double, double, eraASTROM *, double *, double *, double *, double *, double *)
    int eraAtoc13(const char *, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double *, double *)
    int eraAtoi13(const char *, double, double, double, double, double, double, double, double, double, double, double, double, double, double, double *, double *)
    void eraAtoiq(const char *, double, double, eraASTROM *, double *, double *)
    void eraLd(double, double *, double *, double *, double, double, double *)
    void eraLdn(int, eraLDBODY *, double *, double *, double *)
    void eraLdsun(double *, double *, double, double *)
    void eraPmpx(double, double, double, double, double, double, double, double *, double *)
    int eraPmsafe(double, double, double, double, double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraRefco(double, double, double, double, double *, double *)
    int eraEpv00(double, double, double *, double *)
    int eraPlan94(double, double, int, double *)
    double eraFad03(double)
    double eraFae03(double)
    double eraFaf03(double)
    double eraFaju03(double)
    double eraFal03(double)
    double eraFalp03(double)
    double eraFama03(double)
    double eraFame03(double)
    double eraFane03(double)
    double eraFaom03(double)
    double eraFapa03(double)
    double eraFasa03(double)
    double eraFaur03(double)
    double eraFave03(double)
    void eraBi00(double *, double *, double *)
    void eraBp00(double, double, double *, double *, double *)
    void eraBp06(double, double, double *, double *, double *)
    void eraBpn2xy(double *, double *, double *)
    void eraC2i00a(double, double, double *)
    void eraC2i00b(double, double, double *)
    void eraC2i06a(double, double, double *)
    void eraC2ibpn(double, double, double *, double *)
    void eraC2ixy(double, double, double, double, double *)
    void eraC2ixys(double, double, double, double *)
    void eraC2t00a(double, double, double, double, double, double, double *)
    void eraC2t00b(double, double, double, double, double, double, double *)
    void eraC2t06a(double, double, double, double, double, double, double *)
    void eraC2tcio(double *, double, double *, double *)
    void eraC2teqx(double *, double, double *, double *)
    void eraC2tpe(double, double, double, double, double, double, double, double, double *)
    void eraC2txy(double, double, double, double, double, double, double, double, double *)
    double eraEo06a(double, double)
    double eraEors(double *, double)
    void eraFw2m(double, double, double, double, double *)
    void eraFw2xy(double, double, double, double, double *, double *)
    void eraNum00a(double, double, double *)
    void eraNum00b(double, double, double *)
    void eraNum06a(double, double, double *)
    void eraNumat(double, double, double, double *)
    void eraNut00a(double, double, double *, double *)
    void eraNut00b(double, double, double *, double *)
    void eraNut06a(double, double, double *, double *)
    void eraNut80(double, double, double *, double *)
    void eraNutm80(double, double, double *)
    double eraObl06(double, double)
    double eraObl80(double, double)
    void eraP06e(double, double, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *, double *)
    void eraPb06(double, double, double *, double *, double *)
    void eraPfw06(double, double, double *, double *, double *, double *)
    void eraPmat00(double, double, double *)
    void eraPmat06(double, double, double *)
    void eraPmat76(double, double, double *)
    void eraPn00(double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraPn00a(double, double, double *, double *, double *, double *, double *, double *, double *, double *)
    void eraPn00b(double, double, double *, double *, double *, double *, double *, double *, double *, double *)
    void eraPn06(double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraPn06a(double, double, double *, double *, double *, double *, double *, double *, double *, double *)
    void eraPnm00a(double, double, double *)
    void eraPnm00b(double, double, double *)
    void eraPnm06a(double, double, double *)
    void eraPnm80(double, double, double *)
    void eraPom00(double, double, double, double *)
    void eraPr00(double, double, double *, double *)
    void eraPrec76(double, double, double, double, double *, double *, double *)
    double eraS00(double, double, double, double)
    double eraS00a(double, double)
    double eraS00b(double, double)
    double eraS06(double, double, double, double)
    double eraS06a(double, double)
    double eraSp00(double, double)
    void eraXy06(double, double, double *, double *)
    void eraXys00a(double, double, double *, double *, double *)
    void eraXys00b(double, double, double *, double *, double *)
    void eraXys06a(double, double, double *, double *, double *)
    double eraEe00(double, double, double, double)
    double eraEe00a(double, double)
    double eraEe00b(double, double)
    double eraEe06a(double, double)
    double eraEect00(double, double)
    double eraEqeq94(double, double)
    double eraEra00(double, double)
    double eraGmst00(double, double, double, double)
    double eraGmst06(double, double, double, double)
    double eraGmst82(double, double)
    double eraGst00a(double, double, double, double)
    double eraGst00b(double, double)
    double eraGst06(double, double, double, double, double *)
    double eraGst06a(double, double, double, double)
    double eraGst94(double, double)
    int eraPmsafe(double, double, double, double, double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    int eraPvstar(double *, double *, double *, double *, double *, double *, double *)
    int eraStarpv(double, double, double, double, double, double, double *)
    void eraFk52h(double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraFk5hip(double *, double *)
    void eraFk5hz(double, double, double, double, double *, double *)
    void eraH2fk5(double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    void eraHfk5z(double, double, double, double, double *, double *, double *, double *)
    int eraStarpm(double, double, double, double, double, double, double, double, double, double, double *, double *, double *, double *, double *, double *)
    int eraEform(int, double *, double *)
    int eraGc2gd(int, double *, double *, double *, double *)
    int eraGc2gde(double, double, double *, double *, double *, double *)
    int eraGd2gc(int, double, double, double, double *)
    int eraGd2gce(double, double, double, double, double, double *)
    void eraPvtob(double, double, double, double, double, double, double, double *)
    int eraD2dtf(const char *, int, double, double, int *, int *, int *, int *)
    int eraDat(int, int, int, double, double *)
    double eraDtdb(double, double, double, double, double, double)
    int eraDtf2d(const char *, int, int, int, int, int, double, double *, double *)
    int eraTaitt(double, double, double *, double *)
    int eraTaiut1(double, double, double, double *, double *)
    int eraTaiutc(double, double, double *, double *)
    int eraTcbtdb(double, double, double *, double *)
    int eraTcgtt(double, double, double *, double *)
    int eraTdbtcb(double, double, double *, double *)
    int eraTdbtt(double, double, double, double *, double *)
    int eraTttai(double, double, double *, double *)
    int eraTttcg(double, double, double *, double *)
    int eraTttdb(double, double, double, double *, double *)
    int eraTtut1(double, double, double, double *, double *)
    int eraUt1tai(double, double, double, double *, double *)
    int eraUt1tt(double, double, double, double *, double *)
    int eraUt1utc(double, double, double, double *, double *)
    int eraUtctai(double, double, double *, double *)
    int eraUtcut1(double, double, double, double *, double *)


def _cal2jd(it):
    #Iterate
    cdef int _iy
    cdef int _im
    cdef int _id
    cdef double * _djm0
    cdef double * _djm
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _iy = (<int *>(dataptrarray[0]))[0]
        _im = (<int *>(dataptrarray[1]))[0]
        _id = (<int *>(dataptrarray[2]))[0]
        _djm0 = (<double *>(dataptrarray[3]))
        _djm = (<double *>(dataptrarray[4]))
        _c_retval = eraCal2jd(_iy, _im, _id, _djm0, _djm)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _epb(it):
    #Iterate
    cdef double _dj1
    cdef double _dj2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dj1 = (<double *>(dataptrarray[0]))[0]
        _dj2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEpb(_dj1, _dj2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _epb2jd(it):
    #Iterate
    cdef double _epb
    cdef double * _djm0
    cdef double * _djm
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _epb = (<double *>(dataptrarray[0]))[0]
        _djm0 = (<double *>(dataptrarray[1]))
        _djm = (<double *>(dataptrarray[2]))
        eraEpb2jd(_epb, _djm0, _djm)
        status = iternext(GetNpyIter(it))


def _epj(it):
    #Iterate
    cdef double _dj1
    cdef double _dj2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dj1 = (<double *>(dataptrarray[0]))[0]
        _dj2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEpj(_dj1, _dj2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _epj2jd(it):
    #Iterate
    cdef double _epj
    cdef double * _djm0
    cdef double * _djm
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _epj = (<double *>(dataptrarray[0]))[0]
        _djm0 = (<double *>(dataptrarray[1]))
        _djm = (<double *>(dataptrarray[2]))
        eraEpj2jd(_epj, _djm0, _djm)
        status = iternext(GetNpyIter(it))


def _jd2cal(it):
    #Iterate
    cdef double _dj1
    cdef double _dj2
    cdef int * _iy
    cdef int * _im
    cdef int * _id
    cdef double * _fd
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dj1 = (<double *>(dataptrarray[0]))[0]
        _dj2 = (<double *>(dataptrarray[1]))[0]
        _iy = (<int *>(dataptrarray[2]))
        _im = (<int *>(dataptrarray[3]))
        _id = (<int *>(dataptrarray[4]))
        _fd = (<double *>(dataptrarray[5]))
        _c_retval = eraJd2cal(_dj1, _dj2, _iy, _im, _id, _fd)
        (<int *>(dataptrarray[6]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _jdcalf(it):
    #Iterate
    cdef int _ndp
    cdef double _dj1
    cdef double _dj2
    cdef int * _iymdf
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ndp = (<int *>(dataptrarray[0]))[0]
        _dj1 = (<double *>(dataptrarray[1]))[0]
        _dj2 = (<double *>(dataptrarray[2]))[0]
        _iymdf = (<int *>(dataptrarray[3]))
        _c_retval = eraJdcalf(_ndp, _dj1, _dj2, _iymdf)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _ab(it):
    #Iterate
    cdef double * _pnat
    cdef double * _v
    cdef double _s
    cdef double _bm1
    cdef double * _ppr
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _pnat = (<double *>(dataptrarray[0]))
        _v = (<double *>(dataptrarray[1]))
        _s = (<double *>(dataptrarray[2]))[0]
        _bm1 = (<double *>(dataptrarray[3]))[0]
        _ppr = (<double *>(dataptrarray[4]))
        eraAb(_pnat, _v, _s, _bm1, _ppr)
        status = iternext(GetNpyIter(it))


def _apcg(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _ebpv
    cdef double * _ehp
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _ebpv = (<double *>(dataptrarray[2]))
        _ehp = (<double *>(dataptrarray[3]))
        _astrom = (<eraASTROM *>(dataptrarray[4]))
        eraApcg(_date1, _date2, _ebpv, _ehp, _astrom)
        status = iternext(GetNpyIter(it))


def _apcg13(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        eraApcg13(_date1, _date2, _astrom)
        status = iternext(GetNpyIter(it))


def _apci(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _ebpv
    cdef double * _ehp
    cdef double _x
    cdef double _y
    cdef double _s
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _ebpv = (<double *>(dataptrarray[2]))
        _ehp = (<double *>(dataptrarray[3]))
        _x = (<double *>(dataptrarray[4]))[0]
        _y = (<double *>(dataptrarray[5]))[0]
        _s = (<double *>(dataptrarray[6]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[7]))
        eraApci(_date1, _date2, _ebpv, _ehp, _x, _y, _s, _astrom)
        status = iternext(GetNpyIter(it))


def _apci13(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef eraASTROM * _astrom
    cdef double * _eo
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        _eo = (<double *>(dataptrarray[3]))
        eraApci13(_date1, _date2, _astrom, _eo)
        status = iternext(GetNpyIter(it))


def _apco(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _ebpv
    cdef double * _ehp
    cdef double _x
    cdef double _y
    cdef double _s
    cdef double _theta
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _sp
    cdef double _refa
    cdef double _refb
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _ebpv = (<double *>(dataptrarray[2]))
        _ehp = (<double *>(dataptrarray[3]))
        _x = (<double *>(dataptrarray[4]))[0]
        _y = (<double *>(dataptrarray[5]))[0]
        _s = (<double *>(dataptrarray[6]))[0]
        _theta = (<double *>(dataptrarray[7]))[0]
        _elong = (<double *>(dataptrarray[8]))[0]
        _phi = (<double *>(dataptrarray[9]))[0]
        _hm = (<double *>(dataptrarray[10]))[0]
        _xp = (<double *>(dataptrarray[11]))[0]
        _yp = (<double *>(dataptrarray[12]))[0]
        _sp = (<double *>(dataptrarray[13]))[0]
        _refa = (<double *>(dataptrarray[14]))[0]
        _refb = (<double *>(dataptrarray[15]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[16]))
        eraApco(_date1, _date2, _ebpv, _ehp, _x, _y, _s, _theta, _elong, _phi, _hm, _xp, _yp, _sp, _refa, _refb, _astrom)
        status = iternext(GetNpyIter(it))


def _apco13(it):
    #Iterate
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef eraASTROM * _astrom
    cdef double * _eo
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _utc1 = (<double *>(dataptrarray[0]))[0]
        _utc2 = (<double *>(dataptrarray[1]))[0]
        _dut1 = (<double *>(dataptrarray[2]))[0]
        _elong = (<double *>(dataptrarray[3]))[0]
        _phi = (<double *>(dataptrarray[4]))[0]
        _hm = (<double *>(dataptrarray[5]))[0]
        _xp = (<double *>(dataptrarray[6]))[0]
        _yp = (<double *>(dataptrarray[7]))[0]
        _phpa = (<double *>(dataptrarray[8]))[0]
        _tc = (<double *>(dataptrarray[9]))[0]
        _rh = (<double *>(dataptrarray[10]))[0]
        _wl = (<double *>(dataptrarray[11]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[12]))
        _eo = (<double *>(dataptrarray[13]))
        _c_retval = eraApco13(_utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _astrom, _eo)
        (<int *>(dataptrarray[14]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _apcs(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _pv
    cdef double * _ebpv
    cdef double * _ehp
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _pv = (<double *>(dataptrarray[2]))
        _ebpv = (<double *>(dataptrarray[3]))
        _ehp = (<double *>(dataptrarray[4]))
        _astrom = (<eraASTROM *>(dataptrarray[5]))
        eraApcs(_date1, _date2, _pv, _ebpv, _ehp, _astrom)
        status = iternext(GetNpyIter(it))


def _apcs13(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _pv
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _pv = (<double *>(dataptrarray[2]))
        _astrom = (<eraASTROM *>(dataptrarray[3]))
        eraApcs13(_date1, _date2, _pv, _astrom)
        status = iternext(GetNpyIter(it))


def _aper(it):
    #Iterate
    cdef double _theta
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _theta = (<double *>(dataptrarray[0]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[1]))
        eraAper(_theta, _astrom)
        status = iternext(GetNpyIter(it))


def _aper13(it):
    #Iterate
    cdef double _ut11
    cdef double _ut12
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ut11 = (<double *>(dataptrarray[0]))[0]
        _ut12 = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        eraAper13(_ut11, _ut12, _astrom)
        status = iternext(GetNpyIter(it))


def _apio(it):
    #Iterate
    cdef double _sp
    cdef double _theta
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _refa
    cdef double _refb
    cdef eraASTROM * _astrom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _sp = (<double *>(dataptrarray[0]))[0]
        _theta = (<double *>(dataptrarray[1]))[0]
        _elong = (<double *>(dataptrarray[2]))[0]
        _phi = (<double *>(dataptrarray[3]))[0]
        _hm = (<double *>(dataptrarray[4]))[0]
        _xp = (<double *>(dataptrarray[5]))[0]
        _yp = (<double *>(dataptrarray[6]))[0]
        _refa = (<double *>(dataptrarray[7]))[0]
        _refb = (<double *>(dataptrarray[8]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[9]))
        eraApio(_sp, _theta, _elong, _phi, _hm, _xp, _yp, _refa, _refb, _astrom)
        status = iternext(GetNpyIter(it))


def _apio13(it):
    #Iterate
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef eraASTROM * _astrom
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _utc1 = (<double *>(dataptrarray[0]))[0]
        _utc2 = (<double *>(dataptrarray[1]))[0]
        _dut1 = (<double *>(dataptrarray[2]))[0]
        _elong = (<double *>(dataptrarray[3]))[0]
        _phi = (<double *>(dataptrarray[4]))[0]
        _hm = (<double *>(dataptrarray[5]))[0]
        _xp = (<double *>(dataptrarray[6]))[0]
        _yp = (<double *>(dataptrarray[7]))[0]
        _phpa = (<double *>(dataptrarray[8]))[0]
        _tc = (<double *>(dataptrarray[9]))[0]
        _rh = (<double *>(dataptrarray[10]))[0]
        _wl = (<double *>(dataptrarray[11]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[12]))
        _c_retval = eraApio13(_utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _astrom)
        (<int *>(dataptrarray[13]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _atci13(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef double _pr
    cdef double _pd
    cdef double _px
    cdef double _rv
    cdef double _date1
    cdef double _date2
    cdef double * _ri
    cdef double * _di
    cdef double * _eo
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _pr = (<double *>(dataptrarray[2]))[0]
        _pd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _date1 = (<double *>(dataptrarray[6]))[0]
        _date2 = (<double *>(dataptrarray[7]))[0]
        _ri = (<double *>(dataptrarray[8]))
        _di = (<double *>(dataptrarray[9]))
        _eo = (<double *>(dataptrarray[10]))
        eraAtci13(_rc, _dc, _pr, _pd, _px, _rv, _date1, _date2, _ri, _di, _eo)
        status = iternext(GetNpyIter(it))


def _atciq(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef double _pr
    cdef double _pd
    cdef double _px
    cdef double _rv
    cdef eraASTROM * _astrom
    cdef double * _ri
    cdef double * _di
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _pr = (<double *>(dataptrarray[2]))[0]
        _pd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[6]))
        _ri = (<double *>(dataptrarray[7]))
        _di = (<double *>(dataptrarray[8]))
        eraAtciq(_rc, _dc, _pr, _pd, _px, _rv, _astrom, _ri, _di)
        status = iternext(GetNpyIter(it))


def _atciqn(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef double _pr
    cdef double _pd
    cdef double _px
    cdef double _rv
    cdef eraASTROM * _astrom
    cdef int _n
    cdef eraLDBODY * _b
    cdef double * _ri
    cdef double * _di
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _pr = (<double *>(dataptrarray[2]))[0]
        _pd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[6]))
        _n = (<int *>(dataptrarray[7]))[0]
        _b = (<eraLDBODY *>(dataptrarray[8]))
        _ri = (<double *>(dataptrarray[9]))
        _di = (<double *>(dataptrarray[10]))
        eraAtciqn(_rc, _dc, _pr, _pd, _px, _rv, _astrom, _n, _b, _ri, _di)
        status = iternext(GetNpyIter(it))


def _atciqz(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef eraASTROM * _astrom
    cdef double * _ri
    cdef double * _di
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        _ri = (<double *>(dataptrarray[3]))
        _di = (<double *>(dataptrarray[4]))
        eraAtciqz(_rc, _dc, _astrom, _ri, _di)
        status = iternext(GetNpyIter(it))


def _atco13(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef double _pr
    cdef double _pd
    cdef double _px
    cdef double _rv
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef double * _aob
    cdef double * _zob
    cdef double * _hob
    cdef double * _dob
    cdef double * _rob
    cdef double * _eo
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _pr = (<double *>(dataptrarray[2]))[0]
        _pd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _utc1 = (<double *>(dataptrarray[6]))[0]
        _utc2 = (<double *>(dataptrarray[7]))[0]
        _dut1 = (<double *>(dataptrarray[8]))[0]
        _elong = (<double *>(dataptrarray[9]))[0]
        _phi = (<double *>(dataptrarray[10]))[0]
        _hm = (<double *>(dataptrarray[11]))[0]
        _xp = (<double *>(dataptrarray[12]))[0]
        _yp = (<double *>(dataptrarray[13]))[0]
        _phpa = (<double *>(dataptrarray[14]))[0]
        _tc = (<double *>(dataptrarray[15]))[0]
        _rh = (<double *>(dataptrarray[16]))[0]
        _wl = (<double *>(dataptrarray[17]))[0]
        _aob = (<double *>(dataptrarray[18]))
        _zob = (<double *>(dataptrarray[19]))
        _hob = (<double *>(dataptrarray[20]))
        _dob = (<double *>(dataptrarray[21]))
        _rob = (<double *>(dataptrarray[22]))
        _eo = (<double *>(dataptrarray[23]))
        _c_retval = eraAtco13(_rc, _dc, _pr, _pd, _px, _rv, _utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _aob, _zob, _hob, _dob, _rob, _eo)
        (<int *>(dataptrarray[24]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _atic13(it):
    #Iterate
    cdef double _ri
    cdef double _di
    cdef double _date1
    cdef double _date2
    cdef double * _rc
    cdef double * _dc
    cdef double * _eo
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ri = (<double *>(dataptrarray[0]))[0]
        _di = (<double *>(dataptrarray[1]))[0]
        _date1 = (<double *>(dataptrarray[2]))[0]
        _date2 = (<double *>(dataptrarray[3]))[0]
        _rc = (<double *>(dataptrarray[4]))
        _dc = (<double *>(dataptrarray[5]))
        _eo = (<double *>(dataptrarray[6]))
        eraAtic13(_ri, _di, _date1, _date2, _rc, _dc, _eo)
        status = iternext(GetNpyIter(it))


def _aticq(it):
    #Iterate
    cdef double _ri
    cdef double _di
    cdef eraASTROM * _astrom
    cdef double * _rc
    cdef double * _dc
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ri = (<double *>(dataptrarray[0]))[0]
        _di = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        _rc = (<double *>(dataptrarray[3]))
        _dc = (<double *>(dataptrarray[4]))
        eraAticq(_ri, _di, _astrom, _rc, _dc)
        status = iternext(GetNpyIter(it))


def _aticqn(it):
    #Iterate
    cdef double _ri
    cdef double _di
    cdef eraASTROM * _astrom
    cdef int _n
    cdef eraLDBODY * _b
    cdef double * _rc
    cdef double * _dc
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ri = (<double *>(dataptrarray[0]))[0]
        _di = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        _n = (<int *>(dataptrarray[3]))[0]
        _b = (<eraLDBODY *>(dataptrarray[4]))
        _rc = (<double *>(dataptrarray[5]))
        _dc = (<double *>(dataptrarray[6]))
        eraAticqn(_ri, _di, _astrom, _n, _b, _rc, _dc)
        status = iternext(GetNpyIter(it))


def _atio13(it):
    #Iterate
    cdef double _ri
    cdef double _di
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef double * _aob
    cdef double * _zob
    cdef double * _hob
    cdef double * _dob
    cdef double * _rob
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ri = (<double *>(dataptrarray[0]))[0]
        _di = (<double *>(dataptrarray[1]))[0]
        _utc1 = (<double *>(dataptrarray[2]))[0]
        _utc2 = (<double *>(dataptrarray[3]))[0]
        _dut1 = (<double *>(dataptrarray[4]))[0]
        _elong = (<double *>(dataptrarray[5]))[0]
        _phi = (<double *>(dataptrarray[6]))[0]
        _hm = (<double *>(dataptrarray[7]))[0]
        _xp = (<double *>(dataptrarray[8]))[0]
        _yp = (<double *>(dataptrarray[9]))[0]
        _phpa = (<double *>(dataptrarray[10]))[0]
        _tc = (<double *>(dataptrarray[11]))[0]
        _rh = (<double *>(dataptrarray[12]))[0]
        _wl = (<double *>(dataptrarray[13]))[0]
        _aob = (<double *>(dataptrarray[14]))
        _zob = (<double *>(dataptrarray[15]))
        _hob = (<double *>(dataptrarray[16]))
        _dob = (<double *>(dataptrarray[17]))
        _rob = (<double *>(dataptrarray[18]))
        _c_retval = eraAtio13(_ri, _di, _utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _aob, _zob, _hob, _dob, _rob)
        (<int *>(dataptrarray[19]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _atioq(it):
    #Iterate
    cdef double _ri
    cdef double _di
    cdef eraASTROM * _astrom
    cdef double * _aob
    cdef double * _zob
    cdef double * _hob
    cdef double * _dob
    cdef double * _rob
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ri = (<double *>(dataptrarray[0]))[0]
        _di = (<double *>(dataptrarray[1]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[2]))
        _aob = (<double *>(dataptrarray[3]))
        _zob = (<double *>(dataptrarray[4]))
        _hob = (<double *>(dataptrarray[5]))
        _dob = (<double *>(dataptrarray[6]))
        _rob = (<double *>(dataptrarray[7]))
        eraAtioq(_ri, _di, _astrom, _aob, _zob, _hob, _dob, _rob)
        status = iternext(GetNpyIter(it))


def _atoc13(it):
    #Iterate
    cdef const char * _type
    cdef double _ob1
    cdef double _ob2
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef double * _rc
    cdef double * _dc
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _type = (<const char *>(dataptrarray[0]))
        _ob1 = (<double *>(dataptrarray[1]))[0]
        _ob2 = (<double *>(dataptrarray[2]))[0]
        _utc1 = (<double *>(dataptrarray[3]))[0]
        _utc2 = (<double *>(dataptrarray[4]))[0]
        _dut1 = (<double *>(dataptrarray[5]))[0]
        _elong = (<double *>(dataptrarray[6]))[0]
        _phi = (<double *>(dataptrarray[7]))[0]
        _hm = (<double *>(dataptrarray[8]))[0]
        _xp = (<double *>(dataptrarray[9]))[0]
        _yp = (<double *>(dataptrarray[10]))[0]
        _phpa = (<double *>(dataptrarray[11]))[0]
        _tc = (<double *>(dataptrarray[12]))[0]
        _rh = (<double *>(dataptrarray[13]))[0]
        _wl = (<double *>(dataptrarray[14]))[0]
        _rc = (<double *>(dataptrarray[15]))
        _dc = (<double *>(dataptrarray[16]))
        _c_retval = eraAtoc13(_type, _ob1, _ob2, _utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _rc, _dc)
        (<int *>(dataptrarray[17]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _atoi13(it):
    #Iterate
    cdef const char * _type
    cdef double _ob1
    cdef double _ob2
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef double * _ri
    cdef double * _di
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _type = (<const char *>(dataptrarray[0]))
        _ob1 = (<double *>(dataptrarray[1]))[0]
        _ob2 = (<double *>(dataptrarray[2]))[0]
        _utc1 = (<double *>(dataptrarray[3]))[0]
        _utc2 = (<double *>(dataptrarray[4]))[0]
        _dut1 = (<double *>(dataptrarray[5]))[0]
        _elong = (<double *>(dataptrarray[6]))[0]
        _phi = (<double *>(dataptrarray[7]))[0]
        _hm = (<double *>(dataptrarray[8]))[0]
        _xp = (<double *>(dataptrarray[9]))[0]
        _yp = (<double *>(dataptrarray[10]))[0]
        _phpa = (<double *>(dataptrarray[11]))[0]
        _tc = (<double *>(dataptrarray[12]))[0]
        _rh = (<double *>(dataptrarray[13]))[0]
        _wl = (<double *>(dataptrarray[14]))[0]
        _ri = (<double *>(dataptrarray[15]))
        _di = (<double *>(dataptrarray[16]))
        _c_retval = eraAtoi13(_type, _ob1, _ob2, _utc1, _utc2, _dut1, _elong, _phi, _hm, _xp, _yp, _phpa, _tc, _rh, _wl, _ri, _di)
        (<int *>(dataptrarray[17]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _atoiq(it):
    #Iterate
    cdef const char * _type
    cdef double _ob1
    cdef double _ob2
    cdef eraASTROM * _astrom
    cdef double * _ri
    cdef double * _di
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _type = (<const char *>(dataptrarray[0]))
        _ob1 = (<double *>(dataptrarray[1]))[0]
        _ob2 = (<double *>(dataptrarray[2]))[0]
        _astrom = (<eraASTROM *>(dataptrarray[3]))
        _ri = (<double *>(dataptrarray[4]))
        _di = (<double *>(dataptrarray[5]))
        eraAtoiq(_type, _ob1, _ob2, _astrom, _ri, _di)
        status = iternext(GetNpyIter(it))


def _ld(it):
    #Iterate
    cdef double _bm
    cdef double * _p
    cdef double * _q
    cdef double * _e
    cdef double _em
    cdef double _dlim
    cdef double * _p1
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _bm = (<double *>(dataptrarray[0]))[0]
        _p = (<double *>(dataptrarray[1]))
        _q = (<double *>(dataptrarray[2]))
        _e = (<double *>(dataptrarray[3]))
        _em = (<double *>(dataptrarray[4]))[0]
        _dlim = (<double *>(dataptrarray[5]))[0]
        _p1 = (<double *>(dataptrarray[6]))
        eraLd(_bm, _p, _q, _e, _em, _dlim, _p1)
        status = iternext(GetNpyIter(it))


def _ldn(it):
    #Iterate
    cdef int _n
    cdef eraLDBODY * _b
    cdef double * _ob
    cdef double * _sc
    cdef double * _sn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _n = (<int *>(dataptrarray[0]))[0]
        _b = (<eraLDBODY *>(dataptrarray[1]))
        _ob = (<double *>(dataptrarray[2]))
        _sc = (<double *>(dataptrarray[3]))
        _sn = (<double *>(dataptrarray[4]))
        eraLdn(_n, _b, _ob, _sc, _sn)
        status = iternext(GetNpyIter(it))


def _ldsun(it):
    #Iterate
    cdef double * _p
    cdef double * _e
    cdef double _em
    cdef double * _p1
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _p = (<double *>(dataptrarray[0]))
        _e = (<double *>(dataptrarray[1]))
        _em = (<double *>(dataptrarray[2]))[0]
        _p1 = (<double *>(dataptrarray[3]))
        eraLdsun(_p, _e, _em, _p1)
        status = iternext(GetNpyIter(it))


def _pmpx(it):
    #Iterate
    cdef double _rc
    cdef double _dc
    cdef double _pr
    cdef double _pd
    cdef double _px
    cdef double _rv
    cdef double _pmt
    cdef double * _pob
    cdef double * _pco
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc = (<double *>(dataptrarray[0]))[0]
        _dc = (<double *>(dataptrarray[1]))[0]
        _pr = (<double *>(dataptrarray[2]))[0]
        _pd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _pmt = (<double *>(dataptrarray[6]))[0]
        _pob = (<double *>(dataptrarray[7]))
        _pco = (<double *>(dataptrarray[8]))
        eraPmpx(_rc, _dc, _pr, _pd, _px, _rv, _pmt, _pob, _pco)
        status = iternext(GetNpyIter(it))


def _pmsafe(it):
    #Iterate
    cdef double _ra1
    cdef double _dec1
    cdef double _pmr1
    cdef double _pmd1
    cdef double _px1
    cdef double _rv1
    cdef double _ep1a
    cdef double _ep1b
    cdef double _ep2a
    cdef double _ep2b
    cdef double * _ra2
    cdef double * _dec2
    cdef double * _pmr2
    cdef double * _pmd2
    cdef double * _px2
    cdef double * _rv2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ra1 = (<double *>(dataptrarray[0]))[0]
        _dec1 = (<double *>(dataptrarray[1]))[0]
        _pmr1 = (<double *>(dataptrarray[2]))[0]
        _pmd1 = (<double *>(dataptrarray[3]))[0]
        _px1 = (<double *>(dataptrarray[4]))[0]
        _rv1 = (<double *>(dataptrarray[5]))[0]
        _ep1a = (<double *>(dataptrarray[6]))[0]
        _ep1b = (<double *>(dataptrarray[7]))[0]
        _ep2a = (<double *>(dataptrarray[8]))[0]
        _ep2b = (<double *>(dataptrarray[9]))[0]
        _ra2 = (<double *>(dataptrarray[10]))
        _dec2 = (<double *>(dataptrarray[11]))
        _pmr2 = (<double *>(dataptrarray[12]))
        _pmd2 = (<double *>(dataptrarray[13]))
        _px2 = (<double *>(dataptrarray[14]))
        _rv2 = (<double *>(dataptrarray[15]))
        _c_retval = eraPmsafe(_ra1, _dec1, _pmr1, _pmd1, _px1, _rv1, _ep1a, _ep1b, _ep2a, _ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2)
        (<int *>(dataptrarray[16]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _refco(it):
    #Iterate
    cdef double _phpa
    cdef double _tc
    cdef double _rh
    cdef double _wl
    cdef double * _refa
    cdef double * _refb
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _phpa = (<double *>(dataptrarray[0]))[0]
        _tc = (<double *>(dataptrarray[1]))[0]
        _rh = (<double *>(dataptrarray[2]))[0]
        _wl = (<double *>(dataptrarray[3]))[0]
        _refa = (<double *>(dataptrarray[4]))
        _refb = (<double *>(dataptrarray[5]))
        eraRefco(_phpa, _tc, _rh, _wl, _refa, _refb)
        status = iternext(GetNpyIter(it))


def _epv00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _pvh
    cdef double * _pvb
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _pvh = (<double *>(dataptrarray[2]))
        _pvb = (<double *>(dataptrarray[3]))
        _c_retval = eraEpv00(_date1, _date2, _pvh, _pvb)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _plan94(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef int _np
    cdef double * _pv
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _np = (<int *>(dataptrarray[2]))[0]
        _pv = (<double *>(dataptrarray[3]))
        _c_retval = eraPlan94(_date1, _date2, _np, _pv)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _fad03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFad03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fae03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFae03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _faf03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFaf03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _faju03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFaju03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fal03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFal03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _falp03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFalp03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fama03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFama03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fame03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFame03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fane03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFane03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _faom03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFaom03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fapa03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFapa03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fasa03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFasa03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _faur03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFaur03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fave03(it):
    #Iterate
    cdef double _t
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _t = (<double *>(dataptrarray[0]))[0]
        _c_retval = eraFave03(_t)
        (<double *>(dataptrarray[1]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _bi00(it):
    #Iterate
    cdef double * _dpsibi
    cdef double * _depsbi
    cdef double * _dra
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dpsibi = (<double *>(dataptrarray[0]))
        _depsbi = (<double *>(dataptrarray[1]))
        _dra = (<double *>(dataptrarray[2]))
        eraBi00(_dpsibi, _depsbi, _dra)
        status = iternext(GetNpyIter(it))


def _bp00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rb = (<double *>(dataptrarray[2]))
        _rp = (<double *>(dataptrarray[3]))
        _rbp = (<double *>(dataptrarray[4]))
        eraBp00(_date1, _date2, _rb, _rp, _rbp)
        status = iternext(GetNpyIter(it))


def _bp06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rb = (<double *>(dataptrarray[2]))
        _rp = (<double *>(dataptrarray[3]))
        _rbp = (<double *>(dataptrarray[4]))
        eraBp06(_date1, _date2, _rb, _rp, _rbp)
        status = iternext(GetNpyIter(it))


def _bpn2xy(it):
    #Iterate
    cdef double * _rbpn
    cdef double * _x
    cdef double * _y
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rbpn = (<double *>(dataptrarray[0]))
        _x = (<double *>(dataptrarray[1]))
        _y = (<double *>(dataptrarray[2]))
        eraBpn2xy(_rbpn, _x, _y)
        status = iternext(GetNpyIter(it))


def _c2i00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rc2i = (<double *>(dataptrarray[2]))
        eraC2i00a(_date1, _date2, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2i00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rc2i = (<double *>(dataptrarray[2]))
        eraC2i00b(_date1, _date2, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2i06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rc2i = (<double *>(dataptrarray[2]))
        eraC2i06a(_date1, _date2, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2ibpn(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rbpn
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rbpn = (<double *>(dataptrarray[2]))
        _rc2i = (<double *>(dataptrarray[3]))
        eraC2ibpn(_date1, _date2, _rbpn, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2ixy(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _x
    cdef double _y
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))[0]
        _y = (<double *>(dataptrarray[3]))[0]
        _rc2i = (<double *>(dataptrarray[4]))
        eraC2ixy(_date1, _date2, _x, _y, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2ixys(it):
    #Iterate
    cdef double _x
    cdef double _y
    cdef double _s
    cdef double * _rc2i
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _x = (<double *>(dataptrarray[0]))[0]
        _y = (<double *>(dataptrarray[1]))[0]
        _s = (<double *>(dataptrarray[2]))[0]
        _rc2i = (<double *>(dataptrarray[3]))
        eraC2ixys(_x, _y, _s, _rc2i)
        status = iternext(GetNpyIter(it))


def _c2t00a(it):
    #Iterate
    cdef double _tta
    cdef double _ttb
    cdef double _uta
    cdef double _utb
    cdef double _xp
    cdef double _yp
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tta = (<double *>(dataptrarray[0]))[0]
        _ttb = (<double *>(dataptrarray[1]))[0]
        _uta = (<double *>(dataptrarray[2]))[0]
        _utb = (<double *>(dataptrarray[3]))[0]
        _xp = (<double *>(dataptrarray[4]))[0]
        _yp = (<double *>(dataptrarray[5]))[0]
        _rc2t = (<double *>(dataptrarray[6]))
        eraC2t00a(_tta, _ttb, _uta, _utb, _xp, _yp, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2t00b(it):
    #Iterate
    cdef double _tta
    cdef double _ttb
    cdef double _uta
    cdef double _utb
    cdef double _xp
    cdef double _yp
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tta = (<double *>(dataptrarray[0]))[0]
        _ttb = (<double *>(dataptrarray[1]))[0]
        _uta = (<double *>(dataptrarray[2]))[0]
        _utb = (<double *>(dataptrarray[3]))[0]
        _xp = (<double *>(dataptrarray[4]))[0]
        _yp = (<double *>(dataptrarray[5]))[0]
        _rc2t = (<double *>(dataptrarray[6]))
        eraC2t00b(_tta, _ttb, _uta, _utb, _xp, _yp, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2t06a(it):
    #Iterate
    cdef double _tta
    cdef double _ttb
    cdef double _uta
    cdef double _utb
    cdef double _xp
    cdef double _yp
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tta = (<double *>(dataptrarray[0]))[0]
        _ttb = (<double *>(dataptrarray[1]))[0]
        _uta = (<double *>(dataptrarray[2]))[0]
        _utb = (<double *>(dataptrarray[3]))[0]
        _xp = (<double *>(dataptrarray[4]))[0]
        _yp = (<double *>(dataptrarray[5]))[0]
        _rc2t = (<double *>(dataptrarray[6]))
        eraC2t06a(_tta, _ttb, _uta, _utb, _xp, _yp, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2tcio(it):
    #Iterate
    cdef double * _rc2i
    cdef double _era
    cdef double * _rpom
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rc2i = (<double *>(dataptrarray[0]))
        _era = (<double *>(dataptrarray[1]))[0]
        _rpom = (<double *>(dataptrarray[2]))
        _rc2t = (<double *>(dataptrarray[3]))
        eraC2tcio(_rc2i, _era, _rpom, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2teqx(it):
    #Iterate
    cdef double * _rbpn
    cdef double _gst
    cdef double * _rpom
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rbpn = (<double *>(dataptrarray[0]))
        _gst = (<double *>(dataptrarray[1]))[0]
        _rpom = (<double *>(dataptrarray[2]))
        _rc2t = (<double *>(dataptrarray[3]))
        eraC2teqx(_rbpn, _gst, _rpom, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2tpe(it):
    #Iterate
    cdef double _tta
    cdef double _ttb
    cdef double _uta
    cdef double _utb
    cdef double _dpsi
    cdef double _deps
    cdef double _xp
    cdef double _yp
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tta = (<double *>(dataptrarray[0]))[0]
        _ttb = (<double *>(dataptrarray[1]))[0]
        _uta = (<double *>(dataptrarray[2]))[0]
        _utb = (<double *>(dataptrarray[3]))[0]
        _dpsi = (<double *>(dataptrarray[4]))[0]
        _deps = (<double *>(dataptrarray[5]))[0]
        _xp = (<double *>(dataptrarray[6]))[0]
        _yp = (<double *>(dataptrarray[7]))[0]
        _rc2t = (<double *>(dataptrarray[8]))
        eraC2tpe(_tta, _ttb, _uta, _utb, _dpsi, _deps, _xp, _yp, _rc2t)
        status = iternext(GetNpyIter(it))


def _c2txy(it):
    #Iterate
    cdef double _tta
    cdef double _ttb
    cdef double _uta
    cdef double _utb
    cdef double _x
    cdef double _y
    cdef double _xp
    cdef double _yp
    cdef double * _rc2t
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tta = (<double *>(dataptrarray[0]))[0]
        _ttb = (<double *>(dataptrarray[1]))[0]
        _uta = (<double *>(dataptrarray[2]))[0]
        _utb = (<double *>(dataptrarray[3]))[0]
        _x = (<double *>(dataptrarray[4]))[0]
        _y = (<double *>(dataptrarray[5]))[0]
        _xp = (<double *>(dataptrarray[6]))[0]
        _yp = (<double *>(dataptrarray[7]))[0]
        _rc2t = (<double *>(dataptrarray[8]))
        eraC2txy(_tta, _ttb, _uta, _utb, _x, _y, _xp, _yp, _rc2t)
        status = iternext(GetNpyIter(it))


def _eo06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEo06a(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _eors(it):
    #Iterate
    cdef double * _rnpb
    cdef double _s
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rnpb = (<double *>(dataptrarray[0]))
        _s = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEors(_rnpb, _s)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _fw2m(it):
    #Iterate
    cdef double _gamb
    cdef double _phib
    cdef double _psi
    cdef double _eps
    cdef double * _r
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _gamb = (<double *>(dataptrarray[0]))[0]
        _phib = (<double *>(dataptrarray[1]))[0]
        _psi = (<double *>(dataptrarray[2]))[0]
        _eps = (<double *>(dataptrarray[3]))[0]
        _r = (<double *>(dataptrarray[4]))
        eraFw2m(_gamb, _phib, _psi, _eps, _r)
        status = iternext(GetNpyIter(it))


def _fw2xy(it):
    #Iterate
    cdef double _gamb
    cdef double _phib
    cdef double _psi
    cdef double _eps
    cdef double * _x
    cdef double * _y
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _gamb = (<double *>(dataptrarray[0]))[0]
        _phib = (<double *>(dataptrarray[1]))[0]
        _psi = (<double *>(dataptrarray[2]))[0]
        _eps = (<double *>(dataptrarray[3]))[0]
        _x = (<double *>(dataptrarray[4]))
        _y = (<double *>(dataptrarray[5]))
        eraFw2xy(_gamb, _phib, _psi, _eps, _x, _y)
        status = iternext(GetNpyIter(it))


def _num00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatn = (<double *>(dataptrarray[2]))
        eraNum00a(_date1, _date2, _rmatn)
        status = iternext(GetNpyIter(it))


def _num00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatn = (<double *>(dataptrarray[2]))
        eraNum00b(_date1, _date2, _rmatn)
        status = iternext(GetNpyIter(it))


def _num06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatn = (<double *>(dataptrarray[2]))
        eraNum06a(_date1, _date2, _rmatn)
        status = iternext(GetNpyIter(it))


def _numat(it):
    #Iterate
    cdef double _epsa
    cdef double _dpsi
    cdef double _deps
    cdef double * _rmatn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _epsa = (<double *>(dataptrarray[0]))[0]
        _dpsi = (<double *>(dataptrarray[1]))[0]
        _deps = (<double *>(dataptrarray[2]))[0]
        _rmatn = (<double *>(dataptrarray[3]))
        eraNumat(_epsa, _dpsi, _deps, _rmatn)
        status = iternext(GetNpyIter(it))


def _nut00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        eraNut00a(_date1, _date2, _dpsi, _deps)
        status = iternext(GetNpyIter(it))


def _nut00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        eraNut00b(_date1, _date2, _dpsi, _deps)
        status = iternext(GetNpyIter(it))


def _nut06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        eraNut06a(_date1, _date2, _dpsi, _deps)
        status = iternext(GetNpyIter(it))


def _nut80(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        eraNut80(_date1, _date2, _dpsi, _deps)
        status = iternext(GetNpyIter(it))


def _nutm80(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatn = (<double *>(dataptrarray[2]))
        eraNutm80(_date1, _date2, _rmatn)
        status = iternext(GetNpyIter(it))


def _obl06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraObl06(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _obl80(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraObl80(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _p06e(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _eps0
    cdef double * _psia
    cdef double * _oma
    cdef double * _bpa
    cdef double * _bqa
    cdef double * _pia
    cdef double * _bpia
    cdef double * _epsa
    cdef double * _chia
    cdef double * _za
    cdef double * _zetaa
    cdef double * _thetaa
    cdef double * _pa
    cdef double * _gam
    cdef double * _phi
    cdef double * _psi
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _eps0 = (<double *>(dataptrarray[2]))
        _psia = (<double *>(dataptrarray[3]))
        _oma = (<double *>(dataptrarray[4]))
        _bpa = (<double *>(dataptrarray[5]))
        _bqa = (<double *>(dataptrarray[6]))
        _pia = (<double *>(dataptrarray[7]))
        _bpia = (<double *>(dataptrarray[8]))
        _epsa = (<double *>(dataptrarray[9]))
        _chia = (<double *>(dataptrarray[10]))
        _za = (<double *>(dataptrarray[11]))
        _zetaa = (<double *>(dataptrarray[12]))
        _thetaa = (<double *>(dataptrarray[13]))
        _pa = (<double *>(dataptrarray[14]))
        _gam = (<double *>(dataptrarray[15]))
        _phi = (<double *>(dataptrarray[16]))
        _psi = (<double *>(dataptrarray[17]))
        eraP06e(_date1, _date2, _eps0, _psia, _oma, _bpa, _bqa, _pia, _bpia, _epsa, _chia, _za, _zetaa, _thetaa, _pa, _gam, _phi, _psi)
        status = iternext(GetNpyIter(it))


def _pb06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _bzeta
    cdef double * _bz
    cdef double * _btheta
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _bzeta = (<double *>(dataptrarray[2]))
        _bz = (<double *>(dataptrarray[3]))
        _btheta = (<double *>(dataptrarray[4]))
        eraPb06(_date1, _date2, _bzeta, _bz, _btheta)
        status = iternext(GetNpyIter(it))


def _pfw06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _gamb
    cdef double * _phib
    cdef double * _psib
    cdef double * _epsa
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _gamb = (<double *>(dataptrarray[2]))
        _phib = (<double *>(dataptrarray[3]))
        _psib = (<double *>(dataptrarray[4]))
        _epsa = (<double *>(dataptrarray[5]))
        eraPfw06(_date1, _date2, _gamb, _phib, _psib, _epsa)
        status = iternext(GetNpyIter(it))


def _pmat00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rbp
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rbp = (<double *>(dataptrarray[2]))
        eraPmat00(_date1, _date2, _rbp)
        status = iternext(GetNpyIter(it))


def _pmat06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rbp
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rbp = (<double *>(dataptrarray[2]))
        eraPmat06(_date1, _date2, _rbp)
        status = iternext(GetNpyIter(it))


def _pmat76(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatp
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatp = (<double *>(dataptrarray[2]))
        eraPmat76(_date1, _date2, _rmatp)
        status = iternext(GetNpyIter(it))


def _pn00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _dpsi
    cdef double _deps
    cdef double * _epsa
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef double * _rn
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))[0]
        _deps = (<double *>(dataptrarray[3]))[0]
        _epsa = (<double *>(dataptrarray[4]))
        _rb = (<double *>(dataptrarray[5]))
        _rp = (<double *>(dataptrarray[6]))
        _rbp = (<double *>(dataptrarray[7]))
        _rn = (<double *>(dataptrarray[8]))
        _rbpn = (<double *>(dataptrarray[9]))
        eraPn00(_date1, _date2, _dpsi, _deps, _epsa, _rb, _rp, _rbp, _rn, _rbpn)
        status = iternext(GetNpyIter(it))


def _pn00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef double * _epsa
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef double * _rn
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        _epsa = (<double *>(dataptrarray[4]))
        _rb = (<double *>(dataptrarray[5]))
        _rp = (<double *>(dataptrarray[6]))
        _rbp = (<double *>(dataptrarray[7]))
        _rn = (<double *>(dataptrarray[8]))
        _rbpn = (<double *>(dataptrarray[9]))
        eraPn00a(_date1, _date2, _dpsi, _deps, _epsa, _rb, _rp, _rbp, _rn, _rbpn)
        status = iternext(GetNpyIter(it))


def _pn00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef double * _epsa
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef double * _rn
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        _epsa = (<double *>(dataptrarray[4]))
        _rb = (<double *>(dataptrarray[5]))
        _rp = (<double *>(dataptrarray[6]))
        _rbp = (<double *>(dataptrarray[7]))
        _rn = (<double *>(dataptrarray[8]))
        _rbpn = (<double *>(dataptrarray[9]))
        eraPn00b(_date1, _date2, _dpsi, _deps, _epsa, _rb, _rp, _rbp, _rn, _rbpn)
        status = iternext(GetNpyIter(it))


def _pn06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _dpsi
    cdef double _deps
    cdef double * _epsa
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef double * _rn
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))[0]
        _deps = (<double *>(dataptrarray[3]))[0]
        _epsa = (<double *>(dataptrarray[4]))
        _rb = (<double *>(dataptrarray[5]))
        _rp = (<double *>(dataptrarray[6]))
        _rbp = (<double *>(dataptrarray[7]))
        _rn = (<double *>(dataptrarray[8]))
        _rbpn = (<double *>(dataptrarray[9]))
        eraPn06(_date1, _date2, _dpsi, _deps, _epsa, _rb, _rp, _rbp, _rn, _rbpn)
        status = iternext(GetNpyIter(it))


def _pn06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsi
    cdef double * _deps
    cdef double * _epsa
    cdef double * _rb
    cdef double * _rp
    cdef double * _rbp
    cdef double * _rn
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsi = (<double *>(dataptrarray[2]))
        _deps = (<double *>(dataptrarray[3]))
        _epsa = (<double *>(dataptrarray[4]))
        _rb = (<double *>(dataptrarray[5]))
        _rp = (<double *>(dataptrarray[6]))
        _rbp = (<double *>(dataptrarray[7]))
        _rn = (<double *>(dataptrarray[8]))
        _rbpn = (<double *>(dataptrarray[9]))
        eraPn06a(_date1, _date2, _dpsi, _deps, _epsa, _rb, _rp, _rbp, _rn, _rbpn)
        status = iternext(GetNpyIter(it))


def _pnm00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rbpn = (<double *>(dataptrarray[2]))
        eraPnm00a(_date1, _date2, _rbpn)
        status = iternext(GetNpyIter(it))


def _pnm00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rbpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rbpn = (<double *>(dataptrarray[2]))
        eraPnm00b(_date1, _date2, _rbpn)
        status = iternext(GetNpyIter(it))


def _pnm06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rnpb
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rnpb = (<double *>(dataptrarray[2]))
        eraPnm06a(_date1, _date2, _rnpb)
        status = iternext(GetNpyIter(it))


def _pnm80(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _rmatpn
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _rmatpn = (<double *>(dataptrarray[2]))
        eraPnm80(_date1, _date2, _rmatpn)
        status = iternext(GetNpyIter(it))


def _pom00(it):
    #Iterate
    cdef double _xp
    cdef double _yp
    cdef double _sp
    cdef double * _rpom
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _xp = (<double *>(dataptrarray[0]))[0]
        _yp = (<double *>(dataptrarray[1]))[0]
        _sp = (<double *>(dataptrarray[2]))[0]
        _rpom = (<double *>(dataptrarray[3]))
        eraPom00(_xp, _yp, _sp, _rpom)
        status = iternext(GetNpyIter(it))


def _pr00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _dpsipr
    cdef double * _depspr
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _dpsipr = (<double *>(dataptrarray[2]))
        _depspr = (<double *>(dataptrarray[3]))
        eraPr00(_date1, _date2, _dpsipr, _depspr)
        status = iternext(GetNpyIter(it))


def _prec76(it):
    #Iterate
    cdef double _date01
    cdef double _date02
    cdef double _date11
    cdef double _date12
    cdef double * _zeta
    cdef double * _z
    cdef double * _theta
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date01 = (<double *>(dataptrarray[0]))[0]
        _date02 = (<double *>(dataptrarray[1]))[0]
        _date11 = (<double *>(dataptrarray[2]))[0]
        _date12 = (<double *>(dataptrarray[3]))[0]
        _zeta = (<double *>(dataptrarray[4]))
        _z = (<double *>(dataptrarray[5]))
        _theta = (<double *>(dataptrarray[6]))
        eraPrec76(_date01, _date02, _date11, _date12, _zeta, _z, _theta)
        status = iternext(GetNpyIter(it))


def _s00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _x
    cdef double _y
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))[0]
        _y = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraS00(_date1, _date2, _x, _y)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _s00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraS00a(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _s00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraS00b(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _s06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _x
    cdef double _y
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))[0]
        _y = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraS06(_date1, _date2, _x, _y)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _s06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraS06a(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _sp00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraSp00(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _xy06(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _x
    cdef double * _y
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))
        _y = (<double *>(dataptrarray[3]))
        eraXy06(_date1, _date2, _x, _y)
        status = iternext(GetNpyIter(it))


def _xys00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _x
    cdef double * _y
    cdef double * _s
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))
        _y = (<double *>(dataptrarray[3]))
        _s = (<double *>(dataptrarray[4]))
        eraXys00a(_date1, _date2, _x, _y, _s)
        status = iternext(GetNpyIter(it))


def _xys00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _x
    cdef double * _y
    cdef double * _s
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))
        _y = (<double *>(dataptrarray[3]))
        _s = (<double *>(dataptrarray[4]))
        eraXys00b(_date1, _date2, _x, _y, _s)
        status = iternext(GetNpyIter(it))


def _xys06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double * _x
    cdef double * _y
    cdef double * _s
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _x = (<double *>(dataptrarray[2]))
        _y = (<double *>(dataptrarray[3]))
        _s = (<double *>(dataptrarray[4]))
        eraXys06a(_date1, _date2, _x, _y, _s)
        status = iternext(GetNpyIter(it))


def _ee00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _epsa
    cdef double _dpsi
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _epsa = (<double *>(dataptrarray[2]))[0]
        _dpsi = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraEe00(_date1, _date2, _epsa, _dpsi)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _ee00a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEe00a(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _ee00b(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEe00b(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _ee06a(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEe06a(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _eect00(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEect00(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _eqeq94(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEqeq94(_date1, _date2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _era00(it):
    #Iterate
    cdef double _dj1
    cdef double _dj2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dj1 = (<double *>(dataptrarray[0]))[0]
        _dj2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraEra00(_dj1, _dj2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gmst00(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _tta
    cdef double _ttb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _tta = (<double *>(dataptrarray[2]))[0]
        _ttb = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraGmst00(_uta, _utb, _tta, _ttb)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gmst06(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _tta
    cdef double _ttb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _tta = (<double *>(dataptrarray[2]))[0]
        _ttb = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraGmst06(_uta, _utb, _tta, _ttb)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gmst82(it):
    #Iterate
    cdef double _dj1
    cdef double _dj2
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _dj1 = (<double *>(dataptrarray[0]))[0]
        _dj2 = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraGmst82(_dj1, _dj2)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gst00a(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _tta
    cdef double _ttb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _tta = (<double *>(dataptrarray[2]))[0]
        _ttb = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraGst00a(_uta, _utb, _tta, _ttb)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gst00b(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraGst00b(_uta, _utb)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gst06(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _tta
    cdef double _ttb
    cdef double * _rnpb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _tta = (<double *>(dataptrarray[2]))[0]
        _ttb = (<double *>(dataptrarray[3]))[0]
        _rnpb = (<double *>(dataptrarray[4]))
        _c_retval = eraGst06(_uta, _utb, _tta, _ttb, _rnpb)
        (<double *>(dataptrarray[5]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gst06a(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _tta
    cdef double _ttb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _tta = (<double *>(dataptrarray[2]))[0]
        _ttb = (<double *>(dataptrarray[3]))[0]
        _c_retval = eraGst06a(_uta, _utb, _tta, _ttb)
        (<double *>(dataptrarray[4]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _gst94(it):
    #Iterate
    cdef double _uta
    cdef double _utb
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _uta = (<double *>(dataptrarray[0]))[0]
        _utb = (<double *>(dataptrarray[1]))[0]
        _c_retval = eraGst94(_uta, _utb)
        (<double *>(dataptrarray[2]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _pmsafe(it):
    #Iterate
    cdef double _ra1
    cdef double _dec1
    cdef double _pmr1
    cdef double _pmd1
    cdef double _px1
    cdef double _rv1
    cdef double _ep1a
    cdef double _ep1b
    cdef double _ep2a
    cdef double _ep2b
    cdef double * _ra2
    cdef double * _dec2
    cdef double * _pmr2
    cdef double * _pmd2
    cdef double * _px2
    cdef double * _rv2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ra1 = (<double *>(dataptrarray[0]))[0]
        _dec1 = (<double *>(dataptrarray[1]))[0]
        _pmr1 = (<double *>(dataptrarray[2]))[0]
        _pmd1 = (<double *>(dataptrarray[3]))[0]
        _px1 = (<double *>(dataptrarray[4]))[0]
        _rv1 = (<double *>(dataptrarray[5]))[0]
        _ep1a = (<double *>(dataptrarray[6]))[0]
        _ep1b = (<double *>(dataptrarray[7]))[0]
        _ep2a = (<double *>(dataptrarray[8]))[0]
        _ep2b = (<double *>(dataptrarray[9]))[0]
        _ra2 = (<double *>(dataptrarray[10]))
        _dec2 = (<double *>(dataptrarray[11]))
        _pmr2 = (<double *>(dataptrarray[12]))
        _pmd2 = (<double *>(dataptrarray[13]))
        _px2 = (<double *>(dataptrarray[14]))
        _rv2 = (<double *>(dataptrarray[15]))
        _c_retval = eraPmsafe(_ra1, _dec1, _pmr1, _pmd1, _px1, _rv1, _ep1a, _ep1b, _ep2a, _ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2)
        (<int *>(dataptrarray[16]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _pvstar(it):
    #Iterate
    cdef double * _pv
    cdef double * _ra
    cdef double * _dec
    cdef double * _pmr
    cdef double * _pmd
    cdef double * _px
    cdef double * _rv
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _pv = (<double *>(dataptrarray[0]))
        _ra = (<double *>(dataptrarray[1]))
        _dec = (<double *>(dataptrarray[2]))
        _pmr = (<double *>(dataptrarray[3]))
        _pmd = (<double *>(dataptrarray[4]))
        _px = (<double *>(dataptrarray[5]))
        _rv = (<double *>(dataptrarray[6]))
        _c_retval = eraPvstar(_pv, _ra, _dec, _pmr, _pmd, _px, _rv)
        (<int *>(dataptrarray[7]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _starpv(it):
    #Iterate
    cdef double _ra
    cdef double _dec
    cdef double _pmr
    cdef double _pmd
    cdef double _px
    cdef double _rv
    cdef double * _pv
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ra = (<double *>(dataptrarray[0]))[0]
        _dec = (<double *>(dataptrarray[1]))[0]
        _pmr = (<double *>(dataptrarray[2]))[0]
        _pmd = (<double *>(dataptrarray[3]))[0]
        _px = (<double *>(dataptrarray[4]))[0]
        _rv = (<double *>(dataptrarray[5]))[0]
        _pv = (<double *>(dataptrarray[6]))
        _c_retval = eraStarpv(_ra, _dec, _pmr, _pmd, _px, _rv, _pv)
        (<int *>(dataptrarray[7]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _fk52h(it):
    #Iterate
    cdef double _r5
    cdef double _d5
    cdef double _dr5
    cdef double _dd5
    cdef double _px5
    cdef double _rv5
    cdef double * _rh
    cdef double * _dh
    cdef double * _drh
    cdef double * _ddh
    cdef double * _pxh
    cdef double * _rvh
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _r5 = (<double *>(dataptrarray[0]))[0]
        _d5 = (<double *>(dataptrarray[1]))[0]
        _dr5 = (<double *>(dataptrarray[2]))[0]
        _dd5 = (<double *>(dataptrarray[3]))[0]
        _px5 = (<double *>(dataptrarray[4]))[0]
        _rv5 = (<double *>(dataptrarray[5]))[0]
        _rh = (<double *>(dataptrarray[6]))
        _dh = (<double *>(dataptrarray[7]))
        _drh = (<double *>(dataptrarray[8]))
        _ddh = (<double *>(dataptrarray[9]))
        _pxh = (<double *>(dataptrarray[10]))
        _rvh = (<double *>(dataptrarray[11]))
        eraFk52h(_r5, _d5, _dr5, _dd5, _px5, _rv5, _rh, _dh, _drh, _ddh, _pxh, _rvh)
        status = iternext(GetNpyIter(it))


def _fk5hip(it):
    #Iterate
    cdef double * _r5h
    cdef double * _s5h
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _r5h = (<double *>(dataptrarray[0]))
        _s5h = (<double *>(dataptrarray[1]))
        eraFk5hip(_r5h, _s5h)
        status = iternext(GetNpyIter(it))


def _fk5hz(it):
    #Iterate
    cdef double _r5
    cdef double _d5
    cdef double _date1
    cdef double _date2
    cdef double * _rh
    cdef double * _dh
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _r5 = (<double *>(dataptrarray[0]))[0]
        _d5 = (<double *>(dataptrarray[1]))[0]
        _date1 = (<double *>(dataptrarray[2]))[0]
        _date2 = (<double *>(dataptrarray[3]))[0]
        _rh = (<double *>(dataptrarray[4]))
        _dh = (<double *>(dataptrarray[5]))
        eraFk5hz(_r5, _d5, _date1, _date2, _rh, _dh)
        status = iternext(GetNpyIter(it))


def _h2fk5(it):
    #Iterate
    cdef double _rh
    cdef double _dh
    cdef double _drh
    cdef double _ddh
    cdef double _pxh
    cdef double _rvh
    cdef double * _r5
    cdef double * _d5
    cdef double * _dr5
    cdef double * _dd5
    cdef double * _px5
    cdef double * _rv5
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rh = (<double *>(dataptrarray[0]))[0]
        _dh = (<double *>(dataptrarray[1]))[0]
        _drh = (<double *>(dataptrarray[2]))[0]
        _ddh = (<double *>(dataptrarray[3]))[0]
        _pxh = (<double *>(dataptrarray[4]))[0]
        _rvh = (<double *>(dataptrarray[5]))[0]
        _r5 = (<double *>(dataptrarray[6]))
        _d5 = (<double *>(dataptrarray[7]))
        _dr5 = (<double *>(dataptrarray[8]))
        _dd5 = (<double *>(dataptrarray[9]))
        _px5 = (<double *>(dataptrarray[10]))
        _rv5 = (<double *>(dataptrarray[11]))
        eraH2fk5(_rh, _dh, _drh, _ddh, _pxh, _rvh, _r5, _d5, _dr5, _dd5, _px5, _rv5)
        status = iternext(GetNpyIter(it))


def _hfk5z(it):
    #Iterate
    cdef double _rh
    cdef double _dh
    cdef double _date1
    cdef double _date2
    cdef double * _r5
    cdef double * _d5
    cdef double * _dr5
    cdef double * _dd5
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _rh = (<double *>(dataptrarray[0]))[0]
        _dh = (<double *>(dataptrarray[1]))[0]
        _date1 = (<double *>(dataptrarray[2]))[0]
        _date2 = (<double *>(dataptrarray[3]))[0]
        _r5 = (<double *>(dataptrarray[4]))
        _d5 = (<double *>(dataptrarray[5]))
        _dr5 = (<double *>(dataptrarray[6]))
        _dd5 = (<double *>(dataptrarray[7]))
        eraHfk5z(_rh, _dh, _date1, _date2, _r5, _d5, _dr5, _dd5)
        status = iternext(GetNpyIter(it))


def _starpm(it):
    #Iterate
    cdef double _ra1
    cdef double _dec1
    cdef double _pmr1
    cdef double _pmd1
    cdef double _px1
    cdef double _rv1
    cdef double _ep1a
    cdef double _ep1b
    cdef double _ep2a
    cdef double _ep2b
    cdef double * _ra2
    cdef double * _dec2
    cdef double * _pmr2
    cdef double * _pmd2
    cdef double * _px2
    cdef double * _rv2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ra1 = (<double *>(dataptrarray[0]))[0]
        _dec1 = (<double *>(dataptrarray[1]))[0]
        _pmr1 = (<double *>(dataptrarray[2]))[0]
        _pmd1 = (<double *>(dataptrarray[3]))[0]
        _px1 = (<double *>(dataptrarray[4]))[0]
        _rv1 = (<double *>(dataptrarray[5]))[0]
        _ep1a = (<double *>(dataptrarray[6]))[0]
        _ep1b = (<double *>(dataptrarray[7]))[0]
        _ep2a = (<double *>(dataptrarray[8]))[0]
        _ep2b = (<double *>(dataptrarray[9]))[0]
        _ra2 = (<double *>(dataptrarray[10]))
        _dec2 = (<double *>(dataptrarray[11]))
        _pmr2 = (<double *>(dataptrarray[12]))
        _pmd2 = (<double *>(dataptrarray[13]))
        _px2 = (<double *>(dataptrarray[14]))
        _rv2 = (<double *>(dataptrarray[15]))
        _c_retval = eraStarpm(_ra1, _dec1, _pmr1, _pmd1, _px1, _rv1, _ep1a, _ep1b, _ep2a, _ep2b, _ra2, _dec2, _pmr2, _pmd2, _px2, _rv2)
        (<int *>(dataptrarray[16]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _eform(it):
    #Iterate
    cdef int _n
    cdef double * _a
    cdef double * _f
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _n = (<int *>(dataptrarray[0]))[0]
        _a = (<double *>(dataptrarray[1]))
        _f = (<double *>(dataptrarray[2]))
        _c_retval = eraEform(_n, _a, _f)
        (<int *>(dataptrarray[3]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _gc2gd(it):
    #Iterate
    cdef int _n
    cdef double * _xyz
    cdef double * _elong
    cdef double * _phi
    cdef double * _height
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _n = (<int *>(dataptrarray[0]))[0]
        _xyz = (<double *>(dataptrarray[1]))
        _elong = (<double *>(dataptrarray[2]))
        _phi = (<double *>(dataptrarray[3]))
        _height = (<double *>(dataptrarray[4]))
        _c_retval = eraGc2gd(_n, _xyz, _elong, _phi, _height)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _gc2gde(it):
    #Iterate
    cdef double _a
    cdef double _f
    cdef double * _xyz
    cdef double * _elong
    cdef double * _phi
    cdef double * _height
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _a = (<double *>(dataptrarray[0]))[0]
        _f = (<double *>(dataptrarray[1]))[0]
        _xyz = (<double *>(dataptrarray[2]))
        _elong = (<double *>(dataptrarray[3]))
        _phi = (<double *>(dataptrarray[4]))
        _height = (<double *>(dataptrarray[5]))
        _c_retval = eraGc2gde(_a, _f, _xyz, _elong, _phi, _height)
        (<int *>(dataptrarray[6]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _gd2gc(it):
    #Iterate
    cdef int _n
    cdef double _elong
    cdef double _phi
    cdef double _height
    cdef double * _xyz
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _n = (<int *>(dataptrarray[0]))[0]
        _elong = (<double *>(dataptrarray[1]))[0]
        _phi = (<double *>(dataptrarray[2]))[0]
        _height = (<double *>(dataptrarray[3]))[0]
        _xyz = (<double *>(dataptrarray[4]))
        _c_retval = eraGd2gc(_n, _elong, _phi, _height, _xyz)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _gd2gce(it):
    #Iterate
    cdef double _a
    cdef double _f
    cdef double _elong
    cdef double _phi
    cdef double _height
    cdef double * _xyz
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _a = (<double *>(dataptrarray[0]))[0]
        _f = (<double *>(dataptrarray[1]))[0]
        _elong = (<double *>(dataptrarray[2]))[0]
        _phi = (<double *>(dataptrarray[3]))[0]
        _height = (<double *>(dataptrarray[4]))[0]
        _xyz = (<double *>(dataptrarray[5]))
        _c_retval = eraGd2gce(_a, _f, _elong, _phi, _height, _xyz)
        (<int *>(dataptrarray[6]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _pvtob(it):
    #Iterate
    cdef double _elong
    cdef double _phi
    cdef double _hm
    cdef double _xp
    cdef double _yp
    cdef double _sp
    cdef double _theta
    cdef double * _pv
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _elong = (<double *>(dataptrarray[0]))[0]
        _phi = (<double *>(dataptrarray[1]))[0]
        _hm = (<double *>(dataptrarray[2]))[0]
        _xp = (<double *>(dataptrarray[3]))[0]
        _yp = (<double *>(dataptrarray[4]))[0]
        _sp = (<double *>(dataptrarray[5]))[0]
        _theta = (<double *>(dataptrarray[6]))[0]
        _pv = (<double *>(dataptrarray[7]))
        eraPvtob(_elong, _phi, _hm, _xp, _yp, _sp, _theta, _pv)
        status = iternext(GetNpyIter(it))


def _d2dtf(it):
    #Iterate
    cdef const char * _scale
    cdef int _ndp
    cdef double _d1
    cdef double _d2
    cdef int * _iy
    cdef int * _im
    cdef int * _id
    cdef int * _ihmsf
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _scale = (<const char *>(dataptrarray[0]))
        _ndp = (<int *>(dataptrarray[1]))[0]
        _d1 = (<double *>(dataptrarray[2]))[0]
        _d2 = (<double *>(dataptrarray[3]))[0]
        _iy = (<int *>(dataptrarray[4]))
        _im = (<int *>(dataptrarray[5]))
        _id = (<int *>(dataptrarray[6]))
        _ihmsf = (<int *>(dataptrarray[7]))
        _c_retval = eraD2dtf(_scale, _ndp, _d1, _d2, _iy, _im, _id, _ihmsf)
        (<int *>(dataptrarray[8]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _dat(it):
    #Iterate
    cdef int _iy
    cdef int _im
    cdef int _id
    cdef double _fd
    cdef double * _deltat
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _iy = (<int *>(dataptrarray[0]))[0]
        _im = (<int *>(dataptrarray[1]))[0]
        _id = (<int *>(dataptrarray[2]))[0]
        _fd = (<double *>(dataptrarray[3]))[0]
        _deltat = (<double *>(dataptrarray[4]))
        _c_retval = eraDat(_iy, _im, _id, _fd, _deltat)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _dtdb(it):
    #Iterate
    cdef double _date1
    cdef double _date2
    cdef double _ut
    cdef double _elong
    cdef double _u
    cdef double _v
    cdef double _c_retval
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _date1 = (<double *>(dataptrarray[0]))[0]
        _date2 = (<double *>(dataptrarray[1]))[0]
        _ut = (<double *>(dataptrarray[2]))[0]
        _elong = (<double *>(dataptrarray[3]))[0]
        _u = (<double *>(dataptrarray[4]))[0]
        _v = (<double *>(dataptrarray[5]))[0]
        _c_retval = eraDtdb(_date1, _date2, _ut, _elong, _u, _v)
        (<double *>(dataptrarray[6]))[0] = _c_retval
        status = iternext(GetNpyIter(it))


def _dtf2d(it):
    #Iterate
    cdef const char * _scale
    cdef int _iy
    cdef int _im
    cdef int _id
    cdef int _ihr
    cdef int _imn
    cdef double _sec
    cdef double * _d1
    cdef double * _d2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _scale = (<const char *>(dataptrarray[0]))
        _iy = (<int *>(dataptrarray[1]))[0]
        _im = (<int *>(dataptrarray[2]))[0]
        _id = (<int *>(dataptrarray[3]))[0]
        _ihr = (<int *>(dataptrarray[4]))[0]
        _imn = (<int *>(dataptrarray[5]))[0]
        _sec = (<double *>(dataptrarray[6]))[0]
        _d1 = (<double *>(dataptrarray[7]))
        _d2 = (<double *>(dataptrarray[8]))
        _c_retval = eraDtf2d(_scale, _iy, _im, _id, _ihr, _imn, _sec, _d1, _d2)
        (<int *>(dataptrarray[9]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _taitt(it):
    #Iterate
    cdef double _tai1
    cdef double _tai2
    cdef double * _tt1
    cdef double * _tt2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tai1 = (<double *>(dataptrarray[0]))[0]
        _tai2 = (<double *>(dataptrarray[1]))[0]
        _tt1 = (<double *>(dataptrarray[2]))
        _tt2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTaitt(_tai1, _tai2, _tt1, _tt2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _taiut1(it):
    #Iterate
    cdef double _tai1
    cdef double _tai2
    cdef double _dta
    cdef double * _ut11
    cdef double * _ut12
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tai1 = (<double *>(dataptrarray[0]))[0]
        _tai2 = (<double *>(dataptrarray[1]))[0]
        _dta = (<double *>(dataptrarray[2]))[0]
        _ut11 = (<double *>(dataptrarray[3]))
        _ut12 = (<double *>(dataptrarray[4]))
        _c_retval = eraTaiut1(_tai1, _tai2, _dta, _ut11, _ut12)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _taiutc(it):
    #Iterate
    cdef double _tai1
    cdef double _tai2
    cdef double * _utc1
    cdef double * _utc2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tai1 = (<double *>(dataptrarray[0]))[0]
        _tai2 = (<double *>(dataptrarray[1]))[0]
        _utc1 = (<double *>(dataptrarray[2]))
        _utc2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTaiutc(_tai1, _tai2, _utc1, _utc2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tcbtdb(it):
    #Iterate
    cdef double _tcb1
    cdef double _tcb2
    cdef double * _tdb1
    cdef double * _tdb2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tcb1 = (<double *>(dataptrarray[0]))[0]
        _tcb2 = (<double *>(dataptrarray[1]))[0]
        _tdb1 = (<double *>(dataptrarray[2]))
        _tdb2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTcbtdb(_tcb1, _tcb2, _tdb1, _tdb2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tcgtt(it):
    #Iterate
    cdef double _tcg1
    cdef double _tcg2
    cdef double * _tt1
    cdef double * _tt2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tcg1 = (<double *>(dataptrarray[0]))[0]
        _tcg2 = (<double *>(dataptrarray[1]))[0]
        _tt1 = (<double *>(dataptrarray[2]))
        _tt2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTcgtt(_tcg1, _tcg2, _tt1, _tt2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tdbtcb(it):
    #Iterate
    cdef double _tdb1
    cdef double _tdb2
    cdef double * _tcb1
    cdef double * _tcb2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tdb1 = (<double *>(dataptrarray[0]))[0]
        _tdb2 = (<double *>(dataptrarray[1]))[0]
        _tcb1 = (<double *>(dataptrarray[2]))
        _tcb2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTdbtcb(_tdb1, _tdb2, _tcb1, _tcb2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tdbtt(it):
    #Iterate
    cdef double _tdb1
    cdef double _tdb2
    cdef double _dtr
    cdef double * _tt1
    cdef double * _tt2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tdb1 = (<double *>(dataptrarray[0]))[0]
        _tdb2 = (<double *>(dataptrarray[1]))[0]
        _dtr = (<double *>(dataptrarray[2]))[0]
        _tt1 = (<double *>(dataptrarray[3]))
        _tt2 = (<double *>(dataptrarray[4]))
        _c_retval = eraTdbtt(_tdb1, _tdb2, _dtr, _tt1, _tt2)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tttai(it):
    #Iterate
    cdef double _tt1
    cdef double _tt2
    cdef double * _tai1
    cdef double * _tai2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tt1 = (<double *>(dataptrarray[0]))[0]
        _tt2 = (<double *>(dataptrarray[1]))[0]
        _tai1 = (<double *>(dataptrarray[2]))
        _tai2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTttai(_tt1, _tt2, _tai1, _tai2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tttcg(it):
    #Iterate
    cdef double _tt1
    cdef double _tt2
    cdef double * _tcg1
    cdef double * _tcg2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tt1 = (<double *>(dataptrarray[0]))[0]
        _tt2 = (<double *>(dataptrarray[1]))[0]
        _tcg1 = (<double *>(dataptrarray[2]))
        _tcg2 = (<double *>(dataptrarray[3]))
        _c_retval = eraTttcg(_tt1, _tt2, _tcg1, _tcg2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _tttdb(it):
    #Iterate
    cdef double _tt1
    cdef double _tt2
    cdef double _dtr
    cdef double * _tdb1
    cdef double * _tdb2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tt1 = (<double *>(dataptrarray[0]))[0]
        _tt2 = (<double *>(dataptrarray[1]))[0]
        _dtr = (<double *>(dataptrarray[2]))[0]
        _tdb1 = (<double *>(dataptrarray[3]))
        _tdb2 = (<double *>(dataptrarray[4]))
        _c_retval = eraTttdb(_tt1, _tt2, _dtr, _tdb1, _tdb2)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _ttut1(it):
    #Iterate
    cdef double _tt1
    cdef double _tt2
    cdef double _dt
    cdef double * _ut11
    cdef double * _ut12
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _tt1 = (<double *>(dataptrarray[0]))[0]
        _tt2 = (<double *>(dataptrarray[1]))[0]
        _dt = (<double *>(dataptrarray[2]))[0]
        _ut11 = (<double *>(dataptrarray[3]))
        _ut12 = (<double *>(dataptrarray[4]))
        _c_retval = eraTtut1(_tt1, _tt2, _dt, _ut11, _ut12)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _ut1tai(it):
    #Iterate
    cdef double _ut11
    cdef double _ut12
    cdef double _dta
    cdef double * _tai1
    cdef double * _tai2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ut11 = (<double *>(dataptrarray[0]))[0]
        _ut12 = (<double *>(dataptrarray[1]))[0]
        _dta = (<double *>(dataptrarray[2]))[0]
        _tai1 = (<double *>(dataptrarray[3]))
        _tai2 = (<double *>(dataptrarray[4]))
        _c_retval = eraUt1tai(_ut11, _ut12, _dta, _tai1, _tai2)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _ut1tt(it):
    #Iterate
    cdef double _ut11
    cdef double _ut12
    cdef double _dt
    cdef double * _tt1
    cdef double * _tt2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ut11 = (<double *>(dataptrarray[0]))[0]
        _ut12 = (<double *>(dataptrarray[1]))[0]
        _dt = (<double *>(dataptrarray[2]))[0]
        _tt1 = (<double *>(dataptrarray[3]))
        _tt2 = (<double *>(dataptrarray[4]))
        _c_retval = eraUt1tt(_ut11, _ut12, _dt, _tt1, _tt2)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _ut1utc(it):
    #Iterate
    cdef double _ut11
    cdef double _ut12
    cdef double _dut1
    cdef double * _utc1
    cdef double * _utc2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _ut11 = (<double *>(dataptrarray[0]))[0]
        _ut12 = (<double *>(dataptrarray[1]))[0]
        _dut1 = (<double *>(dataptrarray[2]))[0]
        _utc1 = (<double *>(dataptrarray[3]))
        _utc2 = (<double *>(dataptrarray[4]))
        _c_retval = eraUt1utc(_ut11, _ut12, _dut1, _utc1, _utc2)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _utctai(it):
    #Iterate
    cdef double _utc1
    cdef double _utc2
    cdef double * _tai1
    cdef double * _tai2
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _utc1 = (<double *>(dataptrarray[0]))[0]
        _utc2 = (<double *>(dataptrarray[1]))[0]
        _tai1 = (<double *>(dataptrarray[2]))
        _tai2 = (<double *>(dataptrarray[3]))
        _c_retval = eraUtctai(_utc1, _utc2, _tai1, _tai2)
        (<int *>(dataptrarray[4]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok


def _utcut1(it):
    #Iterate
    cdef double _utc1
    cdef double _utc2
    cdef double _dut1
    cdef double * _ut11
    cdef double * _ut12
    cdef int _c_retval
    cdef bint stat_ok = True
    cdef char** dataptrarray = GetDataPtrArray(GetNpyIter(it))
    cdef IterNextFunc iternext = GetIterNext(GetNpyIter(it), NULL)
    cdef int status = 1
    while status:
        _utc1 = (<double *>(dataptrarray[0]))[0]
        _utc2 = (<double *>(dataptrarray[1]))[0]
        _dut1 = (<double *>(dataptrarray[2]))[0]
        _ut11 = (<double *>(dataptrarray[3]))
        _ut12 = (<double *>(dataptrarray[4]))
        _c_retval = eraUtcut1(_utc1, _utc2, _dut1, _ut11, _ut12)
        (<int *>(dataptrarray[5]))[0] = _c_retval
        if _c_retval != 0:
            stat_ok = False
        status = iternext(GetNpyIter(it))
    return stat_ok

