/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Finnish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 18:28:39.454662
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 62,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 36, 63, 45, 12, 54, 40, 37, 39, 31, 52, 30, 64, 35, 65, 58, /* CX */
   66, 57, 50, 34, 32, 53, 22,SYM, 67, 68, 38, 69, 33, 70, 71, 55, /* DX */
   49, 36, 72, 45, 12, 54, 40, 37, 39, 31, 52, 30, 73, 35, 74, 58, /* EX */
   75, 57, 50, 34, 32, 53, 22,SYM, 76, 77, 38, 78, 33, 79, 80, 81, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_4_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 82, 83, 46,SYM, 84, 85,SYM,SYM, 27, 86, 87, 88,SYM, 28,SYM, /* AX */
  SYM, 89,SYM, 46,SYM, 90, 91,SYM,SYM, 27, 92, 93, 94, 43, 28, 43, /* BX */
   59, 36, 95, 45, 12, 54, 40, 96, 48, 31, 97, 30, 98, 35, 99,100, /* CX */
  101, 60, 61,102, 32, 53, 22,SYM,103,104, 38,105, 33,106,107, 55, /* DX */
   59, 36,108, 45, 12, 54, 40,109, 48, 31,110, 30,111, 35,112,113, /* EX */
  114, 60, 61,115, 32, 53, 22,SYM,116,117, 38,118, 33,119,120,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,121,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 36,122, 45, 12, 54, 40, 37, 39, 31, 52, 30,123, 35,124, 58, /* CX */
   51, 57, 50, 34, 32, 53, 22,SYM,125,126, 38,127, 33, 47, 42, 55, /* DX */
   49, 36,128, 45, 12, 54, 40, 37, 39, 31, 52, 30,129, 35,130, 58, /* EX */
   51, 57, 50, 34, 32, 53, 22,SYM,131,132, 38,133, 33, 44, 42,134, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_13_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,135,SYM, 46,SYM,SYM,SYM,SYM, 40, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,136,SYM, 46,SYM,SYM,SYM,SYM, 40, /* BX */
  137,138, 59, 41, 12, 54,139,140, 48, 31,141,142,143,144,145,146, /* CX */
   27,147, 60, 34, 61, 53, 22,SYM,148,149,150,151, 33, 56, 28, 55, /* DX */
  152,153, 59, 41, 12, 54,154,155, 48, 31,156,157,158,159,160,161, /* EX */
   27,162, 60, 34, 61, 53, 22,SYM,163,164,165,166, 33, 56, 28,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 27,SYM, 27,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 28,167,SYM,SYM, 28,SYM,SYM,SYM,168,169,170,SYM, /* BX */
   49, 36,171, 45, 12, 54, 40, 37, 39, 31, 52, 30,172, 35,173, 58, /* CX */
  174, 57, 50, 34, 32, 53, 22,SYM,175,176, 38,177, 33,178,179, 55, /* DX */
   49, 36,180, 45, 12, 54, 40, 37, 39, 31, 52, 30,181, 35,182, 58, /* EX */
  183, 57, 50, 34, 32, 53, 22,SYM,184,185, 38,186, 33,187,188,189, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 4X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 19, 21, 18,  4, 24, 20, 14,  1, 15,  9,  6, 11,  3,  7, /* 6X */
   17, 29, 10,  5,  2,  8, 13, 23, 26, 16, 25,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,190,SYM,SYM,SYM,SYM,SYM,SYM, 27,SYM,191,ILL, 28,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 27,SYM,192,ILL, 28,193, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,194,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   49, 36,195, 45, 12, 54, 40, 37, 39, 31, 52, 30,196, 35,197, 58, /* CX */
  198, 57, 50, 34, 32, 53, 22,SYM,199,200, 38,201, 33,202,203, 55, /* DX */
   49, 36,204, 45, 12, 54, 40, 37, 39, 31, 52, 30,205, 35,206, 58, /* EX */
  207, 57, 50, 34, 32, 53, 22,SYM,208,209, 38,210, 33,211,212,213, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 911
 * First 512 sequences: 0.9986340794830084
 * Next 512 sequences (512-1024): 0.00136592051699156
 * Rest: 2.1033522146218786e-17
 * Negative sequences: TODO
 */
static const PRUint8 FinnishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,2,3,0,3,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,3,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,0,3,3,3,3,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,0,3,3,2,3,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,0,2,3,2,3,2,2,0,2,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,2,
  3,3,2,2,3,3,3,3,3,2,3,3,3,2,2,2,3,3,2,3,3,3,3,2,2,2,2,0,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,0,2,2,0,0,0,0,0,0,0,
  3,3,2,2,3,2,2,3,3,3,2,0,3,2,2,2,3,2,3,2,0,0,2,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,3,3,2,2,0,0,0,0,2,
  3,3,0,3,3,2,2,3,3,2,2,2,3,0,2,0,3,2,0,2,0,0,3,0,2,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,2,2,2,0,0,
  3,3,3,2,3,3,3,3,3,2,3,3,3,2,3,2,3,3,2,2,2,2,3,3,2,0,0,2,0,0,
  3,3,2,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,0,0,3,2,
  3,3,3,3,3,3,3,3,3,3,3,2,2,0,3,2,3,0,3,3,2,3,2,2,0,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,2,3,2,3,3,3,3,3,3,3,3,2,2,0,0,0,0,
  3,3,3,2,3,3,3,3,3,3,3,2,0,0,3,0,3,2,3,2,2,3,0,0,0,2,0,0,0,2,
  2,3,3,3,2,3,3,2,0,3,3,3,3,3,3,3,3,3,3,0,0,0,3,0,2,0,0,0,0,0,
  3,3,2,3,3,3,2,3,2,2,3,2,0,0,3,0,2,0,2,2,2,2,0,2,2,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,2,3,0,2,2,0,2,3,2,0,2,2,2,0,0,3,2,0,0,0,0,
  3,3,2,3,3,2,2,3,2,2,2,2,2,2,2,0,3,2,2,2,2,0,0,2,2,3,0,0,0,0,
  3,3,2,0,2,2,3,2,0,0,0,2,0,2,3,0,2,2,0,2,0,2,0,2,3,0,2,0,0,0,
  3,3,2,2,3,0,0,2,2,2,2,2,0,2,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,0,0,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,0,0,0,2,0,0,3,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_1FinnishModel =
{
  Iso_8859_1_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Iso_8859_4FinnishModel =
{
  Iso_8859_4_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "ISO-8859-4"
};

const SequenceModel Iso_8859_9FinnishModel =
{
  Iso_8859_9_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "ISO-8859-9"
};

const SequenceModel Iso_8859_13FinnishModel =
{
  Iso_8859_13_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "ISO-8859-13"
};

const SequenceModel Iso_8859_15FinnishModel =
{
  Iso_8859_15_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "ISO-8859-15"
};

const SequenceModel Windows_1252FinnishModel =
{
  Windows_1252_CharToOrderMap,
  FinnishLangModel,
  30,
  (float)0.9986340794830084,
  PR_TRUE,
  "WINDOWS-1252"
};