/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Greek *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 18:00:14.826762
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_7_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 33, 50, 41, 39, 31, 53, 48, 42, 30, 58, 51, 40, 45, 34, 37, /* 4X */
   47, 59, 35, 36, 38, 44, 46, 52, 57, 54, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 33, 50, 41, 39, 31, 53, 48, 42, 30, 58, 51, 40, 45, 34, 37, /* 6X */
   47, 59, 35, 36, 38, 44, 46, 52, 57, 54, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM, 17,SYM, 19, 22, 15,SYM, 16,SYM, 24, 27, /* BX */
   55,  0, 26, 18, 20,  5, 32,  9, 25,  3,  8, 14, 13,  4, 29,  1, /* CX */
   10,  6,ILL,  7,  2, 12, 28, 23, 43, 21, 49, 60, 17, 19, 22, 15, /* DX */
   61,  0, 26, 18, 20,  5, 32,  9, 25,  3,  8, 14, 13,  4, 29,  1, /* EX */
   10,  6, 11,  7,  2, 12, 28, 23, 43, 21, 49, 60, 16, 24, 27,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1253_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM, 33, 50, 41, 39, 31, 53, 48, 42, 30, 58, 51, 40, 45, 34, 37, /* 4X */
   47, 59, 35, 36, 38, 44, 46, 52, 57, 54, 56,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM, 33, 50, 41, 39, 31, 53, 48, 42, 30, 58, 51, 40, 45, 34, 37, /* 6X */
   47, 59, 35, 36, 38, 44, 46, 52, 57, 54, 56,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,ILL,SYM,ILL,ILL,ILL,ILL, /* 9X */
  SYM,SYM, 17,SYM,SYM,SYM,SYM,SYM,SYM,SYM,ILL,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 62,SYM,SYM, 19, 22, 15,SYM, 16,SYM, 24, 27, /* BX */
   55,  0, 26, 18, 20,  5, 32,  9, 25,  3,  8, 14, 13,  4, 29,  1, /* CX */
   10,  6,ILL,  7,  2, 12, 28, 23, 43, 21, 49, 60, 17, 19, 22, 15, /* DX */
   61,  0, 26, 18, 20,  5, 32,  9, 25,  3,  8, 14, 13,  4, 29,  1, /* EX */
   10,  6, 11,  7,  2, 12, 28, 23, 43, 21, 49, 60, 16, 24, 27,ILL, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1432
 * First 512 sequences: 0.9633397931004302
 * Next 512 sequences (512-1024): 0.03510604753146752
 * Rest: 0.0015541593681023189
 * Negative sequences: TODO
 */
static const PRUint8 GreekLangModel[] =
{
  1,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,2,1,3,2,3,1,
   2,3,3,3,3,2,3,3,1,0,3,0,0,0,0,0,0,0,0,0,0,2,
  2,2,3,3,3,3,3,3,3,2,3,3,3,3,3,3,1,2,3,2,3,2,
   2,3,3,3,3,2,3,3,0,0,2,0,0,0,1,0,0,0,0,0,0,2,
  3,3,3,3,2,3,3,3,1,3,1,2,3,3,2,3,3,3,1,3,0,3,
   3,1,3,2,1,3,2,0,0,0,3,0,0,0,0,1,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,3,2,3,3,1,3,3,1,3,3,3,3,3,3,
   2,3,1,3,3,3,3,3,0,0,3,0,0,0,0,1,0,0,0,0,0,2,
  3,3,3,3,3,3,2,3,2,3,1,2,2,2,2,3,3,3,3,3,3,3,
   3,2,2,3,1,3,1,0,0,0,2,0,0,0,0,1,0,0,0,0,0,0,
  2,3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,2,2,3,1,3,3,
   1,3,3,3,3,2,3,3,0,0,2,0,0,0,1,0,1,0,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,2,1,3,3,2,3,3,3,3,3,3,3,
   3,3,3,3,2,3,2,2,0,0,2,1,0,0,0,0,0,0,0,1,0,1,
  3,3,3,3,2,3,2,3,3,3,3,0,3,3,2,3,3,3,2,3,2,3,
   3,3,3,3,2,3,3,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,2,3,3,2,3,3,2,2,3,2,3,3,3,3,1,3,3,3,
   3,2,3,2,2,3,2,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,
  1,0,3,1,3,2,3,3,3,0,2,3,0,3,3,0,0,0,3,0,2,1,
   0,2,1,3,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,2,
  3,3,3,3,2,3,3,2,0,3,2,1,3,1,3,3,3,3,1,3,0,3,
   3,1,2,1,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  0,0,1,1,0,1,0,0,1,1,0,1,0,1,0,0,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,3,2,3,2,3,3,3,2,3,3,0,3,3,2,2,3,3,2,3,1,
   2,3,0,3,3,2,2,3,0,0,2,0,0,0,0,0,0,0,0,0,0,3,
  3,3,2,3,3,3,1,1,0,3,3,2,2,3,1,3,3,3,1,3,0,3,
   3,1,3,0,3,3,3,0,0,0,1,1,0,0,0,1,0,0,2,0,0,2,
  3,3,3,3,2,3,1,2,2,3,2,2,3,3,3,3,3,3,3,3,2,3,
   3,1,3,2,2,3,2,1,0,0,0,0,0,0,0,1,0,0,0,0,0,2,
  3,3,3,1,3,3,3,3,3,2,3,3,0,3,3,0,0,0,3,0,3,3,
   0,3,0,3,2,0,2,2,0,0,3,0,0,0,0,0,0,1,0,0,0,2,
  2,2,3,2,3,2,3,3,3,2,3,3,1,3,3,0,0,0,3,0,3,1,
   0,2,1,2,2,0,3,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,
  1,2,3,2,3,2,3,3,3,2,3,3,1,3,3,0,0,0,3,0,3,1,
   0,3,0,3,3,0,3,2,0,0,3,0,0,0,0,0,0,0,0,0,0,2,
  3,3,1,3,3,3,3,1,3,3,0,0,3,3,3,3,3,3,3,3,2,3,
   3,3,2,0,0,3,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,2,3,3,3,2,3,3,0,3,3,0,0,0,3,0,3,3,
   0,3,0,3,2,0,3,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,
  3,3,0,3,1,3,3,1,0,3,0,0,3,1,0,3,3,2,0,3,0,3,
   3,0,3,0,0,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,3,2,3,1,3,3,3,1,3,3,1,3,2,1,0,2,3,1,2,0,
   2,2,0,2,2,0,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,1,3,0,3,3,3,0,2,3,0,3,3,0,0,0,2,0,2,0,
   0,2,0,3,2,0,2,2,0,0,1,0,0,0,0,0,0,0,0,0,0,2,
  3,3,2,3,3,3,3,1,0,3,0,1,2,2,2,3,2,3,0,3,0,3,
   3,0,2,3,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,3,3,1,3,3,3,3,2,2,3,3,0,3,3,0,0,0,3,0,2,1,
   0,2,0,3,2,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,2,
  3,3,0,3,3,3,3,0,1,3,0,1,3,3,3,2,2,3,0,3,0,3,
   3,1,2,0,0,3,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,
  3,3,1,3,1,3,3,1,1,2,0,1,2,0,3,3,3,3,2,3,2,2,
   2,0,2,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  1,2,3,2,3,0,3,3,2,2,3,3,0,3,2,0,0,0,2,0,2,1,
   0,1,0,3,2,0,1,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,
  3,3,2,3,2,3,3,2,1,3,1,0,3,1,2,3,3,3,1,3,0,3,
   3,0,2,2,1,2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,1,3,0,3,0,0,0,3,1,0,2,0,1,2,2,2,0,3,0,2,
   2,0,3,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,1,1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,
   0,0,0,0,0,0,0,0,2,2,0,3,3,2,3,2,3,3,2,3,1,0,
  0,0,0,0,0,1,0,0,1,1,1,0,0,0,1,0,0,0,0,0,0,0,
   0,0,0,1,0,0,0,0,2,2,0,2,3,3,3,2,2,2,2,2,1,0,
  3,3,1,2,2,3,1,1,1,2,0,0,2,2,1,2,2,2,1,2,0,3,
   2,0,1,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,
   0,0,0,1,0,0,1,0,3,2,0,2,3,3,2,1,3,2,3,2,2,0,
  1,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,
   0,0,0,0,0,0,0,0,2,3,0,3,2,2,2,2,2,3,2,2,1,0,
  0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,3,2,2,2,2,2,2,2,2,1,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,2,2,0,2,1,2,2,2,3,1,2,2,2,0,
  0,0,0,1,1,0,1,0,1,0,0,0,1,0,0,0,0,0,0,0,1,0,
   0,1,1,0,1,0,0,0,2,2,0,2,3,3,2,2,2,2,2,2,2,0,
  1,1,0,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,2,1,2,2,2,2,1,2,1,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,2,2,2,3,2,1,1,2,2,1,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,2,1,1,2,3,2,2,2,1,1,0,
  0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,2,2,0,2,1,2,2,2,2,2,2,2,3,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,
   0,0,0,0,0,0,0,0,3,3,0,2,2,2,2,2,2,0,2,1,1,0,
  2,2,0,2,0,3,0,0,0,3,0,0,2,0,0,2,2,1,0,1,0,2,
   2,0,1,0,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_7GreekModel =
{
  Iso_8859_7_CharToOrderMap,
  GreekLangModel,
  44,
  (float)0.9633397931004302,
  PR_FALSE,
  "ISO-8859-7"
};

const SequenceModel Windows_1253GreekModel =
{
  Windows_1253_CharToOrderMap,
  GreekLangModel,
  44,
  (float)0.9633397931004302,
  PR_FALSE,
  "WINDOWS-1253"
};