/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Irish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 18:43:05.118688
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_15_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 4X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 6X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM, 35,SYM, 35,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM, 44, 45,SYM,SYM, 46,SYM,SYM,SYM, 47, 48, 49,SYM, /* BX */
   50, 14, 51, 52, 32, 53, 54, 38, 33, 18, 41, 37, 55, 17, 56, 40, /* CX */
   57, 39, 43, 21, 58, 59, 34,SYM, 36, 60, 20, 61, 31, 62, 63, 64, /* DX */
   65, 14, 66, 67, 32, 68, 69, 38, 33, 18, 41, 37, 70, 17, 71, 40, /* EX */
   72, 39, 43, 21, 73, 74, 34,SYM, 36, 75, 20, 76, 31, 77, 78, 79, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_1_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 4X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 6X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 80,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   81, 14, 82, 83, 32, 84, 85, 38, 33, 18, 41, 37, 86, 17, 87, 40, /* CX */
   88, 39, 43, 21, 89, 90, 34,SYM, 36, 91, 20, 92, 31, 93, 94, 95, /* DX */
   96, 14, 97, 98, 32, 99,100, 38, 33, 18, 41, 37,101, 17,102, 40, /* EX */
  103, 39, 43, 21,104,105, 34,SYM, 36,106, 20,107, 31,108,109,110, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 4X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 6X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,111,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  112, 14,113,114, 32,115,116, 38, 33, 18, 41, 37,117, 17,118, 40, /* CX */
  119, 39, 43, 21,120,121, 34,SYM, 36,122, 20,123, 31,124,125,126, /* DX */
  127, 14,128,129, 32,130,131, 38, 33, 18, 41, 37,132, 17,133, 40, /* EX */
  134, 39, 43, 21,135,136, 34,SYM, 36,137, 20,138, 31, 42,139,140, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Windows_1252_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 4X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 16,  8, 11,  5, 19, 12,  3,  1, 27, 25,  9, 13,  2, 10, /* 6X */
   22, 30,  4,  6,  7, 15, 23, 26, 29, 24, 28,SYM,SYM,SYM,SYM,CTR, /* 7X */
  SYM,ILL,SYM,141,SYM,SYM,SYM,SYM,SYM,SYM, 35,SYM,142,ILL,143,ILL, /* 8X */
  ILL,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 35,SYM,144,ILL,145,146, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM,147,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
  148, 14,149,150, 32,151,152, 38, 33, 18, 41, 37,153, 17,154, 40, /* CX */
  155, 39, 43, 21,156,157, 34,SYM, 36,158, 20,159, 31,160,161,162, /* DX */
  163, 14,164,165, 32,166,167, 38, 33, 18, 41, 37,168, 17,169, 40, /* EX */
  170, 39, 43, 21,171,172, 34,SYM, 36,173, 20,174, 31,175,176,177, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 698
 * First 512 sequences: 0.9972947035131071
 * Next 512 sequences (512-1024): 0.0027052964868929143
 * Rest: -3.122502256758253e-17
 * Negative sequences: TODO
 */
static const PRUint8 IrishLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,0,3,0,0,3,3,3,3,3,2,3,3,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,3,3,3,3,3,3,3,0,2,3,3,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,2,3,0,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,2,3,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,0,3,0,3,3,3,3,3,3,2,3,3,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,3,3,3,3,3,3,3,2,3,3,3,0,3,0,0,
  3,3,3,3,3,3,3,3,3,3,3,0,2,3,3,3,3,3,3,2,3,3,0,3,3,3,2,2,3,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,0,3,3,3,2,3,3,3,3,3,2,0,3,3,2,0,3,0,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,0,3,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,3,0,3,3,0,3,3,3,3,3,3,2,3,2,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,3,3,3,3,0,2,3,2,3,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,2,3,3,3,2,3,3,2,3,3,0,0,2,0,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,2,0,3,3,3,3,3,3,2,2,3,3,0,3,0,0,0,2,2,0,
  0,3,3,0,3,2,3,3,3,3,0,3,3,3,0,0,3,3,0,3,0,0,3,2,0,0,0,0,2,0,0,
  3,3,3,2,3,3,3,3,3,3,2,3,3,3,3,0,3,3,0,3,0,0,3,2,2,2,0,2,3,2,0,
  3,3,3,3,3,3,3,2,2,3,3,2,0,0,3,3,3,3,3,2,3,3,3,0,2,0,0,2,0,0,0,
  2,0,3,0,3,0,3,3,3,3,3,3,3,2,0,0,3,0,0,0,3,0,0,2,0,0,0,0,0,0,0,
  3,3,3,0,2,2,2,2,0,2,3,2,0,2,0,0,2,0,0,0,2,0,2,2,0,0,0,0,0,0,0,
  3,3,0,3,3,3,2,3,2,3,3,0,3,2,3,3,2,3,3,3,0,3,0,2,2,0,0,0,0,0,0,
  2,3,3,0,3,0,3,3,3,3,0,3,2,3,0,0,3,0,0,0,0,0,3,0,0,0,0,0,0,0,0,
  0,3,3,0,3,0,3,3,3,3,0,3,3,3,0,0,3,0,0,2,3,0,3,2,0,0,0,0,2,0,0,
  3,3,0,3,3,3,3,3,2,3,3,0,0,2,3,3,0,3,3,0,2,3,3,0,2,0,0,0,0,0,0,
  3,3,2,0,3,3,3,2,0,3,3,0,2,0,3,2,0,3,3,0,0,3,0,2,2,0,0,0,0,0,0,
  3,0,3,0,2,3,3,2,3,3,3,2,0,3,0,3,2,0,0,2,0,0,0,0,2,0,3,0,0,0,0,
  3,3,3,3,2,3,3,0,0,3,3,0,0,3,2,3,2,0,2,0,0,0,2,2,3,2,2,0,0,0,0,
  3,3,3,3,3,3,3,2,0,3,3,2,0,2,0,2,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,
  3,3,2,0,2,3,0,0,0,0,3,0,0,0,0,3,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,
  3,3,2,3,0,3,2,2,0,0,3,2,2,2,0,2,2,0,0,0,0,0,0,0,2,0,0,0,2,0,2,
  3,3,0,0,0,2,0,2,0,0,2,0,0,0,0,0,0,0,0,3,0,0,3,2,2,0,0,0,0,0,0,
  2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_15IrishModel =
{
  Iso_8859_15_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9972947035131071,
  PR_TRUE,
  "ISO-8859-15"
};

const SequenceModel Iso_8859_1IrishModel =
{
  Iso_8859_1_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9972947035131071,
  PR_TRUE,
  "ISO-8859-1"
};

const SequenceModel Iso_8859_9IrishModel =
{
  Iso_8859_9_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9972947035131071,
  PR_TRUE,
  "ISO-8859-9"
};

const SequenceModel Windows_1252IrishModel =
{
  Windows_1252_CharToOrderMap,
  IrishLangModel,
  31,
  (float)0.9972947035131071,
  PR_TRUE,
  "WINDOWS-1252"
};