/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Lithuanian *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 19:11:17.434390
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_4_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 4X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 6X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 29, 62, 63,SYM, 64, 57,SYM,SYM, 21, 54, 65, 66,SYM, 22,SYM, /* AX */
  SYM, 29,SYM, 67,SYM, 68, 57,SYM,SYM, 21, 54, 69, 70, 71, 22, 72, /* BX */
   43, 39, 73, 51, 38, 44, 74, 30, 24, 35, 31, 55, 17, 40, 75, 48, /* CX */
   60, 58, 34, 76, 59, 77, 36,SYM, 49, 20, 47, 78, 45, 79, 28, 53, /* DX */
   43, 39, 80, 51, 38, 44, 81, 30, 24, 35, 31, 55, 17, 40, 82, 48, /* EX */
   60, 58, 34, 83, 59, 84, 36,SYM, 49, 20, 47, 85, 45, 86, 28,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_10_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 4X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 6X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 29, 54, 87, 48, 88, 89,SYM, 57, 60, 21, 90, 22,SYM, 28, 91, /* AX */
  SYM, 29, 54, 92, 48, 93, 94,SYM, 57, 60, 21, 95, 22, 96, 28, 97, /* BX */
   43, 39, 98, 51, 38, 44, 99, 30, 24, 35, 31, 55, 17, 40,100, 46, /* CX */
   56, 58, 34, 41, 59,101, 36,102, 49, 20, 47,103, 45,104,105, 53, /* DX */
   43, 39,106, 51, 38, 44,107, 30, 24, 35, 31, 55, 17, 40,108, 46, /* EX */
   56, 58, 34, 41, 59,109, 36,110, 49, 20, 47,111, 45,112,113,114, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_13_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 4X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  1, 18, 23, 12,  4, 26, 16, 25,  0, 14,  9, 10, 11,  6,  3, /* 6X */
   15, 37,  5,  2,  7,  8, 13, 33, 32, 19, 27,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 49,SYM,115,SYM,SYM,SYM,SYM,116, /* AX */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, 49,SYM,117,SYM,SYM,SYM,SYM,118, /* BX */
   29, 30, 43, 52, 38, 44, 31, 54, 24, 35,119, 17,120,121, 48, 57, /* CX */
   21, 50, 58, 41, 34,122, 36,SYM, 20, 42, 61, 28, 45,123, 22, 53, /* DX */
   29, 30, 43, 52, 38, 44, 31, 54, 24, 35,124, 17,125,126, 48, 57, /* EX */
   21, 50, 58, 41, 34,127, 36,SYM, 20, 42, 61, 28, 45,128, 22,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1034
 * First 512 sequences: 0.9928074952809003
 * Next 512 sequences (512-1024): 0.007161096401549058
 * Rest: 3.1408317550654305e-05
 * Negative sequences: TODO
 */
static const PRUint8 LithuanianLangModel[] =
{
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,2,3,2,2,0,2,2,
  3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,0,3,3,3,3,3,3,3,0,0,0,0,2,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,0,3,3,3,2,2,3,3,2,2,0,2,1,2,2,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,0,3,3,3,2,3,3,3,0,0,0,0,2,2,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,0,3,3,3,3,2,3,3,0,0,2,0,2,3,0,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,2,2,2,3,3,3,3,2,2,2,2,2,2,
  3,3,3,3,3,3,3,3,3,3,2,2,3,3,2,2,3,3,3,3,3,2,3,3,3,3,3,3,2,3,3,3,2,2,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,0,3,2,2,2,3,3,3,3,2,0,2,0,3,2,2,3,3,3,3,0,2,2,2,2,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,0,3,2,0,3,3,3,3,2,3,3,0,0,0,0,0,2,0,0,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,2,2,3,2,3,3,3,0,3,0,3,2,2,3,3,3,3,0,2,2,1,0,0,
  3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,2,2,2,3,3,2,3,3,3,3,0,2,0,2,2,0,
  3,3,3,3,3,2,2,3,3,2,2,3,2,2,2,3,2,3,3,3,3,2,3,2,0,0,2,2,3,3,0,3,0,2,1,2,2,0,
  3,3,3,3,3,3,2,2,3,3,2,3,2,3,2,2,2,3,2,3,3,2,3,2,0,2,2,3,2,3,2,3,0,2,2,2,2,2,
  3,3,3,3,3,2,2,2,3,2,3,2,2,0,2,2,2,3,0,3,3,2,0,2,0,0,0,3,2,3,0,3,0,0,0,2,0,0,
  3,3,2,3,3,2,2,2,3,2,0,0,0,0,0,2,2,3,0,2,3,0,0,0,0,0,0,0,3,3,3,3,0,0,2,0,2,0,
  3,3,3,3,3,3,2,3,3,3,3,2,2,3,3,2,2,3,0,3,2,3,2,2,2,3,2,0,2,2,2,2,0,0,2,2,0,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,3,2,3,2,3,2,3,3,2,2,2,2,3,0,3,3,3,2,2,0,2,2,0,2,0,
  2,0,3,0,0,3,3,3,2,3,3,3,3,3,3,2,3,0,2,0,0,2,2,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,2,3,3,0,3,0,3,2,2,2,0,3,2,2,3,2,2,2,0,2,0,2,3,3,2,3,0,2,1,0,2,0,
  2,3,3,2,2,3,3,3,2,3,3,3,3,3,3,3,3,0,3,2,0,3,2,2,3,0,2,2,2,0,0,0,0,0,2,0,0,0,
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,3,2,3,2,3,2,2,2,2,3,0,2,0,2,2,2,2,0,0,2,0,0,0,
  3,3,3,3,3,2,3,3,3,2,2,3,3,3,2,2,2,3,2,3,2,2,0,0,0,0,2,0,2,2,2,2,0,0,2,0,0,0,
  3,3,2,3,3,2,0,2,3,3,3,2,2,2,0,0,2,2,2,2,0,0,0,2,0,3,2,2,3,2,0,0,0,0,0,2,0,2,
  3,3,0,2,3,0,0,0,2,2,0,0,2,0,0,2,0,2,0,2,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,
  3,3,2,3,3,3,3,3,3,2,2,3,2,0,2,0,0,0,2,2,2,0,0,0,0,0,2,0,2,2,0,0,0,2,2,0,0,0,
  3,3,2,3,3,3,0,2,3,2,3,2,2,0,2,0,2,2,2,2,2,0,0,3,0,2,2,0,2,2,0,0,0,0,0,0,2,0,
  3,3,2,3,3,2,2,2,3,2,3,3,3,2,0,2,2,2,2,2,3,0,0,2,0,2,0,2,2,2,0,2,0,2,2,2,0,0,
  1,0,3,0,0,3,3,3,0,3,2,3,3,2,0,2,2,0,2,0,0,3,2,0,3,0,0,3,0,0,0,0,0,0,0,0,0,0,
  0,0,3,0,0,2,0,0,0,2,2,2,0,2,3,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,2,3,0,2,3,0,3,0,3,3,2,2,3,2,3,3,2,0,0,0,2,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  3,2,0,0,2,2,0,2,2,0,0,0,0,3,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,0,
  3,3,2,2,3,2,2,0,2,0,2,0,0,0,0,0,2,0,0,2,0,0,0,2,0,2,0,0,0,0,0,0,0,2,0,0,0,0,
  1,0,2,0,2,0,2,0,0,2,0,2,2,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,2,2,2,0,0,0,0,2,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
  0,0,2,0,0,2,2,2,0,2,2,2,2,0,0,0,2,0,0,0,0,0,0,2,0,0,2,2,0,0,0,0,0,0,0,0,0,0,
  2,0,0,0,0,0,0,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_4LithuanianModel =
{
  Iso_8859_4_CharToOrderMap,
  LithuanianLangModel,
  38,
  (float)0.9928074952809003,
  PR_TRUE,
  "ISO-8859-4"
};

const SequenceModel Iso_8859_10LithuanianModel =
{
  Iso_8859_10_CharToOrderMap,
  LithuanianLangModel,
  38,
  (float)0.9928074952809003,
  PR_TRUE,
  "ISO-8859-10"
};

const SequenceModel Iso_8859_13LithuanianModel =
{
  Iso_8859_13_CharToOrderMap,
  LithuanianLangModel,
  38,
  (float)0.9928074952809003,
  PR_TRUE,
  "ISO-8859-13"
};