/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "../nsSBCharSetProber.h"

/********* Language model for: Turkish *********/

/**
 * Generated by BuildLangModel.py
 * On: 2017-03-27 20:20:53.877931
 **/

/* Character Mapping Table:
 * ILL: illegal character.
 * CTR: control character specific to the charset.
 * RET: carriage/return.
 * SYM: symbol (punctuation) that does not belong to word.
 * NUM: 0 - 9.
 *
 * Other characters are ordered by probabilities
 * (0 is the most common character in the language).
 *
 * Orders are generic to a language. So the codepoint with order X in
 * CHARSET1 maps to the same character as the codepoint with the same
 * order X in CHARSET2 for the same language.
 * As such, it is possible to get missing order. For instance the
 * ligature of 'o' and 'e' exists in ISO-8859-15 but not in ISO-8859-1
 * even though they are both used for French. Same for the euro sign.
 */
static const unsigned char Iso_8859_3_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15, 22,  7,  1, 26, 20, 19,  6, 29,  8,  5, 11,  3, 14, /* 4X */
   23, 35,  4, 10,  9, 12, 18, 28, 32, 13, 21,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15, 22,  7,  1, 26, 20, 19,  2, 29,  8,  5, 11,  3, 14, /* 6X */
   23, 35,  4, 10,  9, 12, 18, 28, 32, 13, 21,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM, 53,SYM,SYM,SYM,ILL, 54,SYM,SYM,  2, 17, 25, 55,SYM,ILL, 48, /* AX */
  SYM, 56,SYM,SYM,SYM,SYM, 57,SYM,SYM,  6, 17, 25, 58,SYM,ILL, 48, /* BX */
   50, 38, 30,ILL, 37, 59, 60, 24, 42, 34, 61, 51, 46, 39, 31, 49, /* CX */
  ILL, 62, 63, 40, 64, 52, 27,SYM, 65, 66, 44, 33, 16, 67, 68, 36, /* DX */
   50, 38, 30,ILL, 37, 69, 70, 24, 42, 34, 71, 51, 46, 39, 31, 49, /* EX */
  ILL, 72, 73, 40, 74, 52, 27,SYM, 75, 76, 44, 33, 16, 77, 78,SYM, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */

static const unsigned char Iso_8859_9_CharToOrderMap[] =
{
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,RET,CTR,CTR,RET,CTR,CTR, /* 0X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 1X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* 2X */
  NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,NUM,SYM,SYM,SYM,SYM,SYM,SYM, /* 3X */
  SYM,  0, 15, 22,  7,  1, 26, 20, 19,  6, 29,  8,  5, 11,  3, 14, /* 4X */
   23, 35,  4, 10,  9, 12, 18, 28, 32, 13, 21,SYM,SYM,SYM,SYM,SYM, /* 5X */
  SYM,  0, 15, 22,  7,  1, 26, 20, 19,  2, 29,  8,  5, 11,  3, 14, /* 6X */
   23, 35,  4, 10,  9, 12, 18, 28, 32, 13, 21,SYM,SYM,SYM,SYM,CTR, /* 7X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 8X */
  CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR,CTR, /* 9X */
  SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* AX */
  SYM,SYM,SYM,SYM,SYM, 79,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM,SYM, /* BX */
   50, 38, 30, 41, 37, 47, 43, 24, 42, 34, 80, 51, 46, 39, 31, 49, /* CX */
   25, 81, 82, 40, 83, 84, 27,SYM, 45, 85, 44, 33, 16,  2, 17, 36, /* DX */
   50, 38, 30, 41, 37, 47, 43, 24, 42, 34, 86, 51, 46, 39, 31, 49, /* EX */
   25, 87, 88, 40, 89, 90, 27,SYM, 45, 91, 44, 33, 16,  6, 17, 92, /* FX */
};
/*X0  X1  X2  X3  X4  X5  X6  X7  X8  X9  XA  XB  XC  XD  XE  XF */


/* Model Table:
 * Total sequences: 1021
 * First 512 sequences: 0.9935973653526393
 * Next 512 sequences (512-1024): 0.006402634647360638
 * Rest: 4.5102810375396984e-17
 * Negative sequences: TODO
 */
static const PRUint8 TurkishLangModel[] =
{
  3,3,3,3,3,3,2,3,3,3,3,3,3,3,2,3,2,3,3,3,3,3,3,3,3,3,3,2,3,3,0,2,2,0,
  3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,3,3,3,0,3,3,0,0,2,0,
  3,3,3,3,3,3,0,3,3,3,3,3,2,3,3,3,2,3,3,3,3,3,3,3,3,3,3,0,2,2,0,2,2,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,0,3,2,2,2,2,2,0,0,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,3,2,2,2,2,
  3,3,3,3,2,3,3,3,3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,0,3,2,2,2,3,2,0,2,
  2,2,2,3,3,3,3,3,3,3,3,3,2,3,2,2,0,3,2,2,2,3,3,3,3,3,3,0,2,0,0,0,2,0,
  3,3,3,2,3,3,3,3,2,2,3,2,3,3,3,2,3,0,2,2,2,2,2,2,0,0,2,3,2,2,2,2,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,2,3,2,2,2,2,2,2,2,3,0,2,3,2,2,3,2,0,3,
  3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,3,0,3,3,2,3,2,2,3,0,2,3,2,0,2,0,0,2,
  3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,0,3,3,2,2,3,3,3,0,2,3,3,0,2,2,0,0,
  3,3,3,3,3,3,3,3,2,3,3,3,3,3,3,3,3,2,2,3,2,3,3,3,2,0,2,2,2,0,2,2,2,2,
  3,3,3,3,3,3,0,3,3,3,3,3,2,3,2,3,0,3,3,3,3,3,3,3,3,3,3,0,2,2,0,0,2,0,
  3,3,3,3,3,3,3,3,3,2,3,3,3,2,3,3,3,2,3,2,3,2,2,2,0,0,2,3,2,0,2,0,0,2,
  2,3,2,3,3,3,0,3,3,3,3,3,3,3,3,3,0,3,3,3,3,3,3,3,2,3,3,0,3,3,0,0,2,0,
  3,3,3,3,3,3,3,3,2,2,2,2,3,2,3,3,3,0,2,2,2,3,2,0,0,0,2,3,2,2,2,2,0,2,
  2,2,2,3,3,3,0,3,3,3,3,3,0,3,2,3,0,3,3,2,2,3,3,3,3,3,3,2,0,0,0,0,0,0,
  3,3,3,2,2,3,3,2,3,3,2,3,3,2,2,3,3,2,2,2,3,2,2,2,3,0,2,2,0,0,2,0,0,0,
  3,3,3,2,3,3,2,3,2,2,2,2,3,3,3,2,2,2,3,2,2,2,3,0,2,0,2,0,0,0,2,3,0,0,
  3,3,3,3,3,3,3,2,3,3,3,3,3,2,3,2,3,2,2,2,0,2,2,2,3,0,2,2,2,0,2,2,0,0,
  3,3,3,2,3,3,3,2,2,3,2,2,3,2,3,2,3,0,0,3,2,2,0,2,2,0,2,3,2,0,2,0,0,2,
  3,3,3,2,2,3,3,3,2,2,2,3,3,3,3,2,3,2,2,2,3,2,3,2,2,0,2,3,0,0,2,2,0,0,
  3,3,3,2,3,3,3,2,3,2,2,3,3,2,3,3,3,0,0,3,2,2,2,0,0,0,2,2,2,0,2,0,2,0,
  3,3,3,2,3,3,3,2,2,3,3,3,3,2,3,2,3,0,2,3,0,2,2,2,3,0,2,0,0,0,0,0,0,0,
  3,3,3,0,2,3,3,0,2,3,2,3,3,2,3,2,3,0,0,2,2,0,0,0,2,0,0,2,0,0,0,0,0,0,
  3,3,3,2,3,3,3,3,0,2,2,3,3,0,2,2,3,0,2,0,0,2,2,0,2,0,0,0,0,0,0,0,0,0,
  3,3,3,2,3,3,3,2,2,3,2,2,3,2,3,2,3,2,0,2,2,0,2,0,2,0,3,2,2,0,2,2,0,2,
  0,2,0,3,3,3,0,3,3,3,3,3,0,3,0,2,0,2,2,2,2,3,2,3,3,3,2,0,0,0,0,0,0,0,
  3,3,3,2,2,2,0,0,0,2,2,0,2,2,3,2,2,0,2,2,0,0,2,0,0,0,0,2,2,0,0,0,0,0,
  3,3,3,2,2,2,2,2,2,0,2,2,3,2,3,0,2,0,0,0,0,0,0,2,0,0,0,2,0,0,0,0,0,0,
  2,2,2,2,2,2,0,2,2,2,2,2,0,2,0,2,0,2,2,2,0,2,2,0,0,2,2,0,0,0,0,0,0,0,
  0,0,0,2,2,2,0,2,2,0,0,2,0,2,0,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
  2,2,2,0,0,2,2,0,0,2,0,0,2,0,2,2,0,0,2,2,0,0,2,2,0,0,2,0,0,0,0,0,2,0,
  0,0,0,2,2,2,0,0,2,0,2,3,0,0,0,2,0,2,0,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,
};


const SequenceModel Iso_8859_3TurkishModel =
{
  Iso_8859_3_CharToOrderMap,
  TurkishLangModel,
  34,
  (float)0.9935973653526393,
  PR_FALSE,
  "ISO-8859-3"
};

const SequenceModel Iso_8859_9TurkishModel =
{
  Iso_8859_9_CharToOrderMap,
  TurkishLangModel,
  34,
  (float)0.9935973653526393,
  PR_FALSE,
  "ISO-8859-9"
};