#!/usr/bin/env python

import os
import sys
import unittest

#
# This list will hold all test programs to run
#

tests = [
    "tests/datatransfer"
]

#
# Run each test
#

succeeded = 0
failed = 0

for test in tests:

    curdir = os.getcwd()
    os.chdir(test)

    try:
        alltests = __import__("alltests")

        print "Test: " + alltests.name + " ... ",
        
        tests = alltests.AllTests()
        test_runner = unittest.TextTestRunner()
        
        test_result = test_runner.run(tests.get_test_suite())
        
        tests.done()

        if test_result.wasSuccessful():
            succeeded += 1
            result_string = 'ok'
        else:
            failed += 1
            result_string = 'failed'

        print result_string

    finally:
        os.chdir(curdir)

#
# Output the results summary
#

print "Testing complete. Okay:", succeeded, "; Failed:", failed, ";"
