  $ cat >> $HGRCPATH <<EOF
  > [ui]
  > logtemplate = {rev}:{node|short} {desc}\n
  > [extensions]
  > rebase=
  > EOF
  $ echo "evolve=$(echo $(dirname $TESTDIR))/hgext/evolve.py" >> $HGRCPATH
  $ echo "inhibit=$(echo $(dirname $TESTDIR))/hgext/inhibit.py" >> $HGRCPATH
  $ mkcommit() {
  >    echo "$1" > "$1"
  >    hg add "$1"
  >    hg ci -m "add $1"
  > }

  $ hg init inhibit
  $ cd inhibit
  $ mkcommit cA
  $ mkcommit cB
  $ mkcommit cC
  $ mkcommit cD
  $ hg up 'desc(cA)'
  0 files updated, 0 files merged, 3 files removed, 0 files unresolved
  $ mkcommit cE
  created new head
  $ mkcommit cG
  $ mkcommit cH
  $ mkcommit cJ
  $ hg log -G
  @  7:18214586bf78 add cJ
  |
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | o  3:2db36d8066ff add cD
  | |
  | o  2:7df62a38b9bf add cC
  | |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  

plain prune

  $ hg prune 1::
  3 changesets pruned
  $ hg log -G
  @  7:18214586bf78 add cJ
  |
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg debugobsinhibit --hidden 1::
  $ hg log -G
  @  7:18214586bf78 add cJ
  |
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | o  3:2db36d8066ff add cD
  | |
  | o  2:7df62a38b9bf add cC
  | |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  
  $ hg prune --hidden 1::
  3 changesets pruned
  $ hg log -G
  @  7:18214586bf78 add cJ
  |
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  

after amend

  $ echo babar > cJ
  $ hg amend
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg debugobsinhibit --hidden 18214586bf78
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  

and no divergence

  $ hg summary
  parent: 9:55c73a90e4b4 tip
   add cJ
  branch: default
  commit: (clean)
  update: 1 new changesets, 2 branch heads (merge)

check public revision got cleared
(when adding the second inhibitor, the first one is removed because it is public)

  $ wc -m .hg/store/obsinhibit | sed -e 's/^[ \t]*//'
  20 .hg/store/obsinhibit
  $ hg prune 7
  1 changesets pruned
  $ hg debugobsinhibit --hidden 18214586bf78
  $ wc -m .hg/store/obsinhibit | sed -e 's/^[ \t]*//'
  20 .hg/store/obsinhibit
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg phase --public 7
  $ hg prune 9
  0 files updated, 0 files merged, 1 files removed, 0 files unresolved
  working directory now at cf5c4f4554ce
  1 changesets pruned
  $ hg log -G
  o  7:18214586bf78 add cJ
  |
  @  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg debugobsinhibit --hidden 55c73a90e4b4
  $ wc -m .hg/store/obsinhibit | sed -e 's/^[ \t]*//'
  20 .hg/store/obsinhibit
  $ hg log -G
  o  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  @  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
Update should inhibit all related unstable commits

  $ hg update 2 --hidden
  2 files updated, 0 files merged, 3 files removed, 0 files unresolved
  working directory parent is obsolete!
  $ hg log -G
  o  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | @  2:7df62a38b9bf add cC
  | |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  

  $ hg update 9
  4 files updated, 0 files merged, 2 files removed, 0 files unresolved
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | o  2:7df62a38b9bf add cC
  | |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  
  $ hg prune --hidden 1::
  3 changesets pruned
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  

Bookmark should inhibit all related unstable commits
  $ hg bookmark -r 2 book1  --hidden
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | o  2:7df62a38b9bf add cC
  | |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  

Removing a bookmark with bookmark -D should prune the changes underneath
that are not reachable from another bookmark or head

  $ hg bookmark -r 1 book2
  $ hg bookmark -D book1
  bookmark 'book1' deleted
  1 changesets pruned
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  | o  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  
  $ hg bookmark -D book2
  bookmark 'book2' deleted
  1 changesets pruned
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
Test that direct access make changesets visible

  $ hg export 2db36d8066ff 02bcbc3f6e56
  # HG changeset patch
  # User test
  # Date 0 0
  #      Thu Jan 01 00:00:00 1970 +0000
  # Node ID 2db36d8066ff50e8be3d3e6c2da1ebc0a8381d82
  # Parent  7df62a38b9bf9daf968de235043ba88a8ef43393
  add cD
  
  diff -r 7df62a38b9bf -r 2db36d8066ff cD
  --- /dev/null	Thu Jan 01 00:00:00 1970 +0000
  +++ b/cD	Thu Jan 01 00:00:00 1970 +0000
  @@ -0,0 +1,1 @@
  +cD
  # HG changeset patch
  # User test
  # Date 0 0
  #      Thu Jan 01 00:00:00 1970 +0000
  # Node ID 02bcbc3f6e56fb2928efec2c6e24472720bf5511
  # Parent  54ccbc537fc2d6845a5d61337c1cfb80d1d2815e
  add cB
  
  diff -r 54ccbc537fc2 -r 02bcbc3f6e56 cB
  --- /dev/null	Thu Jan 01 00:00:00 1970 +0000
  +++ b/cB	Thu Jan 01 00:00:00 1970 +0000
  @@ -0,0 +1,1 @@
  +cB

But only with hash

  $ hg export 2db36d8066ff::
  # HG changeset patch
  # User test
  # Date 0 0
  #      Thu Jan 01 00:00:00 1970 +0000
  # Node ID 2db36d8066ff50e8be3d3e6c2da1ebc0a8381d82
  # Parent  7df62a38b9bf9daf968de235043ba88a8ef43393
  add cD
  
  diff -r 7df62a38b9bf -r 2db36d8066ff cD
  --- /dev/null	Thu Jan 01 00:00:00 1970 +0000
  +++ b/cD	Thu Jan 01 00:00:00 1970 +0000
  @@ -0,0 +1,1 @@
  +cD

  $ hg export 1 3
  abort: hidden revision '1'!
  (use --hidden to access hidden revisions)
  [255]


With severals hidden sha, rebase of one hidden stack onto another one:
  $ hg update -C 0
  0 files updated, 0 files merged, 4 files removed, 0 files unresolved
  $ mkcommit cK
  created new head
  $ mkcommit cL
  $ hg update -C 9
  4 files updated, 0 files merged, 2 files removed, 0 files unresolved
  $ hg log -G
  o  11:53a94305e133 add cL
  |
  o  10:ad78ff7d621f add cK
  |
  | @  9:55c73a90e4b4 add cJ
  | |
  | | o  7:18214586bf78 add cJ
  | |/
  | o  6:cf5c4f4554ce add cH
  | |
  | o  5:5419eb264a33 add cG
  | |
  | o  4:98065434e5c6 add cE
  |/
  o  0:54ccbc537fc2 add cA
  
  $ hg prune 10:
  2 changesets pruned
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg rebase -s 10 -d 3 
  abort: hidden revision '3'!
  (use --hidden to access hidden revisions)
  [255]
  $ hg rebase -r ad78ff7d621f -r 53a94305e133 -d  2db36d8066ff
  rebasing 10:ad78ff7d621f "add cK"
  rebasing 11:53a94305e133 "add cL"
  $ hg log -G
  o  13:2f7b7704d714 add cL
  |
  o  12:fe1634cbe235 add cK
  |
  | o  11:53a94305e133 add cL
  | |
  | o  10:ad78ff7d621f add cK
  | |
  | | @  9:55c73a90e4b4 add cJ
  | | |
  | | | o  7:18214586bf78 add cJ
  | | |/
  | | o  6:cf5c4f4554ce add cH
  | | |
  | | o  5:5419eb264a33 add cG
  | | |
  | | o  4:98065434e5c6 add cE
  | |/
  o |  3:2db36d8066ff add cD
  | |
  o |  2:7df62a38b9bf add cC
  | |
  o |  1:02bcbc3f6e56 add cB
  |/
  o  0:54ccbc537fc2 add cA
  
Check that amending in the middle of a stack does not show obsolete revs

  $ hg prune 1::
  5 changesets pruned
  $ hg prune 10::
  2 changesets pruned
  $ hg log -G
  @  9:55c73a90e4b4 add cJ
  |
  | o  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg up 7
  1 files updated, 0 files merged, 0 files removed, 0 files unresolved
  $ mkcommit cL
  $ mkcommit cM
  $ mkcommit cN
  $ hg log -G
  @  16:a438c045eb37 add cN
  |
  o  15:2d66e189f5b5 add cM
  |
  o  14:d66ccb8c5871 add cL
  |
  | o  9:55c73a90e4b4 add cJ
  | |
  o |  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  
  $ hg up 15
  0 files updated, 0 files merged, 1 files removed, 0 files unresolved
  $ echo "mmm" >> cM
  $ hg amend
  $ hg log -G
  @  18:210589181b14 add cM
  |
  | o  16:a438c045eb37 add cN
  | |
  | o  15:2d66e189f5b5 add cM
  |/
  o  14:d66ccb8c5871 add cL
  |
  | o  9:55c73a90e4b4 add cJ
  | |
  o |  7:18214586bf78 add cJ
  |/
  o  6:cf5c4f4554ce add cH
  |
  o  5:5419eb264a33 add cG
  |
  o  4:98065434e5c6 add cE
  |
  o  0:54ccbc537fc2 add cA
  

