hgwatchman
==========

Integrates the file-watching program watchman with Mercurial to produce faster
status results.

On a real-world repository with over 200,000 files, `hg status` normally takes
over 3 seconds. With hgwatchman it takes under 0.6 seconds.

Installing
==========

**NOTE:** hgwatchman is only known to work on Linux. It will likely deal poorly
with case-insensitive file systems.

First, install [watchman](https://github.com/facebook/watchman) and make sure it
is in your PATH.

Then, run

    :::sh
    hg clone https://bitbucket.org/facebook/hgwatchman

In your `hgrc`, add the following lines:

    :::ini
    [extensions]
    hgwatchman = path/to/this/directory/hgwatchman

Configuring
===========

hgwatchman requires no configuration -- it will tell watchman about your
repository as necessary. There does exist one configuration option, though:

    :::ini
    [watchman]
    mode = {off, on, paranoid}

When `mode = off`, hgwatchman will disable itself. When `mode = on`, hgwatchman
will be enabled as usual. When `mode = paranoid`, hgwatchman will query both
watchman and the filesystem, and ensure that the results are consistent.

Known Issues
============

* hgwatchman will disable itself if any of the following extensions are enabled:
  largefiles, inotify, eol; or if the repository has subrepos.
* hgwatchman will produce incorrect results if nested repos that are not
  subrepos exist.

The issues related to nested repos and subrepos are probably not fundamental
ones. Patches to fix them are welcome.

Contributing
============

Patches are welcome as pull requests, though they will be collapsed and rebased
to maintain a linear history. We may also set up a Phabricator project on
https://reviews.facebook.net/ soon.

License
=======

Watchman is made available under the terms of the GNU General Public License
version 2, or any later version. See the COPYING file that accompanies this
distribution for the full text of the license.
