import { RJSFSchema, EnumOptionsType, StrictRJSFSchema } from './types';
/** Gets the list of options from the schema. If the schema has an enum list, then those enum values are returned. The
 * labels for the options will be extracted from the non-standard, RJSF-deprecated `enumNames` if it exists, otherwise
 * the label will be the same as the `value`. If the schema has a `oneOf` or `anyOf`, then the value is the list of
 * `const` values from the schema and the label is either the `schema.title` or the value.
 *
 * @param schema - The schema from which to extract the options list
 * @returns - The list of options from the schema
 */
export default function optionsList<S extends StrictRJSFSchema = RJSFSchema>(schema: S): EnumOptionsType<S>[] | undefined;
