'use strict';

const cssTree = require('css-tree');

const FUNCTION = cssTree.tokenTypes.Function;
const IDENT = cssTree.tokenTypes.Ident;
const DOLLARSIGN = 0x0024; // U+0024 DOLLAR SIGN ($)
const FULLSTOP = 0x002E;   // U+002E FULL STOP (.)

function consumeRaw() {
    return this.createSingleNodeList(
        this.Raw(this.tokenIndex, null, false)
    );
}

const name = 'SassNamespace';
const structure = {
    name: 'Identifier',
    member: ['Function', 'Ident']
};
function parse() {
    const start = this.tokenStart;
    const name = this.consume(IDENT);
    let member;

    this.eatDelim(FULLSTOP);

    switch (this.tokenType) {
        case FUNCTION:
            member = this.Function(consumeRaw, this.scope.Value);
            break;

        default:
            if (this.isDelim(DOLLARSIGN)) {
                member = this.SassVariable();
            } else {
                this.error('Function or ident expected');
            }
    }

    return {
        type: 'SassNamespace',
        loc: this.getLocation(start, this.tokenEnd),
        name,
        member
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
