'use strict';

const cssTree = require('css-tree');

const IDENT = cssTree.tokenTypes.Ident;
const DOLLARSIGN = 0x0024; // U+0024 DOLLAR SIGN ($)

const name = 'SassVariable';
const structure = {
    name: 'Identifier'
};
function parse() {
    const start = this.tokenStart;

    this.eatDelim(DOLLARSIGN);

    return {
        type: 'SassVariable',
        loc: this.getLocation(start, this.tokenEnd),
        name: this.consume(IDENT)
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
