import { IRenderMime } from '@jupyterlab/rendermime-interfaces';
/**
 * A class to sanitize HTML strings.
 */
export declare class Sanitizer implements IRenderMime.ISanitizer {
    /**
     * Sanitize an HTML string.
     *
     * @param dirty - The dirty text.
     *
     * @param options - The optional sanitization options.
     *
     * @returns The sanitized string.
     */
    sanitize(dirty: string, options?: IRenderMime.ISanitizerOptions): string;
    /**
     * @returns Whether to replace URLs by HTML anchors.
     */
    getAutolink(): boolean;
    /**
     * Set the allowed schemes
     *
     * @param scheme Allowed schemes
     */
    setAllowedSchemes(scheme: Array<string>): void;
    /**
     * Set the URL replacement boolean.
     *
     * @param autolink URL replacement boolean.
     */
    setAutolink(autolink: boolean): void;
    private _autolink;
    private _options;
}
