import { Cell, CodeCellModel } from '@jupyterlab/cells';
import { CodeEditorWrapper } from '@jupyterlab/codeeditor';
import { Context, DocumentRegistry } from '@jupyterlab/docregistry';
import { INotebookContent } from '@jupyterlab/nbformat';
import { RenderMimeRegistry } from '@jupyterlab/rendermime';
import { ServiceManager } from '@jupyterlab/services';
import { INotebookModel } from './model';
import { NotebookPanel } from './panel';
import { Notebook } from './widget';
import { NotebookWidgetFactory } from './widgetfactory';
export declare const DEFAULT_CONTENT: INotebookContent;
/**
 * Create and initialize context for a notebook.
 */
export declare function initNotebookContext(options?: {
    path?: string;
    manager?: ServiceManager.IManager;
    startKernel?: boolean;
}): Promise<Context<INotebookModel>>;
/**
 * The default notebook content.
 */
export declare namespace NBTestUtils {
    const DEFAULT_OUTPUTS: import("@jupyterlab/nbformat").IOutput[];
    const defaultEditorConfig: {
        code: Record<string, any>;
        markdown: Record<string, any>;
        raw: Record<string, any>;
    };
    const editorFactory: any;
    const mimeTypeService: import("@jupyterlab/codeeditor").IEditorMimeTypeService;
    /**
     * Get a copy of the default rendermime instance.
     */
    function defaultRenderMime(): RenderMimeRegistry;
    const clipboard: import("@lumino/coreutils").MimeData;
    /**
     * Create a base cell content factory.
     */
    function createBaseCellFactory(): Cell.IContentFactory;
    /**
     * Create a new code cell content factory.
     */
    function createCodeCellFactory(): Cell.IContentFactory;
    /**
     * Create a cell editor widget.
     */
    function createCellEditor(model?: CodeCellModel): CodeEditorWrapper;
    /**
     * Create a default notebook content factory.
     */
    function createNotebookFactory(): Notebook.IContentFactory;
    /**
     * Create a default notebook panel content factory.
     */
    function createNotebookPanelFactory(): NotebookPanel.IContentFactory;
    /**
     * Create a notebook widget.
     */
    function createNotebook(): Notebook;
    /**
     * Create a notebook panel widget.
     */
    function createNotebookPanel(context: Context<INotebookModel>): NotebookPanel;
    /**
     * Populate a notebook with default content.
     */
    function populateNotebook(notebook: Notebook): void;
    function createNotebookWidgetFactory(toolbarFactory?: (widget: NotebookPanel) => DocumentRegistry.IToolbarItem[]): NotebookWidgetFactory;
    /**
     * Create a context for a file.
     */
    function createMockContext(startKernel?: boolean): Promise<Context<INotebookModel>>;
}
