// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { positionAtOffset } from '../positioning';
/**
 * The code extractor for the raw and markdown text.
 */
export class TextForeignCodeExtractor {
    constructor(options) {
        this.language = options.language;
        this.standalone = options.isStandalone;
        this.fileExtension = options.file_extension;
        this.cellType = options.cellType;
    }
    /**
     * Test if there is any foreign code in provided code snippet.
     */
    hasForeignCode(code, cellType) {
        return this.cellType.includes(cellType);
    }
    /**
     * Split the code into the host and foreign code (if any foreign code was detected)
     */
    extractForeignCode(code) {
        let lines = code.split('\n');
        let extracts = new Array();
        let foreignCodeFragment = code;
        let start = positionAtOffset(0, lines);
        let end = positionAtOffset(foreignCodeFragment.length, lines);
        extracts.push({
            hostCode: '',
            foreignCode: foreignCodeFragment,
            range: { start, end },
            virtualShift: null
        });
        return extracts;
    }
}
//# sourceMappingURL=text_extractor.js.map