import { ReadonlyJSONObject, ReadonlyJSONValue } from '@lumino/coreutils';
/**
 * Helper to wait for timeout.
 *
 * @param  timeout - time out in ms
 */
export declare function sleep(timeout: number): Promise<void>;
/**
 * Wait for an event by pooling the `isReady` function.
 */
export declare function untilReady(isReady: CallableFunction, maxRetrials?: number, interval?: number, intervalModifier?: (i: number) => number): Promise<CallableFunction>;
/**
 * Convert dotted path into dictionary.
 */
export declare function expandDottedPaths(obj: ReadonlyJSONObject): ReadonlyJSONObject;
/**
 * The docs for many language servers show settings in the
 * VSCode format, e.g.: "pyls.plugins.pyflakes.enabled"
 *
 * VSCode converts that dot notation to JSON behind the scenes,
 * as the language servers themselves don't accept that syntax.
 */
export declare const expandPath: (path: string[], value: ReadonlyJSONValue) => ReadonlyJSONObject;
/**
 * An extended map which will create value for key on the fly.
 */
export declare class DefaultMap<K, V> extends Map<K, V> {
    private defaultFactory;
    constructor(defaultFactory: (...args: any[]) => V, entries?: ReadonlyArray<readonly [K, V]> | null);
    get(k: K): V;
    getOrCreate(k: K, ...args: any[]): V;
}
