# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateVulnerabilityAuditDetails(object):
    """
    Details to create a Vulnerability Audit.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateVulnerabilityAuditDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param knowledge_base_id:
            The value to assign to the knowledge_base_id property of this CreateVulnerabilityAuditDetails.
        :type knowledge_base_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateVulnerabilityAuditDetails.
        :type compartment_id: str

        :param application_dependencies:
            The value to assign to the application_dependencies property of this CreateVulnerabilityAuditDetails.
        :type application_dependencies: list[oci.adm.models.ApplicationDependency]

        :param build_type:
            The value to assign to the build_type property of this CreateVulnerabilityAuditDetails.
        :type build_type: str

        :param configuration:
            The value to assign to the configuration property of this CreateVulnerabilityAuditDetails.
        :type configuration: oci.adm.models.VulnerabilityAuditConfiguration

        :param display_name:
            The value to assign to the display_name property of this CreateVulnerabilityAuditDetails.
        :type display_name: str

        :param source:
            The value to assign to the source property of this CreateVulnerabilityAuditDetails.
        :type source: oci.adm.models.VulnerabilityAuditSource

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateVulnerabilityAuditDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateVulnerabilityAuditDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'knowledge_base_id': 'str',
            'compartment_id': 'str',
            'application_dependencies': 'list[ApplicationDependency]',
            'build_type': 'str',
            'configuration': 'VulnerabilityAuditConfiguration',
            'display_name': 'str',
            'source': 'VulnerabilityAuditSource',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'knowledge_base_id': 'knowledgeBaseId',
            'compartment_id': 'compartmentId',
            'application_dependencies': 'applicationDependencies',
            'build_type': 'buildType',
            'configuration': 'configuration',
            'display_name': 'displayName',
            'source': 'source',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }

        self._knowledge_base_id = None
        self._compartment_id = None
        self._application_dependencies = None
        self._build_type = None
        self._configuration = None
        self._display_name = None
        self._source = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def knowledge_base_id(self):
        """
        **[Required]** Gets the knowledge_base_id of this CreateVulnerabilityAuditDetails.
        The Oracle Cloud identifier (`OCID`__) of the Knowledge Base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The knowledge_base_id of this CreateVulnerabilityAuditDetails.
        :rtype: str
        """
        return self._knowledge_base_id

    @knowledge_base_id.setter
    def knowledge_base_id(self, knowledge_base_id):
        """
        Sets the knowledge_base_id of this CreateVulnerabilityAuditDetails.
        The Oracle Cloud identifier (`OCID`__) of the Knowledge Base.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param knowledge_base_id: The knowledge_base_id of this CreateVulnerabilityAuditDetails.
        :type: str
        """
        self._knowledge_base_id = knowledge_base_id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this CreateVulnerabilityAuditDetails.
        The Oracle Cloud identifier (`OCID`__) of the compartment associated with the Vulnerability Audit.
        If compartment identifier is not provided the compartment of the associated Knowledge Base will be used instead.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateVulnerabilityAuditDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateVulnerabilityAuditDetails.
        The Oracle Cloud identifier (`OCID`__) of the compartment associated with the Vulnerability Audit.
        If compartment identifier is not provided the compartment of the associated Knowledge Base will be used instead.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateVulnerabilityAuditDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def application_dependencies(self):
        """
        Gets the application_dependencies of this CreateVulnerabilityAuditDetails.
        List of Application Dependencies (without vulnerabilities).


        :return: The application_dependencies of this CreateVulnerabilityAuditDetails.
        :rtype: list[oci.adm.models.ApplicationDependency]
        """
        return self._application_dependencies

    @application_dependencies.setter
    def application_dependencies(self, application_dependencies):
        """
        Sets the application_dependencies of this CreateVulnerabilityAuditDetails.
        List of Application Dependencies (without vulnerabilities).


        :param application_dependencies: The application_dependencies of this CreateVulnerabilityAuditDetails.
        :type: list[oci.adm.models.ApplicationDependency]
        """
        self._application_dependencies = application_dependencies

    @property
    def build_type(self):
        """
        **[Required]** Gets the build_type of this CreateVulnerabilityAuditDetails.
        The type of the build tool.


        :return: The build_type of this CreateVulnerabilityAuditDetails.
        :rtype: str
        """
        return self._build_type

    @build_type.setter
    def build_type(self, build_type):
        """
        Sets the build_type of this CreateVulnerabilityAuditDetails.
        The type of the build tool.


        :param build_type: The build_type of this CreateVulnerabilityAuditDetails.
        :type: str
        """
        self._build_type = build_type

    @property
    def configuration(self):
        """
        Gets the configuration of this CreateVulnerabilityAuditDetails.

        :return: The configuration of this CreateVulnerabilityAuditDetails.
        :rtype: oci.adm.models.VulnerabilityAuditConfiguration
        """
        return self._configuration

    @configuration.setter
    def configuration(self, configuration):
        """
        Sets the configuration of this CreateVulnerabilityAuditDetails.

        :param configuration: The configuration of this CreateVulnerabilityAuditDetails.
        :type: oci.adm.models.VulnerabilityAuditConfiguration
        """
        self._configuration = configuration

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateVulnerabilityAuditDetails.
        The name of the Vulnerability Audit.


        :return: The display_name of this CreateVulnerabilityAuditDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateVulnerabilityAuditDetails.
        The name of the Vulnerability Audit.


        :param display_name: The display_name of this CreateVulnerabilityAuditDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def source(self):
        """
        Gets the source of this CreateVulnerabilityAuditDetails.

        :return: The source of this CreateVulnerabilityAuditDetails.
        :rtype: oci.adm.models.VulnerabilityAuditSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateVulnerabilityAuditDetails.

        :param source: The source of this CreateVulnerabilityAuditDetails.
        :type: oci.adm.models.VulnerabilityAuditSource
        """
        self._source = source

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateVulnerabilityAuditDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateVulnerabilityAuditDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateVulnerabilityAuditDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateVulnerabilityAuditDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateVulnerabilityAuditDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateVulnerabilityAuditDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateVulnerabilityAuditDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateVulnerabilityAuditDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
