# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BatchLanguageTranslationDetails(object):
    """
    The documents details for translation call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BatchLanguageTranslationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this BatchLanguageTranslationDetails.
        :type compartment_id: str

        :param target_language_code:
            The value to assign to the target_language_code property of this BatchLanguageTranslationDetails.
        :type target_language_code: str

        :param documents:
            The value to assign to the documents property of this BatchLanguageTranslationDetails.
        :type documents: list[oci.ai_language.models.TextDocument]

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'target_language_code': 'str',
            'documents': 'list[TextDocument]'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'target_language_code': 'targetLanguageCode',
            'documents': 'documents'
        }

        self._compartment_id = None
        self._target_language_code = None
        self._documents = None

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this BatchLanguageTranslationDetails.
        The `OCID`__ of the compartment that calls the API, inference will be served from pre trained model

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BatchLanguageTranslationDetails.
        The `OCID`__ of the compartment that calls the API, inference will be served from pre trained model

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def target_language_code(self):
        """
        Gets the target_language_code of this BatchLanguageTranslationDetails.
        Language code supported
        - auto : Automatically detect language
        - ar : Arabic
        - pt-BR : Brazilian Portuguese
        - cs : Czech
        - da : Danish
        - nl : Dutch
        - en : English
        - fi : Finnish
        - fr : French
        - fr-CA : Canadian French
        - de : German
        - it : Italian
        - ja : Japanese
        - ko : Korean
        - no : Norwegian
        - pl : Polish
        - ro : Romanian
        - zh-CN : Simplified Chinese
        - es : Spanish
        - sv : Swedish
        - zh-TW : Traditional Chinese
        - tr : Turkish
        - el : Greek
        - he : Hebrew


        :return: The target_language_code of this BatchLanguageTranslationDetails.
        :rtype: str
        """
        return self._target_language_code

    @target_language_code.setter
    def target_language_code(self, target_language_code):
        """
        Sets the target_language_code of this BatchLanguageTranslationDetails.
        Language code supported
        - auto : Automatically detect language
        - ar : Arabic
        - pt-BR : Brazilian Portuguese
        - cs : Czech
        - da : Danish
        - nl : Dutch
        - en : English
        - fi : Finnish
        - fr : French
        - fr-CA : Canadian French
        - de : German
        - it : Italian
        - ja : Japanese
        - ko : Korean
        - no : Norwegian
        - pl : Polish
        - ro : Romanian
        - zh-CN : Simplified Chinese
        - es : Spanish
        - sv : Swedish
        - zh-TW : Traditional Chinese
        - tr : Turkish
        - el : Greek
        - he : Hebrew


        :param target_language_code: The target_language_code of this BatchLanguageTranslationDetails.
        :type: str
        """
        self._target_language_code = target_language_code

    @property
    def documents(self):
        """
        **[Required]** Gets the documents of this BatchLanguageTranslationDetails.
        List of documents for translation.


        :return: The documents of this BatchLanguageTranslationDetails.
        :rtype: list[oci.ai_language.models.TextDocument]
        """
        return self._documents

    @documents.setter
    def documents(self, documents):
        """
        Sets the documents of this BatchLanguageTranslationDetails.
        List of documents for translation.


        :param documents: The documents of this BatchLanguageTranslationDetails.
        :type: list[oci.ai_language.models.TextDocument]
        """
        self._documents = documents

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
