# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .attach_volume_details import AttachVolumeDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachIScsiVolumeDetails(AttachVolumeDetails):
    """
    AttachIScsiVolumeDetails model.
    """

    #: A constant which can be used with the encryption_in_transit_type property of a AttachIScsiVolumeDetails.
    #: This constant has a value of "NONE"
    ENCRYPTION_IN_TRANSIT_TYPE_NONE = "NONE"

    #: A constant which can be used with the encryption_in_transit_type property of a AttachIScsiVolumeDetails.
    #: This constant has a value of "BM_ENCRYPTION_IN_TRANSIT"
    ENCRYPTION_IN_TRANSIT_TYPE_BM_ENCRYPTION_IN_TRANSIT = "BM_ENCRYPTION_IN_TRANSIT"

    def __init__(self, **kwargs):
        """
        Initializes a new AttachIScsiVolumeDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.core.models.AttachIScsiVolumeDetails.type` attribute
        of this class is ``iscsi`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param device:
            The value to assign to the device property of this AttachIScsiVolumeDetails.
        :type device: str

        :param display_name:
            The value to assign to the display_name property of this AttachIScsiVolumeDetails.
        :type display_name: str

        :param instance_id:
            The value to assign to the instance_id property of this AttachIScsiVolumeDetails.
        :type instance_id: str

        :param is_read_only:
            The value to assign to the is_read_only property of this AttachIScsiVolumeDetails.
        :type is_read_only: bool

        :param is_shareable:
            The value to assign to the is_shareable property of this AttachIScsiVolumeDetails.
        :type is_shareable: bool

        :param type:
            The value to assign to the type property of this AttachIScsiVolumeDetails.
        :type type: str

        :param volume_id:
            The value to assign to the volume_id property of this AttachIScsiVolumeDetails.
        :type volume_id: str

        :param use_chap:
            The value to assign to the use_chap property of this AttachIScsiVolumeDetails.
        :type use_chap: bool

        :param encryption_in_transit_type:
            The value to assign to the encryption_in_transit_type property of this AttachIScsiVolumeDetails.
            Allowed values for this property are: "NONE", "BM_ENCRYPTION_IN_TRANSIT"
        :type encryption_in_transit_type: str

        :param is_agent_auto_iscsi_login_enabled:
            The value to assign to the is_agent_auto_iscsi_login_enabled property of this AttachIScsiVolumeDetails.
        :type is_agent_auto_iscsi_login_enabled: bool

        """
        self.swagger_types = {
            'device': 'str',
            'display_name': 'str',
            'instance_id': 'str',
            'is_read_only': 'bool',
            'is_shareable': 'bool',
            'type': 'str',
            'volume_id': 'str',
            'use_chap': 'bool',
            'encryption_in_transit_type': 'str',
            'is_agent_auto_iscsi_login_enabled': 'bool'
        }

        self.attribute_map = {
            'device': 'device',
            'display_name': 'displayName',
            'instance_id': 'instanceId',
            'is_read_only': 'isReadOnly',
            'is_shareable': 'isShareable',
            'type': 'type',
            'volume_id': 'volumeId',
            'use_chap': 'useChap',
            'encryption_in_transit_type': 'encryptionInTransitType',
            'is_agent_auto_iscsi_login_enabled': 'isAgentAutoIscsiLoginEnabled'
        }

        self._device = None
        self._display_name = None
        self._instance_id = None
        self._is_read_only = None
        self._is_shareable = None
        self._type = None
        self._volume_id = None
        self._use_chap = None
        self._encryption_in_transit_type = None
        self._is_agent_auto_iscsi_login_enabled = None
        self._type = 'iscsi'

    @property
    def use_chap(self):
        """
        Gets the use_chap of this AttachIScsiVolumeDetails.
        Whether to use CHAP authentication for the volume attachment. Defaults to false.


        :return: The use_chap of this AttachIScsiVolumeDetails.
        :rtype: bool
        """
        return self._use_chap

    @use_chap.setter
    def use_chap(self, use_chap):
        """
        Sets the use_chap of this AttachIScsiVolumeDetails.
        Whether to use CHAP authentication for the volume attachment. Defaults to false.


        :param use_chap: The use_chap of this AttachIScsiVolumeDetails.
        :type: bool
        """
        self._use_chap = use_chap

    @property
    def encryption_in_transit_type(self):
        """
        Gets the encryption_in_transit_type of this AttachIScsiVolumeDetails.
        Refer the top-level definition of encryptionInTransitType.
        The default value is NONE.

        Allowed values for this property are: "NONE", "BM_ENCRYPTION_IN_TRANSIT"


        :return: The encryption_in_transit_type of this AttachIScsiVolumeDetails.
        :rtype: str
        """
        return self._encryption_in_transit_type

    @encryption_in_transit_type.setter
    def encryption_in_transit_type(self, encryption_in_transit_type):
        """
        Sets the encryption_in_transit_type of this AttachIScsiVolumeDetails.
        Refer the top-level definition of encryptionInTransitType.
        The default value is NONE.


        :param encryption_in_transit_type: The encryption_in_transit_type of this AttachIScsiVolumeDetails.
        :type: str
        """
        allowed_values = ["NONE", "BM_ENCRYPTION_IN_TRANSIT"]
        if not value_allowed_none_or_none_sentinel(encryption_in_transit_type, allowed_values):
            raise ValueError(
                f"Invalid value for `encryption_in_transit_type`, must be None or one of {allowed_values}"
            )
        self._encryption_in_transit_type = encryption_in_transit_type

    @property
    def is_agent_auto_iscsi_login_enabled(self):
        """
        Gets the is_agent_auto_iscsi_login_enabled of this AttachIScsiVolumeDetails.
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.


        :return: The is_agent_auto_iscsi_login_enabled of this AttachIScsiVolumeDetails.
        :rtype: bool
        """
        return self._is_agent_auto_iscsi_login_enabled

    @is_agent_auto_iscsi_login_enabled.setter
    def is_agent_auto_iscsi_login_enabled(self, is_agent_auto_iscsi_login_enabled):
        """
        Sets the is_agent_auto_iscsi_login_enabled of this AttachIScsiVolumeDetails.
        Whether to enable Oracle Cloud Agent to perform the iSCSI login and logout commands after the volume attach or detach operations for non multipath-enabled iSCSI attachments.


        :param is_agent_auto_iscsi_login_enabled: The is_agent_auto_iscsi_login_enabled of this AttachIScsiVolumeDetails.
        :type: bool
        """
        self._is_agent_auto_iscsi_login_enabled = is_agent_auto_iscsi_login_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
