# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails(object):
    """
    Optional. Used to specify from which subnet prefixes an IPv6 address should be allocated, or to assign valid available IPv6 addresses.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ipv6_subnet_cidr:
            The value to assign to the ipv6_subnet_cidr property of this InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails.
        :type ipv6_subnet_cidr: str

        """
        self.swagger_types = {
            'ipv6_subnet_cidr': 'str'
        }

        self.attribute_map = {
            'ipv6_subnet_cidr': 'ipv6SubnetCidr'
        }

        self._ipv6_subnet_cidr = None

    @property
    def ipv6_subnet_cidr(self):
        """
        Gets the ipv6_subnet_cidr of this InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails.
        Optional. Used to disambiguate which subnet prefix should be used to create an IPv6 allocation.


        :return: The ipv6_subnet_cidr of this InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails.
        :rtype: str
        """
        return self._ipv6_subnet_cidr

    @ipv6_subnet_cidr.setter
    def ipv6_subnet_cidr(self, ipv6_subnet_cidr):
        """
        Sets the ipv6_subnet_cidr of this InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails.
        Optional. Used to disambiguate which subnet prefix should be used to create an IPv6 allocation.


        :param ipv6_subnet_cidr: The ipv6_subnet_cidr of this InstancePoolPlacementIpv6AddressIpv6SubnetCidrDetails.
        :type: str
        """
        self._ipv6_subnet_cidr = ipv6_subnet_cidr

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
