# coding: utf-8
# Copyright (c) 2016, 2023, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101

from .sql_tuning_set_admin_credential_details import SqlTuningSetAdminCredentialDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SqlTuningSetAdminSecretCredentialDetails(SqlTuningSetAdminCredentialDetails):
    """
    User provides a secret OCID, which will be used to retrieve the password to connect to the database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SqlTuningSetAdminSecretCredentialDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.database_management.models.SqlTuningSetAdminSecretCredentialDetails.sql_tuning_set_admin_credential_type` attribute
        of this class is ``SECRET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sql_tuning_set_admin_credential_type:
            The value to assign to the sql_tuning_set_admin_credential_type property of this SqlTuningSetAdminSecretCredentialDetails.
            Allowed values for this property are: "SECRET", "PASSWORD"
        :type sql_tuning_set_admin_credential_type: str

        :param username:
            The value to assign to the username property of this SqlTuningSetAdminSecretCredentialDetails.
        :type username: str

        :param role:
            The value to assign to the role property of this SqlTuningSetAdminSecretCredentialDetails.
            Allowed values for this property are: "NORMAL", "SYSDBA"
        :type role: str

        :param secret_id:
            The value to assign to the secret_id property of this SqlTuningSetAdminSecretCredentialDetails.
        :type secret_id: str

        """
        self.swagger_types = {
            'sql_tuning_set_admin_credential_type': 'str',
            'username': 'str',
            'role': 'str',
            'secret_id': 'str'
        }

        self.attribute_map = {
            'sql_tuning_set_admin_credential_type': 'sqlTuningSetAdminCredentialType',
            'username': 'username',
            'role': 'role',
            'secret_id': 'secretId'
        }

        self._sql_tuning_set_admin_credential_type = None
        self._username = None
        self._role = None
        self._secret_id = None
        self._sql_tuning_set_admin_credential_type = 'SECRET'

    @property
    def secret_id(self):
        """
        **[Required]** Gets the secret_id of this SqlTuningSetAdminSecretCredentialDetails.
        The `OCID`__ of the Secret
        where the database password is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The secret_id of this SqlTuningSetAdminSecretCredentialDetails.
        :rtype: str
        """
        return self._secret_id

    @secret_id.setter
    def secret_id(self, secret_id):
        """
        Sets the secret_id of this SqlTuningSetAdminSecretCredentialDetails.
        The `OCID`__ of the Secret
        where the database password is stored.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param secret_id: The secret_id of this SqlTuningSetAdminSecretCredentialDetails.
        :type: str
        """
        self._secret_id = secret_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
